/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.services;

import android.annotation.TargetApi;
import android.app.Notification;
import android.content.Context;
import com.liulishuo.filedownloader.R;
import com.liulishuo.filedownloader.util.FileDownloadLog;

@TargetApi(value=26)
public class ForegroundServiceConfig {
    private int notificationId;
    private String notificationChannelId;
    private String notificationChannelName;
    private Notification notification;
    private boolean needRecreateChannelId;
    private static final String DEFAULT_NOTIFICATION_CHANNEL_ID = "filedownloader_channel";
    private static final String DEFAULT_NOTIFICATION_CHANNEL_NAME = "Filedownloader";
    private static final int DEFAULT_NOTIFICATION_ID = 17301506;

    private ForegroundServiceConfig() {
    }

    public int getNotificationId() {
        return this.notificationId;
    }

    public String getNotificationChannelId() {
        return this.notificationChannelId;
    }

    public String getNotificationChannelName() {
        return this.notificationChannelName;
    }

    public Notification getNotification(Context context) {
        if (this.notification == null) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "build default notification", new Object[0]);
            }
            this.notification = this.buildDefaultNotification(context);
        }
        return this.notification;
    }

    public boolean isNeedRecreateChannelId() {
        return this.needRecreateChannelId;
    }

    public void setNotificationId(int notificationId) {
        this.notificationId = notificationId;
    }

    public void setNotificationChannelId(String notificationChannelId) {
        this.notificationChannelId = notificationChannelId;
    }

    public void setNotificationChannelName(String notificationChannelName) {
        this.notificationChannelName = notificationChannelName;
    }

    public void setNotification(Notification notification) {
        this.notification = notification;
    }

    public void setNeedRecreateChannelId(boolean needRecreateChannelId) {
        this.needRecreateChannelId = needRecreateChannelId;
    }

    private Notification buildDefaultNotification(Context context) {
        String title = context.getString(R.string.default_filedownloader_notification_title);
        String content = context.getString(R.string.default_filedownloader_notification_content);
        Notification.Builder builder = new Notification.Builder(context, this.notificationChannelId);
        builder.setContentTitle((CharSequence)title).setContentText((CharSequence)content).setSmallIcon(17301506);
        return builder.build();
    }

    public String toString() {
        return "ForegroundServiceConfig{notificationId=" + this.notificationId + ", notificationChannelId='" + this.notificationChannelId + '\'' + ", notificationChannelName='" + this.notificationChannelName + '\'' + ", notification=" + this.notification + ", needRecreateChannelId=" + this.needRecreateChannelId + '}';
    }

    public static class Builder {
        private int notificationId;
        private String notificationChannelId;
        private String notificationChannelName;
        private Notification notification;
        private boolean needRecreateChannelId;

        public Builder notificationId(int notificationId) {
            this.notificationId = notificationId;
            return this;
        }

        public Builder notificationChannelId(String notificationChannelId) {
            this.notificationChannelId = notificationChannelId;
            return this;
        }

        public Builder notificationChannelName(String notificationChannelName) {
            this.notificationChannelName = notificationChannelName;
            return this;
        }

        public Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public Builder needRecreateChannelId(boolean needRecreateChannelId) {
            this.needRecreateChannelId = needRecreateChannelId;
            return this;
        }

        public ForegroundServiceConfig build() {
            ForegroundServiceConfig config = new ForegroundServiceConfig();
            config.setNotificationChannelId(this.notificationChannelId == null ? ForegroundServiceConfig.DEFAULT_NOTIFICATION_CHANNEL_ID : this.notificationChannelId);
            config.setNotificationChannelName(this.notificationChannelName == null ? ForegroundServiceConfig.DEFAULT_NOTIFICATION_CHANNEL_NAME : this.notificationChannelName);
            config.setNotificationId(this.notificationId == 0 ? 17301506 : this.notificationId);
            config.setNeedRecreateChannelId(this.needRecreateChannelId);
            config.setNotification(this.notification);
            return config;
        }
    }
}

