/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.api.report;

import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.report.RCRTCLiveAudioState;
import cn.rongcloud.rtc.api.report.StatusReportParser;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.center.RCRoomImpl;
import cn.rongcloud.rtc.core.StatsObserver;
import cn.rongcloud.rtc.core.StatsReport;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.webrtc.BaseStatusReportManager;
import cn.rongcloud.rtc.webrtc.RTCConnectionHolder;
import java.util.ArrayList;
import java.util.List;

public class RTCStatusReportManager
extends BaseStatusReportManager {
    private static final String TAG = "RTCStatusReportManager";
    private volatile long mSsrc = -1L;
    private StatsObserver volumeStatsObserver = new StatsObserver(){

        @Override
        public void onComplete(StatsReport[] reports) {
            if (null != reports && 0 < reports.length) {
                RCRoomImpl room = (RCRoomImpl)RTCEngineImpl.getInstance().getRoom();
                if (null == room) {
                    return;
                }
                List<RCRTCRemoteUser> remoteUsers = room.getRemoteUsers();
                if (null == remoteUsers) {
                    return;
                }
                ArrayList<RCRTCLiveAudioState> audioStates = new ArrayList<RCRTCLiveAudioState>();
                for (int i = 0; i < reports.length; ++i) {
                    StatsReport.Value[] values = reports[i].values;
                    String audioOutputLevel = null;
                    String ssrc = null;
                    for (int j = 0; j < values.length; ++j) {
                        StatusReportParser parser;
                        RCRTCInputStream stream;
                        if (values[j].name.equals("audioOutputLevel")) {
                            audioOutputLevel = values[j].value;
                        } else if (values[j].name.equals("ssrc")) {
                            ssrc = values[j].value;
                        }
                        if (null == audioOutputLevel || null == ssrc || null == (stream = RTCStatusReportManager.this.hasSsrc(ssrc, remoteUsers)) || null == (parser = RTCStatusReportManager.this.mStatusParser)) continue;
                        RCRTCLiveAudioState.Builder builder = new RCRTCLiveAudioState.Builder();
                        RCRTCLiveAudioState audioState = builder.setUserId(stream.getUserId()).setStreamId(stream.getStreamId()).setAudioLevel(parser.getAudioInputLevel(audioOutputLevel)).build();
                        audioStates.add(audioState);
                    }
                }
                RTCStatusReportManager.this.mListener.reportLiveAudioStates(audioStates);
            } else {
                RTCStatusReportManager.this.mListener.reportLiveAudioStates(new ArrayList<RCRTCLiveAudioState>());
            }
        }
    };

    public RTCStatusReportManager(RTCConnectionHolder connection, long interval) {
        super(connection, interval);
    }

    private RCRTCInputStream hasSsrc(String ssrc, List<RCRTCRemoteUser> remoteUserList) {
        for (RCRTCRemoteUser user : remoteUserList) {
            List<RCRTCInputStream> streams = user.getStreams();
            if (null == streams) continue;
            for (RCRTCInputStream stream : streams) {
                if (RCRTCMediaType.AUDIO != stream.getMediaType()) continue;
                try {
                    if (!(stream.getSsrc() + "").equals(ssrc)) continue;
                    return stream;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @Override
    protected void onGetStatus(RTCConnectionHolder connection) {
        super.onGetStatus(connection);
        if (-1L != this.mSsrc) {
            connection.getMcuVolume(this.volumeStatsObserver, this.mSsrc);
        }
    }

    public void setSsrc(long ssrc) {
        this.mSsrc = ssrc;
    }

    @Override
    public void stop() {
        super.stop();
        this.mSsrc = -1L;
    }
}

