/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.utils;

import android.app.Application;
import android.content.Context;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import com.daya.orchestra.accompany.common.Constants;

public class Utils {
    private static Application sApp;
    private static final int MIN_CLICK_DELAY_TIME = 1000;
    private static long lastClickTime;

    public static void init(Application application) {
        sApp = application;
    }

    public static Application getApp() {
        return sApp;
    }

    public static String checkType(Context context) {
        if (context == null) {
            return null;
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (Build.VERSION.SDK_INT >= 23) {
            AudioDeviceInfo[] devices = audioManager.getDevices(2);
            String result = null;
            for (AudioDeviceInfo device : devices) {
                int deviceType = device.getType();
                if (deviceType == 3 || deviceType == 4) {
                    result = "\u6709\u7ebf\u8033\u673a";
                }
                if (deviceType != 8 && deviceType != 7) continue;
                result = "\u84dd\u7259\u8033\u673a";
            }
            if (TextUtils.isEmpty(result)) {
                if (Constants.HEADSET_PLUE_TAG.isEmpty()) {
                    return null;
                }
                return "\u6709\u7ebf\u8033\u673a";
            }
            return result;
        }
        if (audioManager.isWiredHeadsetOn()) {
            return "\u6709\u7ebf\u8033\u673a";
        }
        if (audioManager.isBluetoothScoOn() || audioManager.isBluetoothA2dpOn()) {
            return "\u84dd\u7259\u8033\u673a";
        }
        return null;
    }

    public static boolean isMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static boolean isFastClick() {
        boolean flag = false;
        long curClickTime = System.currentTimeMillis();
        if (curClickTime - lastClickTime < 1000L) {
            flag = true;
        }
        lastClickTime = curClickTime;
        return flag;
    }

    public static boolean isFastClick(long timeLimit) {
        boolean flag = false;
        long curClickTime = System.currentTimeMillis();
        if (curClickTime - lastClickTime < timeLimit) {
            flag = true;
        }
        lastClickTime = curClickTime;
        return flag;
    }
}

