/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.file;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetManager;
import android.net.Uri;
import com.jinmingyunle.midiplaylib.midifile.MidiFileException;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Comparator;
import org.json.JSONException;
import org.json.JSONObject;

public class FileUri
implements Comparator<FileUri> {
    private Uri uri;
    private String displayName;

    public FileUri(Uri uri, String path) {
        this.uri = uri;
        if (path == null) {
            path = uri.getLastPathSegment();
        }
        this.displayName = FileUri.displayNameFromPath(path);
    }

    public static String displayNameFromPath(String path) {
        String displayName = path;
        displayName = displayName.replace("__", ": ");
        displayName = displayName.replace("_", " ");
        displayName = displayName.replace(".mid", "");
        return displayName;
    }

    public String toString() {
        return this.displayName;
    }

    public boolean isDirectory() {
        String path = this.uri.getPath();
        return path != null && path.endsWith("/");
    }

    public Uri getUri() {
        return this.uri;
    }

    @Override
    public int compare(FileUri f1, FileUri f2) {
        return f1.displayName.compareToIgnoreCase(f2.displayName);
    }

    public byte[] getData(Context activity) {
        try {
            ContentResolver resolver;
            InputStream file;
            String filepath;
            AssetManager asset;
            byte[] data = new byte[4096];
            String uriString = this.uri.toString();
            if (uriString.startsWith("file:///android_asset/")) {
                asset = activity.getResources().getAssets();
                filepath = uriString.replace("file:///android_asset/", "");
                file = asset.open(filepath);
            } else if (uriString.startsWith("content://")) {
                resolver = activity.getContentResolver();
                file = resolver.openInputStream(this.uri);
            } else {
                file = new FileInputStream(this.uri.getPath());
            }
            int totallen = 0;
            int len = file.read(data, 0, 4096);
            while (len > 0) {
                totallen += len;
                len = file.read(data, 0, 4096);
            }
            file.close();
            int offset = 0;
            data = new byte[totallen];
            if (uriString.startsWith("file:///android_asset/")) {
                asset = activity.getResources().getAssets();
                filepath = uriString.replace("file:///android_asset/", "");
                file = asset.open(filepath);
            } else if (uriString.startsWith("content://")) {
                resolver = activity.getContentResolver();
                file = resolver.openInputStream(this.uri);
            } else {
                file = new FileInputStream(this.uri.getPath());
            }
            while (offset < totallen) {
                len = file.read(data, offset, totallen - offset);
                if (len <= 0) {
                    throw new MidiFileException("Error reading midi file", offset);
                }
                offset += len;
            }
            return data;
        }
        catch (Exception e) {
            return null;
        }
    }

    public JSONObject toJson() {
        try {
            JSONObject json = new JSONObject();
            json.put("uri", (Object)this.uri.toString());
            json.put("displayName", (Object)this.displayName);
            return json;
        }
        catch (JSONException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static FileUri fromJson(JSONObject obj, Activity activity) {
        try {
            String displayName = obj.optString("displayName", null);
            String uriString = obj.optString("uri", null);
            if (displayName == null || uriString == null) {
                return null;
            }
            Uri uri = Uri.parse((String)uriString);
            return new FileUri(uri, displayName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean equalStrings(String s1, String s2) {
        if (s1 == null && s2 != null || s1 != null && s2 == null) {
            return false;
        }
        if (s1 == null && s2 == null) {
            return true;
        }
        return s1.equals(s2);
    }

    public static boolean equalJson(JSONObject obj1, JSONObject obj2) {
        String displayName1 = obj1.optString("displayName", null);
        String uriString1 = obj1.optString("uri", null);
        String displayName2 = obj2.optString("displayName", null);
        String uriString2 = obj2.optString("uri", null);
        return FileUri.equalStrings(displayName1, displayName2) && FileUri.equalStrings(uriString1, uriString2);
    }
}

