/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.sheetmusic;

import com.jinmingyunle.midiplaylib.symbol.AccidSymbol;
import com.jinmingyunle.midiplaylib.symbol.Clef;
import com.jinmingyunle.midiplaylib.utils.ListInt;
import com.jinmingyunle.midiplaylib.utils.NoteScale;
import com.jinmingyunle.midiplaylib.view.Accid;
import com.jinmingyunle.midiplaylib.view.WhiteNote;

public class KeySignature {
    public static final int C = 0;
    public static final int G = 1;
    public static final int D = 2;
    public static final int A = 3;
    public static final int E = 4;
    public static final int B = 5;
    public static final int F = 1;
    public static final int Bflat = 2;
    public static final int Eflat = 3;
    public static final int Aflat = 4;
    public static final int Dflat = 5;
    public static final int Gflat = 6;
    private static Accid[][] sharpkeys;
    private static Accid[][] flatkeys;
    private int num_flats;
    private int num_sharps;
    private AccidSymbol[] treble;
    private AccidSymbol[] bass;
    private Accid[] keymap;
    private int prevmeasure;

    public KeySignature(int num_sharps, int num_flats) {
        if (num_sharps != 0 && num_flats != 0) {
            throw new IllegalArgumentException();
        }
        this.num_sharps = num_sharps;
        this.num_flats = num_flats;
        KeySignature.CreateAccidentalMaps();
        this.keymap = new Accid[160];
        this.ResetKeyMap();
        this.CreateSymbols();
    }

    public KeySignature(int notescale) {
        this.num_flats = 0;
        this.num_sharps = 0;
        switch (notescale) {
            case 0: {
                this.num_sharps = 3;
                break;
            }
            case 1: {
                this.num_flats = 2;
                break;
            }
            case 2: {
                this.num_sharps = 5;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.num_flats = 5;
                break;
            }
            case 5: {
                this.num_sharps = 2;
                break;
            }
            case 6: {
                this.num_flats = 3;
                break;
            }
            case 7: {
                this.num_sharps = 4;
                break;
            }
            case 8: {
                this.num_flats = 1;
                break;
            }
            case 9: {
                this.num_flats = 6;
                break;
            }
            case 10: {
                this.num_sharps = 1;
                break;
            }
            case 11: {
                this.num_flats = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        KeySignature.CreateAccidentalMaps();
        this.keymap = new Accid[160];
        this.ResetKeyMap();
        this.CreateSymbols();
    }

    private static void CreateAccidentalMaps() {
        if (sharpkeys != null) {
            return;
        }
        sharpkeys = new Accid[8][];
        flatkeys = new Accid[8][];
        for (int i = 0; i < 8; ++i) {
            KeySignature.sharpkeys[i] = new Accid[12];
            KeySignature.flatkeys[i] = new Accid[12];
        }
        Accid[] map = sharpkeys[0];
        map[0] = Accid.None;
        map[1] = Accid.Flat;
        map[2] = Accid.None;
        map[3] = Accid.None;
        map[4] = Accid.Sharp;
        map[5] = Accid.None;
        map[6] = Accid.Sharp;
        map[7] = Accid.None;
        map[8] = Accid.None;
        map[9] = Accid.Sharp;
        map[10] = Accid.None;
        map[11] = Accid.Sharp;
        map = sharpkeys[1];
        map[0] = Accid.None;
        map[1] = Accid.Flat;
        map[2] = Accid.None;
        map[3] = Accid.None;
        map[4] = Accid.Sharp;
        map[5] = Accid.None;
        map[6] = Accid.Sharp;
        map[7] = Accid.None;
        map[8] = Accid.Natural;
        map[9] = Accid.None;
        map[10] = Accid.None;
        map[11] = Accid.Sharp;
        map = sharpkeys[2];
        map[0] = Accid.None;
        map[1] = Accid.Flat;
        map[2] = Accid.None;
        map[3] = Accid.Natural;
        map[4] = Accid.None;
        map[5] = Accid.None;
        map[6] = Accid.Sharp;
        map[7] = Accid.None;
        map[8] = Accid.Natural;
        map[9] = Accid.None;
        map[10] = Accid.None;
        map[11] = Accid.Sharp;
        map = sharpkeys[3];
        map[0] = Accid.None;
        map[1] = Accid.Flat;
        map[2] = Accid.None;
        map[3] = Accid.Natural;
        map[4] = Accid.None;
        map[5] = Accid.None;
        map[6] = Accid.Sharp;
        map[7] = Accid.None;
        map[8] = Accid.Natural;
        map[9] = Accid.None;
        map[10] = Accid.Natural;
        map[11] = Accid.None;
        map = sharpkeys[4];
        map[0] = Accid.None;
        map[1] = Accid.Flat;
        map[2] = Accid.None;
        map[3] = Accid.Natural;
        map[4] = Accid.None;
        map[5] = Accid.Natural;
        map[6] = Accid.None;
        map[7] = Accid.None;
        map[8] = Accid.Natural;
        map[9] = Accid.None;
        map[10] = Accid.Natural;
        map[11] = Accid.None;
        map = sharpkeys[5];
        map[0] = Accid.Natural;
        map[1] = Accid.None;
        map[2] = Accid.None;
        map[3] = Accid.Natural;
        map[4] = Accid.None;
        map[5] = Accid.Natural;
        map[6] = Accid.None;
        map[7] = Accid.None;
        map[8] = Accid.Natural;
        map[9] = Accid.None;
        map[10] = Accid.Natural;
        map[11] = Accid.None;
        map = flatkeys[0];
        map[0] = Accid.None;
        map[1] = Accid.Flat;
        map[2] = Accid.None;
        map[3] = Accid.None;
        map[4] = Accid.Sharp;
        map[5] = Accid.None;
        map[6] = Accid.Sharp;
        map[7] = Accid.None;
        map[8] = Accid.None;
        map[9] = Accid.Sharp;
        map[10] = Accid.None;
        map[11] = Accid.Sharp;
        map = flatkeys[1];
        map[0] = Accid.None;
        map[1] = Accid.None;
        map[2] = Accid.Natural;
        map[3] = Accid.None;
        map[4] = Accid.Sharp;
        map[5] = Accid.None;
        map[6] = Accid.Flat;
        map[7] = Accid.None;
        map[8] = Accid.None;
        map[9] = Accid.Sharp;
        map[10] = Accid.None;
        map[11] = Accid.Flat;
        map = flatkeys[2];
        map[0] = Accid.None;
        map[1] = Accid.None;
        map[2] = Accid.Natural;
        map[3] = Accid.None;
        map[4] = Accid.Sharp;
        map[5] = Accid.None;
        map[6] = Accid.None;
        map[7] = Accid.Natural;
        map[8] = Accid.None;
        map[9] = Accid.Sharp;
        map[10] = Accid.None;
        map[11] = Accid.Flat;
        map = flatkeys[3];
        map[0] = Accid.Natural;
        map[1] = Accid.None;
        map[2] = Accid.Natural;
        map[3] = Accid.None;
        map[4] = Accid.Flat;
        map[5] = Accid.None;
        map[6] = Accid.None;
        map[7] = Accid.Natural;
        map[8] = Accid.None;
        map[9] = Accid.Sharp;
        map[10] = Accid.None;
        map[11] = Accid.None;
        map = flatkeys[4];
        map[0] = Accid.Natural;
        map[1] = Accid.None;
        map[2] = Accid.Natural;
        map[3] = Accid.None;
        map[4] = Accid.None;
        map[5] = Accid.Natural;
        map[6] = Accid.None;
        map[7] = Accid.Natural;
        map[8] = Accid.None;
        map[9] = Accid.Sharp;
        map[10] = Accid.None;
        map[11] = Accid.None;
        map = flatkeys[5];
        map[0] = Accid.Natural;
        map[1] = Accid.None;
        map[2] = Accid.Natural;
        map[3] = Accid.None;
        map[4] = Accid.None;
        map[5] = Accid.Natural;
        map[6] = Accid.None;
        map[7] = Accid.Natural;
        map[8] = Accid.None;
        map[9] = Accid.None;
        map[10] = Accid.Natural;
        map[11] = Accid.None;
        map = flatkeys[6];
        map[0] = Accid.Natural;
        map[1] = Accid.None;
        map[2] = Accid.None;
        map[3] = Accid.Natural;
        map[4] = Accid.None;
        map[5] = Accid.Natural;
        map[6] = Accid.None;
        map[7] = Accid.Natural;
        map[8] = Accid.None;
        map[9] = Accid.None;
        map[10] = Accid.Natural;
        map[11] = Accid.None;
    }

    private void ResetKeyMap() {
        Accid[] key = this.num_flats > 0 ? flatkeys[this.num_flats] : sharpkeys[this.num_sharps];
        for (int notenumber = 0; notenumber < this.keymap.length; ++notenumber) {
            this.keymap[notenumber] = key[NoteScale.FromNumber(notenumber)];
        }
    }

    private void CreateSymbols() {
        int count = Math.max(this.num_sharps, this.num_flats);
        this.treble = new AccidSymbol[count];
        this.bass = new AccidSymbol[count];
        if (count == 0) {
            return;
        }
        WhiteNote[] treblenotes = null;
        WhiteNote[] bassnotes = null;
        if (this.num_sharps > 0) {
            treblenotes = new WhiteNote[]{new WhiteNote(5, 5), new WhiteNote(2, 5), new WhiteNote(6, 5), new WhiteNote(3, 5), new WhiteNote(0, 6), new WhiteNote(4, 5)};
            bassnotes = new WhiteNote[]{new WhiteNote(5, 3), new WhiteNote(2, 3), new WhiteNote(6, 3), new WhiteNote(3, 3), new WhiteNote(0, 4), new WhiteNote(4, 3)};
        } else if (this.num_flats > 0) {
            treblenotes = new WhiteNote[]{new WhiteNote(1, 5), new WhiteNote(4, 5), new WhiteNote(0, 5), new WhiteNote(3, 5), new WhiteNote(6, 4), new WhiteNote(2, 5)};
            bassnotes = new WhiteNote[]{new WhiteNote(1, 3), new WhiteNote(4, 3), new WhiteNote(0, 3), new WhiteNote(3, 3), new WhiteNote(6, 2), new WhiteNote(2, 3)};
        }
        Accid a = Accid.None;
        a = this.num_sharps > 0 ? Accid.Sharp : Accid.Flat;
        for (int i = 0; i < count; ++i) {
            this.treble[i] = new AccidSymbol(a, (WhiteNote)treblenotes[i], Clef.Treble);
            this.bass[i] = new AccidSymbol(a, (WhiteNote)bassnotes[i], Clef.Bass);
        }
    }

    public AccidSymbol[] GetSymbols(Clef clef) {
        if (clef == Clef.Treble) {
            return this.treble;
        }
        return this.bass;
    }

    public Accid GetAccidental(int notenumber, int measure) {
        if (measure != this.prevmeasure) {
            this.ResetKeyMap();
            this.prevmeasure = measure;
        }
        if (notenumber <= 1 || notenumber >= 127) {
            return Accid.None;
        }
        Accid result = this.keymap[notenumber];
        if (result == Accid.Sharp) {
            this.keymap[notenumber] = Accid.None;
            this.keymap[notenumber - 1] = Accid.Natural;
        } else if (result == Accid.Flat) {
            this.keymap[notenumber] = Accid.None;
            this.keymap[notenumber + 1] = Accid.Natural;
        } else if (result == Accid.Natural) {
            this.keymap[notenumber] = Accid.None;
            int nextkey = NoteScale.FromNumber(notenumber + 1);
            int prevkey = NoteScale.FromNumber(notenumber - 1);
            if (this.keymap[notenumber - 1] == Accid.None && this.keymap[notenumber + 1] == Accid.None && NoteScale.IsBlackKey(nextkey) && NoteScale.IsBlackKey(prevkey)) {
                if (this.num_flats == 0) {
                    this.keymap[notenumber + 1] = Accid.Sharp;
                } else {
                    this.keymap[notenumber - 1] = Accid.Flat;
                }
            } else if (this.keymap[notenumber - 1] == Accid.None && NoteScale.IsBlackKey(prevkey)) {
                this.keymap[notenumber - 1] = Accid.Flat;
            } else if (this.keymap[notenumber + 1] == Accid.None && NoteScale.IsBlackKey(nextkey)) {
                this.keymap[notenumber + 1] = Accid.Sharp;
            }
        }
        return result;
    }

    public WhiteNote GetWhiteNote(int notenumber) {
        int notescale = NoteScale.FromNumber(notenumber);
        int octave = (notenumber + 3) / 12 - 1;
        int letter = 0;
        int[] whole_sharps = new int[]{0, 0, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6};
        int[] whole_flats = new int[]{0, 1, 1, 2, 3, 3, 4, 4, 5, 6, 6, 0};
        Accid accid = this.keymap[notenumber];
        if (accid == Accid.Flat) {
            letter = whole_flats[notescale];
        } else if (accid == Accid.Sharp) {
            letter = whole_sharps[notescale];
        } else if (accid == Accid.Natural) {
            letter = whole_sharps[notescale];
        } else if (accid == Accid.None) {
            letter = whole_sharps[notescale];
            if (NoteScale.IsBlackKey(notescale)) {
                if (this.keymap[notenumber - 1] == Accid.Natural && this.keymap[notenumber + 1] == Accid.Natural) {
                    letter = this.num_flats > 0 ? whole_flats[notescale] : whole_sharps[notescale];
                } else if (this.keymap[notenumber - 1] == Accid.Natural) {
                    letter = whole_sharps[notescale];
                } else if (this.keymap[notenumber + 1] == Accid.Natural) {
                    letter = whole_flats[notescale];
                }
            }
        }
        if (this.num_flats == 6 && notescale == 2) {
            letter = 2;
        }
        if (this.num_flats == 6 && notescale == 1) {
            letter = 1;
        }
        if (this.num_flats > 0 && notescale == 11) {
            ++octave;
        }
        return new WhiteNote(letter, octave);
    }

    public static KeySignature Guess(ListInt notes) {
        int n;
        int accid_count;
        int key;
        KeySignature.CreateAccidentalMaps();
        int[] notecount = new int[12];
        for (int i = 0; i < notes.size(); ++i) {
            int notescale;
            int notenumber = notes.get(i);
            int n2 = notescale = (notenumber + 3) % 12;
            notecount[n2] = notecount[n2] + 1;
        }
        int bestkey = 0;
        boolean is_best_sharp = true;
        int smallest_accid_count = notes.size();
        for (key = 0; key < 6; ++key) {
            accid_count = 0;
            for (n = 0; n < 12; ++n) {
                if (sharpkeys[key][n] == Accid.None) continue;
                accid_count += notecount[n];
            }
            if (accid_count >= smallest_accid_count) continue;
            smallest_accid_count = accid_count;
            bestkey = key;
            is_best_sharp = true;
        }
        for (key = 0; key < 7; ++key) {
            accid_count = 0;
            for (n = 0; n < 12; ++n) {
                if (flatkeys[key][n] == Accid.None) continue;
                accid_count += notecount[n];
            }
            if (accid_count >= smallest_accid_count) continue;
            smallest_accid_count = accid_count;
            bestkey = key;
            is_best_sharp = false;
        }
        if (is_best_sharp) {
            return new KeySignature(bestkey, 0);
        }
        return new KeySignature(0, bestkey);
    }

    public boolean equals(KeySignature k) {
        return k.num_sharps == this.num_sharps && k.num_flats == this.num_flats;
    }

    public int Notescale() {
        int[] flatmajor = new int[]{3, 8, 1, 6, 11, 4, 9, 2};
        int[] sharpmajor = new int[]{3, 10, 5, 0, 7, 2, 9, 4, 11, 6};
        if (this.num_flats > 0) {
            return flatmajor[this.num_flats];
        }
        return sharpmajor[this.num_sharps];
    }

    public static String KeyToString(int notescale) {
        switch (notescale) {
            case 0: {
                return "A major";
            }
            case 1: {
                return "B-flat major";
            }
            case 2: {
                return "B major";
            }
            case 3: {
                return "C major";
            }
            case 4: {
                return "D-flat major";
            }
            case 5: {
                return "D major";
            }
            case 6: {
                return "E-flat major";
            }
            case 7: {
                return "E major";
            }
            case 8: {
                return "F major";
            }
            case 9: {
                return "G-flat major";
            }
            case 10: {
                return "G major";
            }
            case 11: {
                return "A-flat major";
            }
        }
        return "";
    }

    public String toString() {
        return KeySignature.KeyToString(this.Notescale());
    }
}

