/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.view;

import com.jinmingyunle.midiplaylib.symbol.BarSymbol;
import com.jinmingyunle.midiplaylib.symbol.LyricSymbol;
import com.jinmingyunle.midiplaylib.symbol.MusicSymbol;
import com.jinmingyunle.midiplaylib.utils.DictInt;
import java.util.ArrayList;
import java.util.Arrays;

public class SymbolWidths {
    private DictInt[] widths;
    private DictInt maxwidths;
    private int[] starttimes;

    public SymbolWidths(ArrayList<ArrayList<MusicSymbol>> tracks, ArrayList<ArrayList<LyricSymbol>> tracklyrics) {
        int time;
        this.widths = new DictInt[tracks.size()];
        for (int track = 0; track < tracks.size(); ++track) {
            this.widths[track] = SymbolWidths.GetTrackWidths(tracks.get(track));
        }
        this.maxwidths = new DictInt();
        for (DictInt dict : this.widths) {
            for (int i = 0; i < dict.count(); ++i) {
                time = dict.getKey(i);
                if (this.maxwidths.contains(time) && this.maxwidths.get(time) >= dict.get(time)) continue;
                this.maxwidths.set(time, dict.get(time));
            }
        }
        if (tracklyrics != null) {
            for (ArrayList arrayList : tracklyrics) {
                if (arrayList == null) continue;
                for (LyricSymbol lyric : arrayList) {
                    int width = lyric.getMinWidth();
                    time = lyric.getStartTime();
                    if (this.maxwidths.contains(time) && this.maxwidths.get(time) >= width) continue;
                    this.maxwidths.set(time, width);
                }
            }
        }
        this.starttimes = new int[this.maxwidths.count()];
        for (int i = 0; i < this.maxwidths.count(); ++i) {
            int n;
            this.starttimes[i] = n = this.maxwidths.getKey(i);
        }
        Arrays.sort(this.starttimes);
    }

    private static DictInt GetTrackWidths(ArrayList<MusicSymbol> symbols) {
        DictInt widths = new DictInt();
        for (MusicSymbol m : symbols) {
            int start = m.getStartTime();
            int w = m.getMinWidth();
            if (m instanceof BarSymbol) continue;
            if (widths.contains(start)) {
                widths.set(start, widths.get(start) + w);
                continue;
            }
            widths.set(start, w);
        }
        return widths;
    }

    public int GetExtraWidth(int track, int start) {
        if (!this.widths[track].contains(start)) {
            return this.maxwidths.get(start);
        }
        return this.maxwidths.get(start) - this.widths[track].get(start);
    }

    public int[] getStartTimes() {
        return this.starttimes;
    }
}

