/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import android.animation.ArgbEvaluator;
import android.graphics.Color;
import android.text.TextUtils;
import com.alibaba.android.bindingx.core.PlatformManager;
import com.alibaba.android.bindingx.core.internal.JSFunctionInterface;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONException;

class JSMath {
    private static Object sin = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) {
            return Math.sin((Double)arguments.get(0));
        }
    };
    private static Object cos = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) {
            return Math.cos((Double)arguments.get(0));
        }
    };
    private static Object tan = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) {
            return Math.tan((Double)arguments.get(0));
        }
    };
    private static Object asin = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) {
            return Math.asin((Double)arguments.get(0));
        }
    };
    private static Object acos = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) {
            return Math.acos((Double)arguments.get(0));
        }
    };
    private static Object atan = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) {
            return Math.atan((Double)arguments.get(0));
        }
    };
    private static Object atan2 = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) {
            return Math.atan2((Double)arguments.get(0), (Double)arguments.get(1));
        }
    };
    private static Object pow = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) {
            return Math.pow((Double)arguments.get(0), (Double)arguments.get(1));
        }
    };
    private static Object exp = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) {
            return Math.exp((Double)arguments.get(0));
        }
    };
    private static Object sqrt = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) {
            return Math.sqrt((Double)arguments.get(0));
        }
    };
    private static Object cbrt = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) {
            return Math.cbrt((Double)arguments.get(0));
        }
    };
    private static Object log = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) {
            return Math.log((Double)arguments.get(0));
        }
    };
    private static Object abs = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) {
            return Math.abs((Double)arguments.get(0));
        }
    };
    private static Object sign = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) {
            double v = (Double)arguments.get(0);
            if (v > 0.0) {
                return 1;
            }
            if (v == 0.0) {
                return 0;
            }
            if (v < 0.0) {
                return -1;
            }
            return Double.NaN;
        }
    };
    private static Object ceil = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) {
            return Math.ceil((Double)arguments.get(0));
        }
    };
    private static Object floor = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) {
            return Math.floor((Double)arguments.get(0));
        }
    };
    private static Object round = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) {
            return Math.round((Double)arguments.get(0));
        }
    };
    private static Object max = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) {
            if (arguments != null && arguments.size() >= 1) {
                double max = (Double)arguments.get(0);
                int len = arguments.size();
                for (int i = 1; i < len; ++i) {
                    double val = (Double)arguments.get(i);
                    if (!(val > max)) continue;
                    max = val;
                }
                return max;
            }
            return null;
        }
    };
    private static Object min = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) {
            if (arguments != null && arguments.size() >= 1) {
                double min = (Double)arguments.get(0);
                int len = arguments.size();
                for (int i = 1; i < len; ++i) {
                    double val = (Double)arguments.get(i);
                    if (!(val < min)) continue;
                    min = val;
                }
                return min;
            }
            return null;
        }
    };
    private static Object PI = Math.PI;
    public static Object E = Math.E;
    private static Object translate = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
            if (arguments == null || arguments.size() < 2) {
                return null;
            }
            return arguments;
        }
    };
    private static Object scale = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
            if (arguments == null || arguments.size() < 2) {
                return null;
            }
            return arguments;
        }
    };
    private static Object matrix = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
            if (arguments == null || arguments.size() < 6) {
                return null;
            }
            return arguments;
        }
    };
    private static Object rgb = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
            if (arguments == null || arguments.size() < 3) {
                return null;
            }
            double r = (Double)arguments.get(0);
            double g = (Double)arguments.get(1);
            double b = (Double)arguments.get(2);
            return Color.rgb((int)((int)r), (int)((int)g), (int)((int)b));
        }
    };
    private static Object rgba = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
            if (arguments == null || arguments.size() < 4) {
                return null;
            }
            double r = (Double)arguments.get(0);
            double g = (Double)arguments.get(1);
            double b = (Double)arguments.get(2);
            double a = (Double)arguments.get(3) * 255.0;
            return Color.argb((int)((int)a), (int)((int)r), (int)((int)g), (int)((int)b));
        }
    };
    private static ArgbEvaluator sArgbEvaluator = new ArgbEvaluator();
    private static Object evaluateColor = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
            int fromColor = JSMath.parseColor((String)arguments.get(0));
            int toColor = JSMath.parseColor((String)arguments.get(1));
            double fraction = (Double)arguments.get(2);
            fraction = Math.min(1.0, Math.max(0.0, fraction));
            return sArgbEvaluator.evaluate((float)fraction, (Object)fromColor, (Object)toColor);
        }
    };
    private static Object asArray = new JSFunctionInterface(){

        @Override
        public Object execute(ArrayList<Object> arguments) throws NumberFormatException, JSONException {
            return arguments;
        }
    };

    private JSMath() {
    }

    private static int parseColor(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            throw new IllegalArgumentException("Unknown color");
        }
        String colorStr = str;
        if (str.startsWith("'") || str.startsWith("\"")) {
            colorStr = colorStr.substring(1, colorStr.length() - 1);
        }
        int color = Color.parseColor((String)colorStr);
        color = Color.argb((int)255, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
        return color;
    }

    static void applyXYToScope(Map<String, Object> scope, double x, double y, PlatformManager.IDeviceResolutionTranslator translator) {
        scope.put("x", translator.nativeToWeb(x, new Object[0]));
        scope.put("y", translator.nativeToWeb(y, new Object[0]));
        scope.put("internal_x", x);
        scope.put("internal_y", y);
    }

    static void applyOrientationValuesToScope(Map<String, Object> scope, double alpha, double beta, double gamma, double startAlpha, double startBeta, double startGamma, double x, double y, double z) {
        scope.put("alpha", alpha);
        scope.put("beta", beta);
        scope.put("gamma", gamma);
        scope.put("dalpha", alpha - startAlpha);
        scope.put("dbeta", beta - startBeta);
        scope.put("dgamma", gamma - startGamma);
        scope.put("x", x);
        scope.put("y", y);
        scope.put("z", z);
    }

    static void applyTimingValuesToScope(Map<String, Object> scope, double t) {
        scope.put("t", t);
    }

    static void applyScrollValuesToScope(Map<String, Object> scope, double x, double y, double dx, double dy, double tdx, double tdy, PlatformManager.IDeviceResolutionTranslator translator) {
        scope.put("x", translator.nativeToWeb(x, new Object[0]));
        scope.put("y", translator.nativeToWeb(y, new Object[0]));
        scope.put("dx", translator.nativeToWeb(dx, new Object[0]));
        scope.put("dy", translator.nativeToWeb(dy, new Object[0]));
        scope.put("tdx", translator.nativeToWeb(tdx, new Object[0]));
        scope.put("tdy", translator.nativeToWeb(tdy, new Object[0]));
        scope.put("internal_x", x);
        scope.put("internal_y", y);
    }

    static void applyToScope(Map<String, Object> scope) {
        scope.put("sin", sin);
        scope.put("cos", cos);
        scope.put("tan", tan);
        scope.put("asin", asin);
        scope.put("acos", acos);
        scope.put("atan", atan);
        scope.put("atan2", atan2);
        scope.put("pow", pow);
        scope.put("exp", exp);
        scope.put("sqrt", sqrt);
        scope.put("cbrt", cbrt);
        scope.put("log", log);
        scope.put("abs", abs);
        scope.put("sign", sign);
        scope.put("ceil", ceil);
        scope.put("floor", floor);
        scope.put("round", round);
        scope.put("max", max);
        scope.put("min", min);
        scope.put("PI", PI);
        scope.put("E", E);
        scope.put("translate", translate);
        scope.put("scale", scale);
        scope.put("matrix", matrix);
        scope.put("rgb", rgb);
        scope.put("rgba", rgba);
        scope.put("evaluateColor", evaluateColor);
        scope.put("asArray", asArray);
    }
}

