/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import android.app.Application;
import android.app.Notification;
import android.content.Context;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.DownloadTask;
import com.liulishuo.filedownloader.FileDownloadConnectListener;
import com.liulishuo.filedownloader.FileDownloadEventPool;
import com.liulishuo.filedownloader.FileDownloadLine;
import com.liulishuo.filedownloader.FileDownloadLineAsync;
import com.liulishuo.filedownloader.FileDownloadList;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.FileDownloadMessageStation;
import com.liulishuo.filedownloader.FileDownloadServiceProxy;
import com.liulishuo.filedownloader.FileDownloadTaskLauncher;
import com.liulishuo.filedownloader.ILostServiceConnectedHandler;
import com.liulishuo.filedownloader.IQueuesHandler;
import com.liulishuo.filedownloader.LostServiceConnectedHandler;
import com.liulishuo.filedownloader.PauseAllMarker;
import com.liulishuo.filedownloader.QueuesHandler;
import com.liulishuo.filedownloader.download.CustomComponentHolder;
import com.liulishuo.filedownloader.model.FileDownloadTaskAtom;
import com.liulishuo.filedownloader.services.DownloadMgrInitialParams;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.File;
import java.util.List;

public class FileDownloader {
    private static final Object INIT_QUEUES_HANDLER_LOCK = new Object();
    private IQueuesHandler mQueuesHandler;
    private static final Object INIT_LOST_CONNECTED_HANDLER_LOCK = new Object();
    private ILostServiceConnectedHandler mLostConnectedHandler;

    public static void setup(Context context) {
        FileDownloadHelper.holdContext(context.getApplicationContext());
    }

    public static DownloadMgrInitialParams.InitCustomMaker setupOnApplicationOnCreate(Application application) {
        Context context = application.getApplicationContext();
        FileDownloadHelper.holdContext(context);
        DownloadMgrInitialParams.InitCustomMaker customMaker = new DownloadMgrInitialParams.InitCustomMaker();
        CustomComponentHolder.getImpl().setInitCustomMaker(customMaker);
        return customMaker;
    }

    public static void init(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("the provided context must not be null!");
        }
        FileDownloader.setup(context);
    }

    public static void init(Context context, DownloadMgrInitialParams.InitCustomMaker maker) {
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(FileDownloader.class, "init Downloader with params: %s %s", context, maker);
        }
        if (context == null) {
            throw new IllegalArgumentException("the provided context must not be null!");
        }
        FileDownloadHelper.holdContext(context.getApplicationContext());
        CustomComponentHolder.getImpl().setInitCustomMaker(maker);
    }

    public static FileDownloader getImpl() {
        return HolderClass.INSTANCE;
    }

    public static void setGlobalPost2UIInterval(int intervalMillisecond) {
        FileDownloadMessageStation.INTERVAL = intervalMillisecond;
    }

    public static void setGlobalHandleSubPackageSize(int packageSize) {
        if (packageSize <= 0) {
            throw new IllegalArgumentException("sub package size must more than 0");
        }
        FileDownloadMessageStation.SUB_PACKAGE_SIZE = packageSize;
    }

    public static void enableAvoidDropFrame() {
        FileDownloader.setGlobalPost2UIInterval(10);
    }

    public static void disableAvoidDropFrame() {
        FileDownloader.setGlobalPost2UIInterval(-1);
    }

    public static boolean isEnabledAvoidDropFrame() {
        return FileDownloadMessageStation.isIntervalValid();
    }

    public BaseDownloadTask create(String url) {
        return new DownloadTask(url);
    }

    public boolean start(FileDownloadListener listener, boolean isSerial) {
        if (listener == null) {
            FileDownloadLog.w(this, "Tasks with the listener can't start, because the listener provided is null: [null, %B]", isSerial);
            return false;
        }
        return isSerial ? this.getQueuesHandler().startQueueSerial(listener) : this.getQueuesHandler().startQueueParallel(listener);
    }

    public void pause(FileDownloadListener listener) {
        FileDownloadTaskLauncher.getImpl().expire(listener);
        List<BaseDownloadTask.IRunningTask> taskList = FileDownloadList.getImpl().copy(listener);
        for (BaseDownloadTask.IRunningTask task : taskList) {
            task.getOrigin().pause();
        }
    }

    public void pauseAll() {
        BaseDownloadTask.IRunningTask[] downloadList;
        FileDownloadTaskLauncher.getImpl().expireAll();
        for (BaseDownloadTask.IRunningTask task : downloadList = FileDownloadList.getImpl().copy()) {
            task.getOrigin().pause();
        }
        if (FileDownloadServiceProxy.getImpl().isConnected()) {
            FileDownloadServiceProxy.getImpl().pauseAllTasks();
        } else {
            PauseAllMarker.createMarker();
        }
    }

    public int pause(int id) {
        List<BaseDownloadTask.IRunningTask> taskList = FileDownloadList.getImpl().getDownloadingList(id);
        if (null == taskList || taskList.isEmpty()) {
            FileDownloadLog.w(this, "request pause but not exist %d", id);
            return 0;
        }
        for (BaseDownloadTask.IRunningTask task : taskList) {
            task.getOrigin().pause();
        }
        return taskList.size();
    }

    public boolean clear(int id, String targetFilePath) {
        this.pause(id);
        if (FileDownloadServiceProxy.getImpl().clearTaskData(id)) {
            File targetFile;
            File intermediateFile = new File(FileDownloadUtils.getTempPath(targetFilePath));
            if (intermediateFile.exists()) {
                intermediateFile.delete();
            }
            if ((targetFile = new File(targetFilePath)).exists()) {
                targetFile.delete();
            }
            return true;
        }
        return false;
    }

    public void clearAllTaskData() {
        this.pauseAll();
        FileDownloadServiceProxy.getImpl().clearAllTaskData();
    }

    public long getSoFar(int downloadId) {
        BaseDownloadTask.IRunningTask task = FileDownloadList.getImpl().get(downloadId);
        if (task == null) {
            return FileDownloadServiceProxy.getImpl().getSofar(downloadId);
        }
        return task.getOrigin().getLargeFileSoFarBytes();
    }

    public long getTotal(int id) {
        BaseDownloadTask.IRunningTask task = FileDownloadList.getImpl().get(id);
        if (task == null) {
            return FileDownloadServiceProxy.getImpl().getTotal(id);
        }
        return task.getOrigin().getLargeFileTotalBytes();
    }

    public byte getStatusIgnoreCompleted(int id) {
        return this.getStatus(id, null);
    }

    public byte getStatus(String url, String path) {
        return this.getStatus(FileDownloadUtils.generateId(url, path), path);
    }

    public byte getStatus(int id, String path) {
        BaseDownloadTask.IRunningTask task = FileDownloadList.getImpl().get(id);
        int status = task == null ? FileDownloadServiceProxy.getImpl().getStatus(id) : task.getOrigin().getStatus();
        if (path != null && status == 0 && FileDownloadUtils.isFilenameConverted(FileDownloadHelper.getAppContext()) && new File(path).exists()) {
            status = -3;
        }
        return (byte)status;
    }

    public int replaceListener(String url, FileDownloadListener listener) {
        return this.replaceListener(url, FileDownloadUtils.getDefaultSaveFilePath(url), listener);
    }

    public int replaceListener(String url, String path, FileDownloadListener listener) {
        return this.replaceListener(FileDownloadUtils.generateId(url, path), listener);
    }

    public int replaceListener(int id, FileDownloadListener listener) {
        BaseDownloadTask.IRunningTask task = FileDownloadList.getImpl().get(id);
        if (task == null) {
            return 0;
        }
        task.getOrigin().setListener(listener);
        return task.getOrigin().getId();
    }

    public void bindService() {
        if (!this.isServiceConnected()) {
            FileDownloadServiceProxy.getImpl().bindStartByContext(FileDownloadHelper.getAppContext());
        }
    }

    public void bindService(Runnable runnable) {
        if (this.isServiceConnected()) {
            runnable.run();
        } else {
            FileDownloadServiceProxy.getImpl().bindStartByContext(FileDownloadHelper.getAppContext(), runnable);
        }
    }

    public void unBindService() {
        if (this.isServiceConnected()) {
            FileDownloadServiceProxy.getImpl().unbindByContext(FileDownloadHelper.getAppContext());
        }
    }

    public boolean unBindServiceIfIdle() {
        if (!this.isServiceConnected()) {
            return false;
        }
        if (FileDownloadList.getImpl().isEmpty() && FileDownloadServiceProxy.getImpl().isIdle()) {
            this.unBindService();
            return true;
        }
        return false;
    }

    public boolean isServiceConnected() {
        return FileDownloadServiceProxy.getImpl().isConnected();
    }

    public void addServiceConnectListener(FileDownloadConnectListener listener) {
        FileDownloadEventPool.getImpl().addListener("event.service.connect.changed", listener);
    }

    public void removeServiceConnectListener(FileDownloadConnectListener listener) {
        FileDownloadEventPool.getImpl().removeListener("event.service.connect.changed", listener);
    }

    public void startForeground(int id, Notification notification) {
        FileDownloadServiceProxy.getImpl().startForeground(id, notification);
    }

    public void stopForeground(boolean removeNotification) {
        FileDownloadServiceProxy.getImpl().stopForeground(removeNotification);
    }

    public boolean setTaskCompleted(String url, String path, long totalBytes) {
        FileDownloadLog.w(this, "If you invoked this method, please remove it directly feel free, it doesn't need any longer", new Object[0]);
        return true;
    }

    public boolean setTaskCompleted(List<FileDownloadTaskAtom> taskAtomList) {
        FileDownloadLog.w(this, "If you invoked this method, please remove it directly feel free, it doesn't need any longer", new Object[0]);
        return true;
    }

    public boolean setMaxNetworkThreadCount(int count) {
        if (!FileDownloadList.getImpl().isEmpty()) {
            FileDownloadLog.w(this, "Can't change the max network thread count, because there are actively executing tasks in FileDownloader, please try again after all actively executing tasks are completed or invoking FileDownloader#pauseAll directly.", new Object[0]);
            return false;
        }
        return FileDownloadServiceProxy.getImpl().setMaxNetworkThreadCount(count);
    }

    public FileDownloadLine insureServiceBind() {
        return new FileDownloadLine();
    }

    public FileDownloadLineAsync insureServiceBindAsync() {
        return new FileDownloadLineAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IQueuesHandler getQueuesHandler() {
        if (this.mQueuesHandler == null) {
            Object object = INIT_QUEUES_HANDLER_LOCK;
            synchronized (object) {
                if (this.mQueuesHandler == null) {
                    this.mQueuesHandler = new QueuesHandler();
                }
            }
        }
        return this.mQueuesHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ILostServiceConnectedHandler getLostConnectedHandler() {
        if (this.mLostConnectedHandler == null) {
            Object object = INIT_LOST_CONNECTED_HANDLER_LOCK;
            synchronized (object) {
                if (this.mLostConnectedHandler == null) {
                    this.mLostConnectedHandler = new LostServiceConnectedHandler();
                    this.addServiceConnectListener((FileDownloadConnectListener)((Object)this.mLostConnectedHandler));
                }
            }
        }
        return this.mLostConnectedHandler;
    }

    private static final class HolderClass {
        private static final FileDownloader INSTANCE = new FileDownloader();

        private HolderClass() {
        }
    }
}

