/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.database;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.database.NoDatabaseImpl;
import com.liulishuo.filedownloader.database.SqliteDatabaseImpl;
import com.liulishuo.filedownloader.model.ConnectionModel;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadProperties;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public class RemitDatabase
implements FileDownloadDatabase {
    private final NoDatabaseImpl cachedDatabase;
    private final SqliteDatabaseImpl realDatabase;
    private Handler handler;
    private final long minInterval;
    private final List<Integer> freeToDBIdList = new ArrayList<Integer>();
    private AtomicInteger handlingId = new AtomicInteger();
    private volatile Thread parkThread;
    private static final int WHAT_CLEAN_LOCK = 0;

    public RemitDatabase() {
        this.cachedDatabase = new NoDatabaseImpl();
        this.realDatabase = new SqliteDatabaseImpl();
        this.minInterval = FileDownloadProperties.getImpl().downloadMinProgressTime;
        HandlerThread thread = new HandlerThread(FileDownloadUtils.getThreadPoolName("RemitHandoverToDB"));
        thread.start();
        this.handler = new Handler(thread.getLooper(), new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                int id = msg.what;
                if (id == 0) {
                    if (RemitDatabase.this.parkThread != null) {
                        LockSupport.unpark(RemitDatabase.this.parkThread);
                        RemitDatabase.this.parkThread = null;
                    }
                    return false;
                }
                try {
                    RemitDatabase.this.handlingId.set(id);
                    RemitDatabase.this.syncCacheToDB(id);
                    RemitDatabase.this.freeToDBIdList.add(id);
                }
                finally {
                    RemitDatabase.this.handlingId.set(0);
                    if (RemitDatabase.this.parkThread != null) {
                        LockSupport.unpark(RemitDatabase.this.parkThread);
                        RemitDatabase.this.parkThread = null;
                    }
                }
                return false;
            }
        });
    }

    private void syncCacheToDB(int id) {
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "sync cache to db %d", id);
        }
        this.realDatabase.update(this.cachedDatabase.find(id));
        List<ConnectionModel> modelList = this.cachedDatabase.findConnectionModel(id);
        this.realDatabase.removeConnections(id);
        for (ConnectionModel connectionModel : modelList) {
            this.realDatabase.insertConnectionModel(connectionModel);
        }
    }

    private boolean isNoNeedUpdateToRealDB(int id) {
        return !this.freeToDBIdList.contains(id);
    }

    @Override
    public void onTaskStart(int id) {
        this.handler.sendEmptyMessageDelayed(id, this.minInterval);
    }

    @Override
    public FileDownloadModel find(int id) {
        return this.cachedDatabase.find(id);
    }

    @Override
    public List<ConnectionModel> findConnectionModel(int id) {
        return this.cachedDatabase.findConnectionModel(id);
    }

    @Override
    public void removeConnections(int id) {
        this.cachedDatabase.removeConnections(id);
        if (this.isNoNeedUpdateToRealDB(id)) {
            return;
        }
        this.realDatabase.removeConnections(id);
    }

    @Override
    public void insertConnectionModel(ConnectionModel model) {
        this.cachedDatabase.insertConnectionModel(model);
        int id = model.getId();
        if (this.isNoNeedUpdateToRealDB(id)) {
            return;
        }
        this.realDatabase.insertConnectionModel(model);
    }

    @Override
    public void updateConnectionModel(int id, int index, long currentOffset) {
        this.cachedDatabase.updateConnectionModel(id, index, currentOffset);
        if (this.isNoNeedUpdateToRealDB(id)) {
            return;
        }
        this.realDatabase.updateConnectionModel(id, index, currentOffset);
    }

    @Override
    public void updateProgress(int id, long sofarBytes) {
        this.cachedDatabase.updateProgress(id, sofarBytes);
        if (this.isNoNeedUpdateToRealDB(id)) {
            return;
        }
        this.realDatabase.updateProgress(id, sofarBytes);
    }

    @Override
    public void updateConnectionCount(int id, int count) {
        this.cachedDatabase.updateConnectionCount(id, count);
        if (this.isNoNeedUpdateToRealDB(id)) {
            return;
        }
        this.realDatabase.updateConnectionCount(id, count);
    }

    @Override
    public void insert(FileDownloadModel downloadModel) {
        this.cachedDatabase.insert(downloadModel);
        if (this.isNoNeedUpdateToRealDB(downloadModel.getId())) {
            return;
        }
        this.realDatabase.insert(downloadModel);
    }

    @Override
    public void update(FileDownloadModel downloadModel) {
        this.cachedDatabase.update(downloadModel);
        if (this.isNoNeedUpdateToRealDB(downloadModel.getId())) {
            return;
        }
        this.realDatabase.update(downloadModel);
    }

    @Override
    public boolean remove(int id) {
        this.realDatabase.remove(id);
        return this.cachedDatabase.remove(id);
    }

    @Override
    public void clear() {
        this.cachedDatabase.clear();
        this.realDatabase.clear();
    }

    @Override
    public void updateOldEtagOverdue(int id, String newEtag, long sofar, long total, int connectionCount) {
        this.cachedDatabase.updateOldEtagOverdue(id, newEtag, sofar, total, connectionCount);
        if (this.isNoNeedUpdateToRealDB(id)) {
            return;
        }
        this.realDatabase.updateOldEtagOverdue(id, newEtag, sofar, total, connectionCount);
    }

    @Override
    public void updateConnected(int id, long total, String etag, String filename) {
        this.cachedDatabase.updateConnected(id, total, etag, filename);
        if (this.isNoNeedUpdateToRealDB(id)) {
            return;
        }
        this.realDatabase.updateConnected(id, total, etag, filename);
    }

    @Override
    public void updatePending(int id) {
        this.cachedDatabase.updatePending(id);
        if (this.isNoNeedUpdateToRealDB(id)) {
            return;
        }
        this.realDatabase.updatePending(id);
    }

    @Override
    public void updateRetry(int id, Throwable throwable) {
        this.cachedDatabase.updateRetry(id, throwable);
        if (this.isNoNeedUpdateToRealDB(id)) {
            return;
        }
        this.realDatabase.updateRetry(id, throwable);
    }

    private void ensureCacheToDB(int id) {
        this.handler.removeMessages(id);
        if (this.handlingId.get() == id) {
            this.parkThread = Thread.currentThread();
            this.handler.sendEmptyMessage(0);
            LockSupport.park();
        } else {
            this.syncCacheToDB(id);
        }
    }

    @Override
    public void updateError(int id, Throwable throwable, long sofar) {
        this.cachedDatabase.updateError(id, throwable, sofar);
        if (this.isNoNeedUpdateToRealDB(id)) {
            this.ensureCacheToDB(id);
        }
        this.realDatabase.updateError(id, throwable, sofar);
        this.freeToDBIdList.remove((Object)id);
    }

    @Override
    public void updateCompleted(int id, long total) {
        this.cachedDatabase.updateCompleted(id, total);
        if (this.isNoNeedUpdateToRealDB(id)) {
            this.handler.removeMessages(id);
            if (this.handlingId.get() == id) {
                this.parkThread = Thread.currentThread();
                this.handler.sendEmptyMessage(0);
                LockSupport.park();
                this.realDatabase.updateCompleted(id, total);
            }
        } else {
            this.realDatabase.updateCompleted(id, total);
        }
        this.freeToDBIdList.remove((Object)id);
    }

    @Override
    public void updatePause(int id, long sofar) {
        this.cachedDatabase.updatePause(id, sofar);
        if (this.isNoNeedUpdateToRealDB(id)) {
            this.ensureCacheToDB(id);
        }
        this.realDatabase.updatePause(id, sofar);
        this.freeToDBIdList.remove((Object)id);
    }

    @Override
    public FileDownloadDatabase.Maintainer maintainer() {
        return this.realDatabase.maintainer(this.cachedDatabase.downloaderModelMap, this.cachedDatabase.connectionModelListMap);
    }

    public static class Maker
    implements FileDownloadHelper.DatabaseCustomMaker {
        @Override
        public FileDownloadDatabase customMake() {
            return new RemitDatabase();
        }
    }
}

