/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.download;

import android.os.SystemClock;
import com.liulishuo.filedownloader.connection.FileDownloadConnection;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.download.ConnectionProfile;
import com.liulishuo.filedownloader.download.CustomComponentHolder;
import com.liulishuo.filedownloader.download.DownloadRunnable;
import com.liulishuo.filedownloader.download.ProcessCallback;
import com.liulishuo.filedownloader.exception.FileDownloadGiveUpRetryException;
import com.liulishuo.filedownloader.exception.FileDownloadNetworkPolicyException;
import com.liulishuo.filedownloader.stream.FileDownloadOutputStream;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.IOException;
import java.io.InputStream;

public class FetchDataTask {
    static final int BUFFER_SIZE = 4096;
    private final ProcessCallback callback;
    private final int downloadId;
    private final int connectionIndex;
    private final DownloadRunnable hostRunnable;
    private final FileDownloadConnection connection;
    private final boolean isWifiRequired;
    private final long startOffset;
    private final long endOffset;
    private final long contentLength;
    private final String path;
    long currentOffset;
    private FileDownloadOutputStream outputStream;
    private volatile boolean paused;
    private final FileDownloadDatabase database;
    private volatile long lastSyncBytes = 0L;
    private volatile long lastSyncTimestamp = 0L;

    public void pause() {
        this.paused = true;
    }

    private FetchDataTask(FileDownloadConnection connection, ConnectionProfile connectionProfile, DownloadRunnable host, int id, int connectionIndex, boolean isWifiRequired, ProcessCallback callback, String path) {
        this.callback = callback;
        this.path = path;
        this.connection = connection;
        this.isWifiRequired = isWifiRequired;
        this.hostRunnable = host;
        this.connectionIndex = connectionIndex;
        this.downloadId = id;
        this.database = CustomComponentHolder.getImpl().getDatabaseInstance();
        this.startOffset = connectionProfile.startOffset;
        this.endOffset = connectionProfile.endOffset;
        this.currentOffset = connectionProfile.currentOffset;
        this.contentLength = connectionProfile.contentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException, IllegalAccessException, IllegalArgumentException, FileDownloadGiveUpRetryException {
        long fetchBeginOffset;
        long contentLength;
        block52: {
            if (this.paused) {
                return;
            }
            contentLength = FileDownloadUtils.findContentLength(this.connectionIndex, this.connection);
            if (contentLength == -1L) {
                contentLength = FileDownloadUtils.findContentLengthFromContentRange(this.connection);
            }
            if (contentLength == 0L) {
                throw new FileDownloadGiveUpRetryException(FileDownloadUtils.formatString("there isn't any content need to download on %d-%d with the content-length is 0", this.downloadId, this.connectionIndex));
            }
            if (this.contentLength > 0L && contentLength != this.contentLength) {
                String range = this.endOffset == -1L ? FileDownloadUtils.formatString("range[%d-)", this.currentOffset) : FileDownloadUtils.formatString("range[%d-%d)", this.currentOffset, this.endOffset);
                throw new FileDownloadGiveUpRetryException(FileDownloadUtils.formatString("require %s with contentLength(%d), but the backend response contentLength is %d on downloadId[%d]-connectionIndex[%d], please ask your backend dev to fix such problem.", range, this.contentLength, contentLength, this.downloadId, this.connectionIndex));
            }
            fetchBeginOffset = this.currentOffset;
            InputStream inputStream = null;
            FileDownloadOutputStream outputStream = null;
            try {
                boolean isSupportSeek = CustomComponentHolder.getImpl().isSupportSeek();
                if (this.hostRunnable != null && !isSupportSeek) {
                    throw new IllegalAccessException("can't using multi-download when the output stream can't support seek");
                }
                this.outputStream = outputStream = FileDownloadUtils.createOutputStream(this.path);
                if (isSupportSeek) {
                    outputStream.seek(this.currentOffset);
                }
                if (FileDownloadLog.NEED_LOG) {
                    FileDownloadLog.d(this, "start fetch(%d): range [%d, %d), seek to[%d]", this.connectionIndex, this.startOffset, this.endOffset, this.currentOffset);
                }
                inputStream = this.connection.getInputStream();
                byte[] buff = new byte[4096];
                if (this.paused) {
                    return;
                }
                do {
                    int byteCount;
                    if ((byteCount = inputStream.read(buff)) == -1) {
                        break block52;
                    }
                    outputStream.write(buff, 0, byteCount);
                    this.currentOffset += (long)byteCount;
                    this.callback.onProgress(byteCount);
                    this.checkAndSync();
                    if (!this.paused) continue;
                    return;
                } while (!this.isWifiRequired || !FileDownloadUtils.isNetworkNotOnWifiType());
                throw new FileDownloadNetworkPolicyException();
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    if (outputStream != null) {
                        this.sync();
                    }
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        long fetchedLength = this.currentOffset - fetchBeginOffset;
        if (contentLength != -1L && contentLength != fetchedLength) {
            throw new FileDownloadGiveUpRetryException(FileDownloadUtils.formatString("fetched length[%d] != content length[%d], range[%d, %d) offset[%d] fetch begin offset[%d]", fetchedLength, contentLength, this.startOffset, this.endOffset, this.currentOffset, fetchBeginOffset));
        }
        this.callback.onCompleted(this.hostRunnable, this.startOffset, this.endOffset);
    }

    private void checkAndSync() {
        long bytesDelta = this.currentOffset - this.lastSyncBytes;
        long now = SystemClock.elapsedRealtime();
        long timestampDelta = now - this.lastSyncTimestamp;
        if (FileDownloadUtils.isNeedSync(bytesDelta, timestampDelta)) {
            this.sync();
            this.lastSyncBytes = this.currentOffset;
            this.lastSyncTimestamp = now;
        }
    }

    private void sync() {
        boolean bufferPersistToDevice;
        long startTimestamp;
        block6: {
            startTimestamp = SystemClock.uptimeMillis();
            try {
                this.outputStream.flushAndSync();
                bufferPersistToDevice = true;
            }
            catch (IOException e) {
                bufferPersistToDevice = false;
                if (!FileDownloadLog.NEED_LOG) break block6;
                FileDownloadLog.d(this, "Because of the system cannot guarantee that all the buffers have been synchronized with physical media, or write to filefailed, we just not flushAndSync process to database too %s", e);
            }
        }
        if (bufferPersistToDevice) {
            boolean isBelongMultiConnection;
            boolean bl = isBelongMultiConnection = this.connectionIndex >= 0;
            if (isBelongMultiConnection) {
                this.database.updateConnectionModel(this.downloadId, this.connectionIndex, this.currentOffset);
            } else {
                this.callback.syncProgressFromCache();
            }
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "require flushAndSync id[%d] index[%d] offset[%d], consume[%d]", this.downloadId, this.connectionIndex, this.currentOffset, SystemClock.uptimeMillis() - startTimestamp);
            }
        }
    }

    public static class Builder {
        DownloadRunnable downloadRunnable;
        FileDownloadConnection connection;
        ConnectionProfile connectionProfile;
        ProcessCallback callback;
        String path;
        Boolean isWifiRequired;
        Integer connectionIndex;
        Integer downloadId;

        public Builder setConnection(FileDownloadConnection connection) {
            this.connection = connection;
            return this;
        }

        public Builder setConnectionProfile(ConnectionProfile connectionProfile) {
            this.connectionProfile = connectionProfile;
            return this;
        }

        public Builder setCallback(ProcessCallback callback) {
            this.callback = callback;
            return this;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder setWifiRequired(boolean wifiRequired) {
            this.isWifiRequired = wifiRequired;
            return this;
        }

        public Builder setHost(DownloadRunnable downloadRunnable) {
            this.downloadRunnable = downloadRunnable;
            return this;
        }

        public Builder setConnectionIndex(int connectionIndex) {
            this.connectionIndex = connectionIndex;
            return this;
        }

        public Builder setDownloadId(int downloadId) {
            this.downloadId = downloadId;
            return this;
        }

        public FetchDataTask build() throws IllegalArgumentException {
            if (this.isWifiRequired == null || this.connection == null || this.connectionProfile == null || this.callback == null || this.path == null || this.downloadId == null || this.connectionIndex == null) {
                throw new IllegalArgumentException();
            }
            return new FetchDataTask(this.connection, this.connectionProfile, this.downloadRunnable, this.downloadId, this.connectionIndex, this.isWifiRequired, this.callback, this.path);
        }
    }
}

