/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.common;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.common.Destroyable;
import com.taobao.weex.common.WXModule;

public abstract class WXCompatModule
extends WXModule
implements Destroyable {
    private ModuleReceive mModuleReceive = new ModuleReceive(this);

    public WXCompatModule() {
        LocalBroadcastManager.getInstance((Context)WXEnvironment.getApplication()).registerReceiver((BroadcastReceiver)this.mModuleReceive, new IntentFilter("actionActivityResult"));
        LocalBroadcastManager.getInstance((Context)WXEnvironment.getApplication()).registerReceiver((BroadcastReceiver)this.mModuleReceive, new IntentFilter("actionRequestPermissionsResult"));
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    @Override
    public void destroy() {
        LocalBroadcastManager.getInstance((Context)WXEnvironment.getApplication()).unregisterReceiver((BroadcastReceiver)this.mModuleReceive);
    }

    static class ModuleReceive
    extends BroadcastReceiver {
        private WXCompatModule mWXCompatModule;

        ModuleReceive(WXCompatModule module) {
            this.mWXCompatModule = module;
        }

        public void onReceive(Context context, Intent intent) {
            String action;
            switch (action = intent.getAction()) {
                case "actionActivityResult": {
                    int requestCode = intent.getIntExtra("requestCode", -1);
                    int resultCode = intent.getIntExtra("resultCode", -1);
                    this.mWXCompatModule.onActivityResult(requestCode, resultCode, intent);
                    break;
                }
                case "actionRequestPermissionsResult": {
                    int requestCode = intent.getIntExtra("requestCode", -1);
                    String[] permissions = intent.getStringArrayExtra("permissions");
                    int[] grantResults = intent.getIntArrayExtra("grantResults");
                    this.mWXCompatModule.onRequestPermissionsResult(requestCode, permissions, grantResults);
                }
            }
        }
    }
}

