/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine;

import android.os.Message;
import cn.rongcloud.rtc.api.callback.IRCRTCFailedCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCKickedCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.engine.MsgObjectWraper;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.engine.tools.MultiRoomManager;
import cn.rongcloud.rtc.proxy.message.messagebeans.CDNResourceInfo;
import cn.rongcloud.rtc.stateMachine.State;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.webrtc.IWebRTCCore;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractBaseState
extends State {
    protected RTCEngineImpl mEngine;
    protected MultiRoomManager mMultiRoomManager;

    public AbstractBaseState(RTCEngineImpl engine) {
        this.mEngine = engine;
    }

    protected IWebRTCCore getRTCCore() {
        return this.mEngine.mRTCCore;
    }

    protected void sendMessage(Message msg) {
        this.mEngine.sendMessage(msg);
    }

    protected final void sendMessage(int what, Object obj) {
        this.mEngine.sendMessage(what, obj);
    }

    protected final void sendMessage(int what, Object ... obj) {
        this.mEngine.sendMessage(what, obj);
    }

    protected final void sendMessageForMap(int what, String keys, Object ... values) {
        this.mEngine.sendMessageForMap(what, keys, values);
    }

    protected final void copyAndSendMessage(Message msg) {
        Message newMsg = this.mEngine.obtainMessage();
        newMsg.copyFrom(msg);
        this.mEngine.sendMessage(newMsg);
    }

    protected boolean isCurrentState() {
        return this.mEngine.getCurrentState() == this;
    }

    protected AbstractBaseState getCurrentState() {
        return this.mEngine.getCurrentState();
    }

    @Override
    public final boolean processMessage(Message msg) {
        FinLog.d(this.getName(), "processMessage: " + msg.what);
        return this.handleMessage(msg, new MsgObjectWraper(msg.obj));
    }

    protected abstract boolean handleMessage(Message var1, MsgObjectWraper var2);

    protected void postEngineThread(final Runnable runnable) {
        this.mEngine.getHandler().post(new Runnable(){

            @Override
            public void run() {
                runnable.run();
            }
        });
    }

    public void onFailedCallback(RTCErrorCode code, IRCRTCFailedCallback callback) {
        this.mEngine.onFailedCallback(code, callback);
    }

    public void onKickedCallback(IRCRTCKickedCallback callback) {
        this.mEngine.onKickedCallback(callback);
    }

    protected void onSuccessCallback(Object result, IRCRTCResultDataCallback callback) {
        this.mEngine.onSuccessCallback(result, callback);
    }

    protected void onSuccessCallback(IRCRTCResultCallback callback) {
        this.mEngine.onSuccessCallback(callback);
    }

    protected void postCallback(Runnable runnable) {
        this.mEngine.postCallback(runnable);
    }

    protected void transitionTo(AbstractBaseState state) {
        this.mEngine.transitionTo(state);
    }

    public CDNResourceInfo setCDNResourceInfo(String value) {
        CDNResourceInfo info = null;
        try {
            JSONArray array = new JSONArray(value);
            JSONObject jsonObject = array.optJSONObject(0);
            if (jsonObject != null && jsonObject.has("enableInnerCDN")) {
                info = new CDNResourceInfo(jsonObject);
            } else {
                FinLog.w("AbstractBaseState", "didn't find KEY(enableInnerCDN)");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return info;
    }

    public MultiRoomManager getMultiRoomManager() {
        return this.mMultiRoomManager;
    }

    public void setMultiRoomManager(MultiRoomManager mMultiRoomManager) {
        this.mMultiRoomManager = mMultiRoomManager;
    }
}

