/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine;

import android.os.Message;
import android.text.TextUtils;
import android.util.Pair;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.RCRTCRoomConfig;
import cn.rongcloud.rtc.api.callback.IRCRTCFailedCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCSwitchRoleCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCSwitchRoleDataCallback;
import cn.rongcloud.rtc.api.stream.RCRTCLiveInfo;
import cn.rongcloud.rtc.api.stream.RCRTCOutputStream;
import cn.rongcloud.rtc.base.RCRTCLiveRole;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RCRTCSubscribeState;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.RCLocalUserImpl;
import cn.rongcloud.rtc.center.RCRemoteUserImpl;
import cn.rongcloud.rtc.center.RCRoomImpl;
import cn.rongcloud.rtc.center.stream.RCInputStreamImpl;
import cn.rongcloud.rtc.engine.AbstractBaseState;
import cn.rongcloud.rtc.engine.MsgObjectWraper;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.engine.tools.HandleChatRoomKVTools;
import cn.rongcloud.rtc.engine.tools.MultiRoomManager;
import cn.rongcloud.rtc.module.ping.RTCPingManager;
import cn.rongcloud.rtc.signal.IRTCSwitchRoleCallback;
import cn.rongcloud.rtc.signal.SignalManager;
import cn.rongcloud.rtc.stat.RongRtcStatMagr;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import cn.rongcloud.rtc.webrtc.RTCConnectionEventsImpl;
import io.rong.imlib.IRongCoreEnum;
import io.rong.imlib.model.RTCUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;

public class SwitchingState
extends AbstractBaseState {
    private static final String TAG = SwitchingState.class.getName();
    private RCRoomImpl mRoom;
    private RCLocalUserImpl mLocalUser;
    private RCRTCRoomConfig mRoomConfig;

    public SwitchingState(RTCEngineImpl engine) {
        super(engine);
    }

    @Override
    public void enter() {
        super.enter();
        this.mRoom = this.mEngine.mRoom;
        this.mLocalUser = (RCLocalUserImpl)this.mRoom.getLocalUser();
    }

    @Override
    protected boolean handleMessage(Message msg, MsgObjectWraper obj) {
        switch (msg.what) {
            case 10000: {
                this.mEngine.unInitFaceBeautyPlugin();
                this.mEngine.unInitVoiceBeautyPlugin();
                this.mEngine.clearDeferredMessage();
                this.mEngine.deferMessage(msg);
                this.releaseRoom(true, null);
                break;
            }
            case 9000: {
                this.releaseRoom(true, (IRCRTCResultCallback)obj.getData());
                break;
            }
            case 2088: {
                this.mEngine.mRTCCore.setEarphoneOn((Boolean)obj.getData(), null);
                break;
            }
            case 5074: {
                this.switchToAudienceQuitMediaServer((IRCRTCSwitchRoleCallback)obj.getData());
                break;
            }
            case 5072: {
                this.switchToAudience((IRCRTCSwitchRoleCallback)obj.getData());
                break;
            }
            case 5062: {
                this.onKickedCallback((IRCRTCSwitchRoleCallback)obj.getData());
                this.releaseRoom(false, null);
                break;
            }
            case 5061: {
                this.mRoomConfig = RCRTCRoomConfig.Builder.create().setRoomType((RCRTCRoomType)((Object)obj.getData(2))).setLiveRole(RCRTCLiveRole.AUDIENCE).build();
                this.switchToAudienceSuccess((Object[])obj.getData(0), (String)obj.getData(1), this.mRoomConfig, (IRCRTCSwitchRoleCallback)obj.getData(3));
                break;
            }
            case 5075: {
                this.switchToBroadcaster((List)obj.getData(0), (IRCRTCSwitchRoleDataCallback)obj.getData(1));
                break;
            }
            case 5065: {
                this.mRoomConfig = RCRTCRoomConfig.Builder.create().setRoomType((RCRTCRoomType)((Object)obj.getData(2))).setLiveRole(RCRTCLiveRole.BROADCASTER).build();
                this.switchToBroadcasterSuccess((String)obj.getData(1), (Object[])obj.getData(0), (List)obj.getData(3), (IRCRTCSwitchRoleDataCallback)obj.getData(4));
                break;
            }
            case 5066: {
                this.onKickedCallback((IRCRTCSwitchRoleDataCallback)obj.getData(1));
                this.releaseRoom(false, null);
                break;
            }
            case 5071: {
                this.mEngine.transitionTo(this.mEngine.mInRoomState);
                this.onFailedCallback((RTCErrorCode)((Object)obj.getData(0)), (IRCRTCFailedCallback)obj.getData(1));
                break;
            }
            case 5073: {
                this.switchRole((List)obj.getData(0), (IRCRTCSwitchRoleDataCallback)obj.getData(1));
                break;
            }
            case 5070: {
                this.onFailedCallback((RTCErrorCode)((Object)obj.getData(0)), (IRCRTCSwitchRoleDataCallback)obj.getData(1));
                this.mEngine.transitionTo(this.mEngine.mAudienceState);
                break;
            }
            case 1011: {
                this.mEngine.clearDeferredMessage();
                this.mEngine.deferMessage(msg);
                this.releaseRoom(true, null);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void switchToAudienceQuitMediaServer(final IRCRTCSwitchRoleCallback callback) {
        String roomId = this.mRoom.getRoomId();
        ReportUtil.libStatus(ReportUtil.TAG.SWITCH_TO_AUDIENCE, "desc", "quitMediaServer");
        SignalManager.getInstance().quitMediaServer(roomId, this.mRoom.getRoomType(), this.mRoom.getClientSessionId(), new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                SwitchingState.this.sendMessage(5072, (Object)callback);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.SWITCH_TO_AUDIENCE, "desc|code", "quitMediaServer", errorCode.getValue());
                if (errorCode.getValue() == 45001) {
                    SwitchingState.this.sendMessage(5072, (Object)callback);
                } else {
                    SwitchingState.this.sendMessage(5071, new Object[]{errorCode, callback});
                }
            }
        });
    }

    private void switchToAudience(final IRCRTCSwitchRoleCallback callback) {
        List<String> otherRoomIds = null;
        if (this.getMultiRoomManager() != null && this.getMultiRoomManager().getBaseRoomElemet() != null) {
            otherRoomIds = this.getMultiRoomManager().getBaseRoomElemet().leaveAllOtherRoom();
        }
        if (otherRoomIds != null && otherRoomIds.size() > 0) {
            for (final String otherRoomId : otherRoomIds) {
                this.getMultiRoomManager().getBaseRoomElemet().otherRoomRelease(otherRoomId);
                SignalManager.getInstance().sendleaveOtherRoomMessage(otherRoomId, new IRCRTCResultCallback(){

                    @Override
                    public void onSuccess() {
                        FinLog.d(TAG, "switchToAudience->leaveOtherRoom Success :" + otherRoomId);
                    }

                    @Override
                    public void onFailed(RTCErrorCode errorCode) {
                        FinLog.d(TAG, "switchToAudience->leaveOtherRoom Failed :" + otherRoomId + " errorCode :" + errorCode.getValue());
                    }
                });
            }
        }
        for (IStreamResource stream : this.mRoom.getAllSubscribedStreams()) {
            ((RCInputStreamImpl)stream).setSubscribeState(RCRTCSubscribeState.INIT);
        }
        this.mEngine.mRTCCore.freedPeerConnection();
        final String roomId = this.mRoom.getRoomId();
        final RCRTCRoomType tmpRoomType = this.mRoom.getRoomType();
        ReportUtil.libTask(ReportUtil.TAG.SWITCH_TO_AUDIENCE, "roomId|roomType", new Object[]{roomId, tmpRoomType});
        SignalManager.getInstance().switchRole(roomId, 1, tmpRoomType, "", "", new IRTCSwitchRoleCallback(){

            @Override
            public void onSuccess(List<RTCUser> rtcUsers, Map<String, Object> objects, Map<String, String> roomKVMap) {
                String token = (String)objects.get("joinRoomToken");
                if (TextUtils.isEmpty((CharSequence)token)) {
                    ReportUtil.libError(ReportUtil.TAG.SWITCH_TO_AUDIENCE, "roomId|code|desc", roomId, RTCErrorCode.RongRTCCodeParameterError.getValue(), "The token received is empty.");
                    SwitchingState.this.sendMessage(5062, (Object)callback);
                    return;
                }
                ReportUtil.libRes(ReportUtil.TAG.SWITCH_TO_AUDIENCE, "token", token);
                String finalToken = token;
                Object[] data = new Object[]{finalToken, roomKVMap};
                SwitchingState.this.sendMessage(5061, new Object[]{data, roomId, tmpRoomType, callback});
            }

            @Override
            public void onError(IRongCoreEnum.CoreErrorCode coreErrorCode) {
                ReportUtil.libError(ReportUtil.TAG.SWITCH_TO_AUDIENCE, "code", coreErrorCode.getValue());
                SwitchingState.this.sendMessage(5062, (Object)callback);
            }
        });
    }

    public void switchToAudienceSuccess(Object[] objects, String roomId, RCRTCRoomConfig roomConfig, IRCRTCSwitchRoleCallback callback) {
        RongRTCUtils.customRate = false;
        this.mEngine.version2UserIDs.clear();
        RongRTCUtils.customFPS = false;
        RongRtcStatMagr.instance.release();
        RongRtcStatMagr.instance.start(this.mRoom.getRoomId(), RCRTCLiveRole.AUDIENCE);
        this.mEngine.mDefaultAudioStream.switchToAudienceResetStream();
        this.mEngine.mDefaultVideoStream.switchToAudienceResetStream();
        this.mLocalUser.release();
        this.mRoom.switchToAudienceRelease();
        ReportUtil.libStatus(ReportUtil.TAG.SWITCH_TO_AUDIENCE, "roomId|desc", roomId, "releaseAll end");
        this.switchToAudienceComplete(objects, roomId, roomConfig, callback);
    }

    private String getRoomId() {
        return this.mEngine.getRoomId();
    }

    public void releaseRoom(boolean needQuitMediaServer, final IRCRTCResultCallback callBack) {
        List<String> otherRoomIds = null;
        if (this.getMultiRoomManager() != null && this.getMultiRoomManager().getBaseRoomElemet() != null) {
            otherRoomIds = this.getMultiRoomManager().getBaseRoomElemet().leaveAllOtherRoom();
        }
        if (otherRoomIds != null && otherRoomIds.size() > 0) {
            for (final String otherRoomId : otherRoomIds) {
                this.getMultiRoomManager().getBaseRoomElemet().otherRoomRelease(otherRoomId);
                SignalManager.getInstance().sendleaveOtherRoomMessage(otherRoomId, new IRCRTCResultCallback(){

                    @Override
                    public void onSuccess() {
                        FinLog.d(TAG, "releaseRoom->leaveOtherRoom Success :" + otherRoomId);
                    }

                    @Override
                    public void onFailed(RTCErrorCode errorCode) {
                        FinLog.d(TAG, "releaseRoom->leaveOtherRoom Failed :" + otherRoomId + " errorCode :" + errorCode.getValue());
                    }
                });
            }
        }
        ReportUtil.libTask(ReportUtil.TAG.RELEASEROOM, "roomId|needLeaveRoom", this.getRoomId(), needQuitMediaServer);
        RongRtcStatMagr.instance.release();
        RongRTCUtils.customRate = false;
        this.mEngine.version2UserIDs.clear();
        RongRTCUtils.customFPS = false;
        this.mEngine.mDefaultAudioStream.resetStream();
        this.mEngine.mDefaultVideoStream.resetStream();
        this.mEngine.screenShareOutputStream.resetStream();
        this.mLocalUser.release();
        this.mRoom.release();
        final String roomId = this.mRoom.getRoomId();
        if (needQuitMediaServer) {
            SignalManager.getInstance().leaveRoom(roomId, this.mRoom.getRoomType(), this.mRoom.getClientSessionId(), new IRCRTCResultCallback(){

                @Override
                public void onFailed(RTCErrorCode errorCode) {
                    ReportUtil.libErrorW(ReportUtil.TAG.RELEASEROOM, errorCode, "roomId", roomId);
                    SwitchingState.this.onFailedCallback(errorCode, callBack);
                }

                @Override
                public void onSuccess() {
                    ReportUtil.libRes(ReportUtil.TAG.RELEASEROOM, roomId);
                    SwitchingState.this.onSuccessCallback(callBack);
                }
            });
        } else {
            SignalManager.getInstance().leaveSignalRoom(roomId);
        }
        this.mLocalUser = null;
        this.mRoom = null;
        this.mEngine.mRoom = null;
        FinLog.i(TAG, "releaseAll end");
        this.transitionTo(this.mEngine.mDisConnectingState);
    }

    private void switchToAudienceComplete(Object[] objects, String roomId, RCRTCRoomConfig roomConfig, IRCRTCSwitchRoleCallback callback) {
        String token = (String)objects[0];
        Map data = (Map)objects[1];
        LinkedHashMap<String, RCRTCRemoteUser> remoteUsers = new LinkedHashMap<String, RCRTCRemoteUser>();
        RCRTCRemoteUser mcuUser = null;
        if (!TextUtils.isEmpty((CharSequence)((CharSequence)data.get("RC_ANCHOR_LIST")))) {
            String userId;
            try {
                JSONArray jsonArray = new JSONArray((String)data.get("RC_ANCHOR_LIST"));
                for (int i = 0; i < jsonArray.length(); ++i) {
                    userId = jsonArray.getString(i);
                    remoteUsers.put(userId, new RCRemoteUserImpl(userId, ""));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            for (Map.Entry entry : data.entrySet()) {
                RCRTCRemoteUser user;
                if (TextUtils.isEmpty((CharSequence)((CharSequence)entry.getValue())) || !((String)entry.getKey()).startsWith("RC_RES_") || (user = (RCRTCRemoteUser)remoteUsers.get(userId = ((String)entry.getKey()).substring("RC_RES_".length()))) == null) continue;
                try {
                    HandleChatRoomKVTools.updateRemoteUserRes((RCRemoteUserImpl)user, (String)entry.getValue(), null);
                    if (mcuUser != null) continue;
                    mcuUser = (RCRTCRemoteUser)HandleChatRoomKVTools.updateLiveStreams(null, (String)((String)entry.getValue()), (String)roomId, (RCRTCRoomType)roomConfig.getRoomType(), null).first;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        String sessionId = "";
        if (data.containsKey("RC_RTC_SESSIONID")) {
            sessionId = (String)data.get("RC_RTC_SESSIONID");
        }
        RCRTCRoomType roomType = roomConfig.getRoomType();
        if (this.mEngine.mRoom == null) {
            ReportUtil.libError(ReportUtil.TAG.SWITCH_TO_AUDIENCE, "desc", "Failed to switch to audience(mEngine.mRoom is empty)");
            this.onKickedCallback(callback);
            return;
        }
        this.initPeerConnection();
        this.mEngine.mRoom.refreshData(roomId, roomConfig, remoteUsers, sessionId, token, null, null);
        if (data.containsKey("RC_CDN")) {
            String value = (String)data.remove("RC_CDN");
            HandleChatRoomKVTools.updateCDNStream(this.mEngine.mRoom, mcuUser, value, roomId, roomType, null);
        }
        this.mEngine.mRoom.setVirtualLiveUser(mcuUser);
        SignalManager.getInstance().setRtcToken(this.mEngine.mRoom.getRtcToken());
        this.transitionTo(this.mEngine.mAudienceState);
        this.onSuccessCallback(callback);
    }

    private void initPeerConnection() {
        this.mEngine.mRTCCore.initPeerConnection(this.mEngine.mUserId, SignalManager.getInstance().getMaxStreamCount(), new RTCConnectionEventsImpl());
    }

    private void switchToBroadcaster(final List<? extends RCRTCOutputStream> publishLiveStreams, final IRCRTCSwitchRoleDataCallback<RCRTCLiveInfo> callback) {
        String sessionId = this.mRoom.getSessionId();
        if (TextUtils.isEmpty((CharSequence)sessionId)) {
            this.onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, callback);
            ReportUtil.libError(ReportUtil.TAG.SWITCH_TO_BROADCASTER, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "sessionId is empty");
            return;
        }
        ReportUtil.libStatus(ReportUtil.TAG.SWITCH_TO_BROADCASTER, "desc", "quitLive");
        SignalManager.getInstance().quitLive(null, this.mRoom.getRoomType().getRoomType(), sessionId, this.mRoom.getClientSessionId(), new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                SwitchingState.this.sendMessage(5073, publishLiveStreams, callback);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.SWITCH_TO_BROADCASTER, "desc|code", "quitLive", errorCode.getValue());
                if (errorCode.getValue() == 45001) {
                    SwitchingState.this.sendMessage(5073, publishLiveStreams, callback);
                } else {
                    SwitchingState.this.sendMessage(5070, new Object[]{errorCode, callback});
                }
            }
        });
    }

    private void switchRole(final List<? extends RCRTCOutputStream> publishLiveStreams, final IRCRTCSwitchRoleDataCallback<RCRTCLiveInfo> callback) {
        for (IStreamResource stream : this.mRoom.getAllSubscribedStreams()) {
            ((RCInputStreamImpl)stream).setSubscribeState(RCRTCSubscribeState.INIT);
        }
        ((RCLocalUserImpl)this.mRoom.getLocalUser()).release();
        this.mEngine.mRTCCore.freedPeerConnection();
        final RCRTCRoomType roomType = this.mRoom.getRoomType();
        final String roomId = this.mRoom.getRoomId();
        ReportUtil.libTask(ReportUtil.TAG.SWITCH_TO_BROADCASTER, "roomId|roomType", new Object[]{roomId, roomType});
        SignalManager.getInstance().switchRole(roomId, 2, roomType, "", "", new IRTCSwitchRoleCallback(){

            @Override
            public void onSuccess(List<RTCUser> rtcUsers, Map<String, Object> data, Map<String, String> roomKVMap) {
                String sessionId = "";
                String rtcToken = "";
                if (data != null) {
                    rtcToken = (String)data.get("joinRoomToken");
                    sessionId = (String)data.get("joinRoomSessionId");
                }
                ReportUtil.libRes(ReportUtil.TAG.SWITCH_TO_BROADCASTER, "roomId|token|sessionId", roomId, rtcToken, sessionId);
                Object[] objects = new Object[]{rtcUsers, data};
                SwitchingState.this.sendMessage(5065, new Object[]{objects, roomId, roomType, publishLiveStreams, callback});
            }

            @Override
            public void onError(IRongCoreEnum.CoreErrorCode coreErrorCode) {
                ReportUtil.libError(ReportUtil.TAG.SWITCH_TO_BROADCASTER, "code", coreErrorCode.getValue());
                SwitchingState.this.sendMessage(5066, (Object)callback);
            }
        });
    }

    private void switchToBroadcasterSuccess(String roomId, Object[] objects, List<? extends RCRTCOutputStream> publishLiveStreams, IRCRTCSwitchRoleDataCallback<RCRTCLiveInfo> callback) {
        RongRtcStatMagr.instance.release();
        RongRtcStatMagr.instance.start(this.getRoomId(), RCRTCLiveRole.BROADCASTER);
        this.mEngine.version2UserIDs.clear();
        ((RCLocalUserImpl)this.mRoom.getLocalUser()).release();
        this.mRoom.switchToBroadcaster();
        if (this.mEngine.mPlayer != null) {
            this.mEngine.mPlayer.release();
            this.mEngine.mPlayer.quitLooper();
            this.mEngine.mPlayer = null;
        }
        ReportUtil.libStatus(ReportUtil.TAG.SWITCH_TO_BROADCASTER, "roomId|desc", this.getRoomId(), "releaseAll end");
        String sessionId = null;
        String rtcToken = null;
        List list = (List)objects[0];
        Map exParams = (Map)objects[1];
        HashMap roomData = null;
        if (exParams != null) {
            rtcToken = (String)exParams.get("joinRoomToken");
            sessionId = (String)exParams.get("joinRoomSessionId");
            roomData = (HashMap)exParams.get("joinRoomData");
        }
        Object[] data = RongRTCUtils.parseRTCUser(list, this.mEngine.mUserId);
        Map remoteUsers = null;
        ArrayList otherRoomIdList = null;
        List oldStreams = null;
        if (objects != null) {
            remoteUsers = (Map)data[0];
            otherRoomIdList = (ArrayList)data[1];
            oldStreams = (List)data[2];
        }
        RongRTCUtils.sendUnpublishedCmd(oldStreams, roomId);
        int offlineKickTime = -1;
        if (exParams != null && exParams.get("offlineKickTime") != null) {
            offlineKickTime = (Integer)exParams.get("offlineKickTime");
        }
        RTCPingManager rtcPingManager = new RTCPingManager(roomId, this.mEngine.mContext, this.mEngine.mConfig.isAutoReconnect(), offlineKickTime);
        FinLog.d(TAG, "switchToBroadcasterSuccess->roomId : " + roomId + " , sessionId :" + sessionId);
        if (this.mEngine.mRoom == null) {
            ReportUtil.libError(ReportUtil.TAG.SWITCH_TO_BROADCASTER, "desc", "Failed to switch to broadcaster(mEngine.mRoom is empty)");
            this.onKickedCallback(callback);
            return;
        }
        this.initPeerConnection();
        this.mEngine.mRoom.refreshData(roomId, this.mRoomConfig, remoteUsers, sessionId, rtcToken, rtcPingManager, otherRoomIdList);
        MultiRoomManager multiRoomManager = new MultiRoomManager(this.mEngine.mRoom, rtcPingManager);
        RongRTCUtils.parseRoomKV(roomId, this.mEngine.mRoom, multiRoomManager, roomData);
        this.mEngine.mInRoomState.setMultiRoomManager(multiRoomManager);
        SignalManager.getInstance().setRtcToken(this.mEngine.mRoom.getRtcToken());
        Message msg = new Message();
        msg.what = 5067;
        Pair pair = new Pair(publishLiveStreams, callback);
        msg.obj = pair;
        this.mEngine.deferMessage(msg);
        this.transitionTo(this.mEngine.mInRoomState);
    }
}

