/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Message;
import android.text.TextUtils;
import cn.rongcloud.rtc.RongRTCMessageRouter;
import cn.rongcloud.rtc.api.RCRTCConfig;
import cn.rongcloud.rtc.api.RCRTCEngine;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.api.stream.RCRTCAudioStreamConfig;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.config.RCRTCConfigImpl;
import cn.rongcloud.rtc.center.config.RCServerConfig;
import cn.rongcloud.rtc.center.stream.RCAudioStreamConfigImpl;
import cn.rongcloud.rtc.center.stream.RCCameraOutputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCMicOutputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCScreenShareOutputStreamImpl;
import cn.rongcloud.rtc.core.MediaCodecProperties;
import cn.rongcloud.rtc.core.audio.AudioEffectManager;
import cn.rongcloud.rtc.core.audio.AudioMixer;
import cn.rongcloud.rtc.core.rongRTC.DevicesUtils;
import cn.rongcloud.rtc.engine.AbstractBaseState;
import cn.rongcloud.rtc.engine.MsgObjectWraper;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.module.AudioDeviceManager;
import cn.rongcloud.rtc.module.camera.CameraManagerImpl;
import cn.rongcloud.rtc.monitor.NetworkConnectChangedReceiver;
import cn.rongcloud.rtc.signal.SignalEventListener;
import cn.rongcloud.rtc.signal.SignalManager;
import cn.rongcloud.rtc.utils.DeviceUtils;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.RongRTCSessionManager;
import cn.rongcloud.rtc.webrtc.IWebRTCCore;
import cn.rongcloud.rtc.webrtc.WebRTCCoreImpl;
import io.rong.common.RLog;
import io.rong.imlib.ModuleManager;

public class UnInitState
extends AbstractBaseState {
    private static final String TAG = "UnInitState";
    boolean mCallInited;
    boolean mIMConnected;
    NetworkConnectChangedReceiver networkConnectChangedReceiver;
    RongRTCMessageRouter mMessageRouter;
    SignalEventListener signalEventListener;

    public UnInitState(RTCEngineImpl engine) {
        super(engine);
    }

    @Override
    public void enter() {
        super.enter();
        if (!this.mIMConnected) {
            this.mEngine.mUserId = "";
            this.mEngine.mToken = "";
        }
    }

    @Override
    public boolean handleMessage(Message msg, MsgObjectWraper obj) {
        switch (msg.what) {
            case 1010: {
                if (this.mIMConnected) break;
                this.mIMConnected = true;
                this.mEngine.mUserId = (String)obj.getData(0);
                this.mEngine.mToken = (String)obj.getData(1);
                this.doGetConfig();
                this.onNext();
                break;
            }
            case 1000: {
                if (!this.mCallInited) {
                    ReportUtil.appStatus(ReportUtil.TAG.RTCINIT, "model|platform|rtcSDK", DeviceUtils.getBuildModel(), "Android-" + Build.VERSION.RELEASE, RCRTCEngine.getVersion());
                    this.mCallInited = true;
                    this.mEngine.mContext = (Context)obj.getData(0);
                    this.mEngine.mConfig = (RCRTCConfigImpl)obj.getData(1);
                    this.mEngine.mAudioConfig = (RCAudioStreamConfigImpl)obj.getData(2);
                    this.onPrepare(this.mEngine.mContext);
                    this.onNext();
                }
                this.mEngine.notifyAndReInitCountDownLatch();
                break;
            }
            case 1011: {
                this.imSignOut();
                this.mEngine.mUserId = "";
                this.mEngine.mToken = "";
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void doGetConfig() {
        SignalManager.getInstance().getRTCConfig(Build.MODEL, String.valueOf(Build.VERSION.SDK_INT), System.currentTimeMillis(), RCRTCEngine.getVersion(), new IRCRTCResultDataCallback<String>(){

            @Override
            public void onSuccess(String data) {
                if (!TextUtils.isEmpty((CharSequence)data)) {
                    RCServerConfig.saveConfig(RongRTCSessionManager.getInstance(), data);
                } else {
                    FinLog.e(UnInitState.TAG, "doGetConfig Failed data is Null");
                }
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
            }
        });
    }

    private void onPrepare(Context context) {
        this.mMessageRouter = new RongRTCMessageRouter();
        ModuleManager.addMessageRouter((ModuleManager.MessageRouter)this.mMessageRouter);
        this.registerNetWorkReceiver(context);
        MediaCodecProperties.init();
        this.mEngine.initFaceBeautyPlugin(context);
        this.mEngine.initVoiceBeautyPlugin(context);
    }

    private void registerNetWorkReceiver(Context context) {
        try {
            if (this.networkConnectChangedReceiver != null) {
                context.unregisterReceiver((BroadcastReceiver)this.networkConnectChangedReceiver);
            }
            this.networkConnectChangedReceiver = new NetworkConnectChangedReceiver();
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            intentFilter.addAction("action_reconnect");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            context.registerReceiver((BroadcastReceiver)this.networkConnectChangedReceiver, intentFilter);
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)("registerNetWorkReceiver failed: " + e.getMessage()));
        }
    }

    private void onNext() {
        if (this.mIMConnected && this.signalEventListener == null) {
            this.signalEventListener = new SignalEventListener();
            SignalManager.getInstance().setRTCRoomEventListener(this.signalEventListener);
        }
        if (this.mCallInited && this.mEngine.mContext != null && !TextUtils.isEmpty((CharSequence)this.mEngine.mUserId) && !TextUtils.isEmpty((CharSequence)this.mEngine.mToken)) {
            FinLog.d(TAG, "onNext --> enter");
            this.onInitRTC();
            this.mEngine.transitionTo(this.mEngine.mIdleState);
            FinLog.d(TAG, "onNext --> over");
        }
    }

    private void onInitRTC() {
        RCRTCConfigImpl config = this.mEngine.mConfig;
        if (config == null) {
            config = (RCRTCConfigImpl)RCRTCConfig.Builder.create().build();
        }
        this.updateRTCDevice(config);
        RCRTCAudioStreamConfig audioConfig = this.mEngine.mAudioConfig;
        if (audioConfig == null) {
            audioConfig = RCRTCAudioStreamConfig.Builder.create().buildDefaultMode();
        }
        AudioDeviceManager audioDeviceManager = new AudioDeviceManager(this.mEngine.mContext, config, (RCAudioStreamConfigImpl)audioConfig, AudioMixer.getInstance());
        audioDeviceManager.setVoiceBeautifier(this.mEngine.mVoiceBeautifierPlugin);
        AudioEffectManager audioEffectManager = new AudioEffectManager(this.mEngine.mContext, config.getAudioSampleRate(), config.isStereo() ? 2 : 1, 2);
        CameraManagerImpl cameraManager = new CameraManagerImpl(config.isEncoderTexture(), this.mEngine.getEglBaseContext(), this.mEngine.mContext);
        this.mEngine.mRTCCore = new WebRTCCoreImpl(this.mEngine.mContext, config, audioDeviceManager);
        String userId = this.mEngine.mUserId;
        IWebRTCCore rtcCore = this.mEngine.mRTCCore;
        this.mEngine.mDefaultVideoStream = new RCCameraOutputStreamImpl(userId, cameraManager);
        if (Build.VERSION.SDK_INT >= 21) {
            this.mEngine.screenShareOutputStream = new RCScreenShareOutputStreamImpl(userId, this.mEngine.getContext(), config);
        }
        this.mEngine.bindCameraBeauty();
        rtcCore.bindingTrack(this.mEngine.mDefaultVideoStream);
        rtcCore.bindingTrack(this.mEngine.screenShareOutputStream);
        this.mEngine.mDefaultAudioStream = new RCMicOutputStreamImpl(userId, audioDeviceManager, audioEffectManager);
        AudioMixer.getInstance().setDefaultAudioStream(this.mEngine.mDefaultAudioStream);
    }

    @Deprecated
    private void updateRTCDevice(RCRTCConfigImpl rongRTCConfig) {
        DevicesUtils.setHighProfile(rongRTCConfig.isEncoderHighProfile());
        DevicesUtils.setEnCodeColor(rongRTCConfig.getEncoderColor());
        DevicesUtils.setDeCodeColor(rongRTCConfig.getDecoderColor());
        DevicesUtils.setEnCodeBitRateMode(rongRTCConfig.getEncoderBitMode());
        DevicesUtils.setTexture(rongRTCConfig.isEncoderTexture());
        DevicesUtils.setCustomizedCameraParameter(rongRTCConfig.getCustomizedCameraParameter());
        DevicesUtils.setAudioSource(rongRTCConfig.getAudioSource());
        DevicesUtils.setAudioSampleRate(rongRTCConfig.getAudioSampleRate());
        DevicesUtils.setAudioStereo(rongRTCConfig.isStereo());
    }

    @Override
    public String getName() {
        return TAG;
    }

    public void imSignOut() {
        this.mIMConnected = false;
    }
}

