/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio;

import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;

@JNINamespace(value="liteav::audio")
class LiteavAudioApiDetector {
    private static final boolean DEBUG = true;
    private static final String TAG = "LiteavAudioApiDetector";
    private boolean mIsOboeSupported;
    private boolean mIsOpenSLSupported;
    private boolean mIsAAudioSupported;
    private boolean mIsFastJavaSupported;

    @CalledByNative
    LiteavAudioApiDetector(long nativeApiDetector) {
        this.storeAudioParameters();
        LiteavAudioApiDetector.nativeCacheAudioParameters(nativeApiDetector, this.mIsOpenSLSupported, this.mIsAAudioSupported, this.mIsFastJavaSupported);
    }

    private boolean isOboeSupported() {
        return this.isOpenSLSupported() || this.isAAudioSupported();
    }

    private boolean isOpenSLSupported() {
        return LiteavSystemInfo.getSystemOSVersionInt() >= 24;
    }

    private boolean isAAudioSupported() {
        return LiteavSystemInfo.getSystemOSVersionInt() >= 27;
    }

    private boolean isFastJavaSupported() {
        return LiteavSystemInfo.getSystemOSVersionInt() >= 29;
    }

    private void storeAudioParameters() {
        this.mIsOboeSupported = this.isOboeSupported();
        this.mIsOpenSLSupported = this.isOpenSLSupported();
        this.mIsAAudioSupported = this.isAAudioSupported();
        this.mIsFastJavaSupported = this.isFastJavaSupported();
    }

    private static native void nativeCacheAudioParameters(long var0, boolean var2, boolean var3, boolean var4);
}

