/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base.system;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Debug;
import android.os.Process;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.b.a;
import com.tencent.liteav.base.system.c;
import com.tencent.liteav.base.system.d;
import com.tencent.liteav.base.system.e;
import com.tencent.liteav.base.system.f;
import com.tencent.liteav.base.system.g;
import com.tencent.liteav.base.system.h;
import com.tencent.liteav.base.system.i;
import com.tencent.liteav.base.system.j;
import com.tencent.liteav.base.system.k;
import com.tencent.liteav.base.system.l;
import com.tencent.liteav.base.system.m;
import com.tencent.liteav.base.system.n;
import com.tencent.liteav.base.system.o;
import com.tencent.liteav.base.util.Rotation;
import com.tencent.liteav.base.util.t;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

@JNINamespace(value="liteav")
public class LiteavSystemInfo {
    private static final String TAG = "LiteavBaseSystemInfo";
    private static final int GET_APP_MEMORY_INTERVAL_MS = 15000;
    private static final int APP_SYSTEM_METHOD_DEFAULT_GET_INTERVAL_MS = 1000;
    private static final String EXT_KEY_BUILD_MODEL = "buildModel";
    private static final String EXT_KEY_BUILD_BRAND = "buildBrand";
    private static final String EXT_KEY_BUILD_MANUFACTURER = "buildManufacturer";
    private static final String EXT_KEY_BUILD_HARDWARE = "buildHardware";
    private static final String EXT_KEY_BUILD_VERSION = "buildVersion";
    private static final String EXT_KEY_BUILD_VERSION_INT = "buildVersionInt";
    private static final String EXT_KEY_BUILD_BOARD = "buildBoard";
    private static final String EXT_KEY_APP_NAME = "appName";
    private static final String EXT_KEY_APP_PACKAGE_NAME = "appPackageName";
    private static final String EXT_KEY_APP_VERSION = "appVersion";
    private static final String EXT_KEY_APP_BACKGROUND = "isAppBackground";
    private static final int NETWORK_TYPE_UNKNOWN = 0;
    private static final int NETWORK_TYPE_WIFI = 1;
    private static final int NETWORK_TYPE_4G = 2;
    private static final int NETWORK_TYPE_3G = 3;
    private static final int NETWORK_TYPE_2G = 4;
    private static final int NETWORK_TYPE_WIRED = 5;
    private static final int NETWORK_TYPE_5G = 6;
    private static final t<String> sModel = new t(g.a());
    private static final t<String> sBrand = new t(h.a());
    private static final t<String> sManufacturer = new t(i.a());
    private static final t<String> sHardware = new t(j.a());
    private static final t<String> sSystemOSVersion = new t(k.a());
    private static final t<Integer> sSystemOSVersionInt = new t(l.a());
    private static final t<String> sBoard = new t(m.a());
    private static final t<String> sAppPackageName = new t(n.a());
    private static final t<String> sAppName = new t(d.a());
    private static final t<String> sAppVersion = new t(e.a());
    private static final t<String> sUUID = new t(f.a());
    private static AtomicBoolean sIsGettingMemoryUsage = new AtomicBoolean(false);
    private static AtomicInteger sLastMemoryUsage = new AtomicInteger(0);
    private static final a sMemoryUsageThrottler = new a(15000L);
    private static int sLastNetworkType = 0;
    private static final a sNetworkTypeThrottler = new a(1000L);
    private static int sLastGateway = 0;
    private static final a sGatewayThrottler = new a(1000L);
    private static boolean sLastMicPermission = false;
    private static final a sMicPermissionThrottler = new a(1000L);

    public static boolean setExtID(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        String string = key;
        int n2 = -1;
        switch (string.hashCode()) {
            case -487188133: {
                if (!string.equals(EXT_KEY_BUILD_MODEL)) break;
                n2 = 0;
                break;
            }
            case -497260103: {
                if (!string.equals(EXT_KEY_BUILD_BRAND)) break;
                n2 = 1;
                break;
            }
            case -589756065: {
                if (!string.equals(EXT_KEY_BUILD_MANUFACTURER)) break;
                n2 = 2;
                break;
            }
            case -391134602: {
                if (!string.equals(EXT_KEY_BUILD_HARDWARE)) break;
                n2 = 3;
                break;
            }
            case -911706486: {
                if (!string.equals(EXT_KEY_BUILD_VERSION)) break;
                n2 = 4;
                break;
            }
            case 725329157: {
                if (!string.equals(EXT_KEY_BUILD_VERSION_INT)) break;
                n2 = 5;
                break;
            }
            case -497349352: {
                if (!string.equals(EXT_KEY_BUILD_BOARD)) break;
                n2 = 6;
                break;
            }
            case -794136500: {
                if (!string.equals(EXT_KEY_APP_NAME)) break;
                n2 = 7;
                break;
            }
            case -441921776: {
                if (!string.equals(EXT_KEY_APP_PACKAGE_NAME)) break;
                n2 = 8;
                break;
            }
            case 1484112759: {
                if (!string.equals(EXT_KEY_APP_VERSION)) break;
                n2 = 9;
                break;
            }
            case -1978299099: {
                if (!string.equals(EXT_KEY_APP_BACKGROUND)) break;
                n2 = 10;
            }
        }
        switch (n2) {
            case 0: {
                sModel.a(value);
                break;
            }
            case 1: {
                sBrand.a(value);
                break;
            }
            case 2: {
                sManufacturer.a(value);
                break;
            }
            case 3: {
                sHardware.a(value);
                break;
            }
            case 4: {
                sSystemOSVersion.a(value);
                break;
            }
            case 5: {
                try {
                    int n3 = Integer.parseInt(value);
                    sSystemOSVersionInt.a(n3);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 6: {
                sBoard.a(value);
                break;
            }
            case 7: {
                sAppName.a(value);
                break;
            }
            case 8: {
                sAppPackageName.a(value);
                break;
            }
            case 9: {
                sAppVersion.a(value);
                break;
            }
            case 10: {
                try {
                    com.tencent.liteav.base.util.j.a(Integer.parseInt(value) == 1);
                    break;
                }
                catch (Exception exception) {
                    Log.e(TAG, "set app background state failed. ".concat(String.valueOf(exception)), new Object[0]);
                    return false;
                }
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @CalledByNative
    public static String getDeviceUuid() {
        return sUUID.a();
    }

    public static String getHardware() {
        return sHardware.a();
    }

    @CalledByNative
    public static String getManufacturer() {
        return sManufacturer.a();
    }

    public static String getBoard() {
        return sBoard.a();
    }

    @CalledByNative
    public static String getModel() {
        return sModel.a();
    }

    public static String getBrand() {
        return sBrand.a();
    }

    @CalledByNative
    public static String getSystemOSVersion() {
        return sSystemOSVersion.a();
    }

    @CalledByNative
    public static int getSystemOSVersionInt() {
        return sSystemOSVersionInt.a();
    }

    @CalledByNative
    public static String getAppName() {
        return sAppName.a();
    }

    @CalledByNative
    public static String getAppPackageName() {
        return sAppPackageName.a();
    }

    @CalledByNative
    public static String getAppVersion() {
        return sAppVersion.a();
    }

    @CalledByNative
    public static synchronized int getAppMemoryUsage() {
        if (sMemoryUsageThrottler.a()) {
            LiteavSystemInfo.getAppMemoryUsageFromSystem();
        }
        return sLastMemoryUsage.get();
    }

    private static void getAppMemoryUsageFromSystem() {
        if (sIsGettingMemoryUsage.get()) {
            return;
        }
        sIsGettingMemoryUsage.set(true);
        AsyncTask.execute((Runnable)c.a());
    }

    @CalledByNative
    public static synchronized int getAppBackgroundState() {
        if (com.tencent.liteav.base.util.j.a().b()) {
            return 1;
        }
        return 0;
    }

    @CalledByNative
    public static synchronized int getNetworkType() {
        if (sNetworkTypeThrottler.a()) {
            sLastNetworkType = LiteavSystemInfo.getNetworkTypeFromSystem();
        }
        return sLastNetworkType;
    }

    private static int getNetworkTypeFromSystem() {
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            return 0;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        NetworkInfo networkInfo = null;
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        catch (Exception exception) {
            Log.e(TAG, "getNetworkType error occurred.", exception);
        }
        if (networkInfo == null) {
            return 0;
        }
        if (!networkInfo.isConnected()) {
            return 0;
        }
        if (networkInfo.getType() == 9) {
            return 5;
        }
        if (networkInfo.getType() == 1) {
            return 1;
        }
        if (networkInfo.getType() == 0) {
            int n2;
            try {
                n2 = telephonyManager.getNetworkType();
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return 4;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return 3;
                    }
                    case 13: {
                        return 2;
                    }
                }
            }
            catch (Exception exception) {
                Log.e(TAG, "getNetworkType error occurred.", exception);
                return 2;
            }
            if (LiteavSystemInfo.getSystemOSVersionInt() >= 29 && n2 == 20) {
                return 6;
            }
            return 2;
        }
        return 0;
    }

    @CalledByNative
    public static synchronized int getGateway() {
        if (sGatewayThrottler.a()) {
            sLastGateway = LiteavSystemInfo.getGatewayFromSystem();
        }
        return sLastGateway;
    }

    private static int getGatewayFromSystem() {
        int n2;
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            return 0;
        }
        try {
            n2 = ((WifiManager)context.getSystemService((String)"wifi")).getDhcpInfo().gateway;
        }
        catch (Throwable throwable) {
            Log.e(TAG, "getGateway error " + throwable.getMessage(), new Object[0]);
            n2 = 0;
        }
        return n2;
    }

    @CalledByNative
    public static synchronized boolean getAudioRecordPermission() {
        if (sMicPermissionThrottler.a()) {
            sLastMicPermission = LiteavSystemInfo.getAudioRecordPermissionFromSystem();
        }
        return sLastMicPermission;
    }

    private static boolean getAudioRecordPermissionFromSystem() {
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            return false;
        }
        return 0 == context.checkPermission("android.permission.RECORD_AUDIO", Process.myPid(), Process.myUid());
    }

    @CalledByNative
    public static void setAppDisplayRotation(int rotation) {
        com.tencent.liteav.base.util.j.a().a(Rotation.a(rotation));
    }

    static /* synthetic */ void lambda$getAppMemoryUsageFromSystem$8() {
        int n2 = 0;
        try {
            Debug.MemoryInfo memoryInfo = new Debug.MemoryInfo();
            Debug.getMemoryInfo((Debug.MemoryInfo)memoryInfo);
            n2 = memoryInfo.getTotalPss();
        }
        catch (Exception exception) {
            Log.e(TAG, "Get App memory usage failed." + exception.getMessage(), new Object[0]);
        }
        sLastMemoryUsage.set(n2 / 1024);
        sIsGettingMemoryUsage.set(false);
    }

    static /* synthetic */ String lambda$static$7() throws Exception {
        return o.a(sAppPackageName.a());
    }

    static /* synthetic */ String lambda$static$6() throws Exception {
        return Build.BOARD;
    }

    static /* synthetic */ Integer lambda$static$5() throws Exception {
        return Build.VERSION.SDK_INT;
    }

    static /* synthetic */ String lambda$static$4() throws Exception {
        return Build.VERSION.RELEASE;
    }

    static /* synthetic */ String lambda$static$3() throws Exception {
        return Build.HARDWARE;
    }

    static /* synthetic */ String lambda$static$2() throws Exception {
        return Build.MANUFACTURER;
    }

    static /* synthetic */ String lambda$static$1() throws Exception {
        return Build.BRAND;
    }

    static /* synthetic */ String lambda$static$0() throws Exception {
        return Build.MODEL;
    }
}

