/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.commonaudio.codec;

import android.media.MediaFormat;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.commonaudio.codec.AacMediaCodecWrapper;
import java.nio.ByteBuffer;

public class HardwareAacDecoder {
    private final AacMediaCodecWrapper a = new AacMediaCodecWrapper(AacMediaCodecWrapper.a.b);

    @CalledByNative
    public HardwareAacDecoder() {
    }

    @CalledByNative
    public boolean init(int sampleRate, int channels, ByteBuffer specificConfig) {
        MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)sampleRate, (int)channels);
        mediaFormat.setString("mime", "audio/mp4a-latm");
        mediaFormat.setByteBuffer("csd-0", specificConfig);
        return this.a.a(mediaFormat);
    }

    @CalledByNative
    public ByteBuffer decode(ByteBuffer encodedData) {
        return this.a.processFrame(encodedData);
    }

    @CalledByNative
    public int getOutputSampleRate() {
        MediaFormat mediaFormat = this.a.a;
        if (mediaFormat == null) {
            return -1;
        }
        int n2 = -1;
        try {
            n2 = mediaFormat.getInteger("sample-rate");
        }
        catch (Exception exception) {
            Log.e("HardwareAacDecoder", "getOutputSampleRate failed. ".concat(String.valueOf(exception)), new Object[0]);
        }
        return n2;
    }

    @CalledByNative
    public int getOutputChannelCount() {
        MediaFormat mediaFormat = this.a.a;
        if (mediaFormat == null) {
            return -1;
        }
        int n2 = -1;
        try {
            n2 = mediaFormat.getInteger("channel-count");
        }
        catch (Exception exception) {
            Log.e("HardwareAacDecoder", "getOutputChannelCount failed. ".concat(String.valueOf(exception)), new Object[0]);
        }
        return n2;
    }

    @CalledByNative
    public int getCacheSize() {
        return this.a.b;
    }

    @CalledByNative
    public void unInit() {
        this.a.a();
    }
}

