/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.decoder;

import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Rotation;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.i;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.h;
import com.tencent.liteav.videoconsumer.consumer.VideoConsumerServerConfig;
import com.tencent.liteav.videoconsumer.decoder.VideoDecoderDef;
import com.tencent.liteav.videoconsumer.decoder.bl;
import com.tencent.liteav.videoconsumer.decoder.bm;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::video")
public class SoftwareVideoDecoder
implements bl {
    private static final String TAG = "SoftwareVideoDecoder";
    private long mNativeVideoDecoderWrapper = 0L;
    @NonNull
    private final IVideoReporter mReporter;
    private final boolean mIsUseHevc;
    private bm mListener;
    private i mPixelFramePool;

    public SoftwareVideoDecoder(@NonNull IVideoReporter reporter, boolean isUseHevc) {
        this.mReporter = reporter;
        this.mIsUseHevc = isUseHevc;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void uninitialize() {
    }

    @Override
    public void setScene(VideoDecoderDef.ConsumerScene scene) {
    }

    @Override
    public void start(Object glContext, bm listener) {
        if (this.mNativeVideoDecoderWrapper != 0L) {
            LiteavLog.w(TAG, "decoder is already started!");
            return;
        }
        this.mPixelFramePool = new i();
        this.mListener = listener;
        this.mNativeVideoDecoderWrapper = SoftwareVideoDecoder.nativeCreate(this);
        if (this.mNativeVideoDecoderWrapper == 0L) {
            this.handleDecoderError(h.c.l, "VideoDecode: out of memory, Start decoder failed");
            LiteavLog.e(TAG, "create native instance failed.");
            return;
        }
        if (SoftwareVideoDecoder.nativeStart(this.mNativeVideoDecoderWrapper, this.mIsUseHevc) != 0) {
            this.handleDecoderError(h.c.m, "VideoDecode: Start decoder failed");
            LiteavLog.e(TAG, "Start software decoder failed.");
            return;
        }
        this.mReporter.notifyEvent(h.b.F, null, "Start decoder success");
        LiteavLog.i(TAG, "decoder Start success.");
    }

    @Override
    public boolean decode(EncodedVideoFrame frame) {
        if (frame == null) {
            return false;
        }
        if (frame.isEosFrame && this.mListener != null) {
            this.mListener.k();
            return true;
        }
        if (frame.data == null || frame.data.remaining() == 0) {
            return false;
        }
        EncodedVideoFrame encodedVideoFrame = frame;
        SoftwareVideoDecoder.nativeDecodeFrame(this.mNativeVideoDecoderWrapper, encodedVideoFrame, encodedVideoFrame.data, frame.nalType.mValue, frame.codecType.mValue, frame.rotation, frame.pts, frame.dts);
        frame.release();
        return true;
    }

    @Override
    public void stop() {
        if (this.mNativeVideoDecoderWrapper == 0L) {
            LiteavLog.w(TAG, "decoder has already stopped");
            return;
        }
        if (this.mPixelFramePool != null) {
            this.mPixelFramePool.b();
        }
        SoftwareVideoDecoder.nativeStop(this.mNativeVideoDecoderWrapper);
        SoftwareVideoDecoder.nativeDestroy(this.mNativeVideoDecoderWrapper);
        this.mNativeVideoDecoderWrapper = 0L;
        LiteavLog.i(TAG, "decoder stop.");
    }

    @Override
    public void abandonDecodingFrames() {
        if (this.mNativeVideoDecoderWrapper == 0L) {
            LiteavLog.w(TAG, "decoder has already stopped");
            return;
        }
        SoftwareVideoDecoder.nativeAbandonDecodingFrames(this.mNativeVideoDecoderWrapper);
        if (this.mListener != null) {
            this.mListener.j();
        }
    }

    @Override
    public bl.a getDecoderType() {
        return bl.a.a;
    }

    @Override
    public void setServerConfig(VideoConsumerServerConfig config) {
    }

    private void handleDecoderError(h.c code, String msg) {
        this.mReporter.notifyWarning(code, msg);
        if (this.mListener != null) {
            this.mListener.i();
        }
    }

    @CalledByNative
    private void onDecodedFrame(PixelFrame frame, long errCode) {
        if (errCode != 0L) {
            this.handleDecoderError(h.c.n, "VideoDecode: decode error, errCode:".concat(String.valueOf(errCode)));
            LiteavLog.e(TAG, "decode failed.".concat(String.valueOf(errCode)));
            if (frame != null) {
                frame.release();
            }
            return;
        }
        if (frame != null) {
            if (this.mListener != null) {
                PixelFrame pixelFrame = frame;
                this.mListener.a(pixelFrame, pixelFrame.getTimestamp());
            }
            frame.release();
        }
    }

    @CalledByNative
    private PixelFrame obtainPixelFrame(int formatType, int width, int height, int rotation, long timestamp, int colorSpace, int colorRange) {
        GLConstants.PixelFormatType pixelFormatType = GLConstants.PixelFormatType.a(formatType);
        if (pixelFormatType == null) {
            this.handleDecoderError(h.c.o, "unknown format:".concat(String.valueOf(formatType)));
            LiteavLog.e(TAG, "obtainPixelFrame formatType: ".concat(String.valueOf(formatType)));
            return null;
        }
        if (this.mPixelFramePool == null) {
            LiteavLog.i(TAG, "obtainPixelFrame mPixelFramePool is null.");
            return null;
        }
        PixelFrame pixelFrame = this.mPixelFramePool.a(width, height, GLConstants.PixelBufferType.a, pixelFormatType);
        pixelFrame.setRotation(Rotation.a(rotation));
        pixelFrame.setTimestamp(timestamp);
        pixelFrame.setColorRange(GLConstants.ColorRange.a(colorRange));
        pixelFrame.setColorSpace(GLConstants.ColorSpace.a(colorSpace));
        return pixelFrame;
    }

    @CalledByNative
    private ByteBuffer getByteBufferFromPixelFrame(PixelFrame frame) {
        return frame.getBuffer();
    }

    public static native boolean nativeIsSoftwareHevcDecoderSupport();

    public static native boolean nativeIsRpsDecodeSupport();

    private static native long nativeCreate(SoftwareVideoDecoder var0);

    private static native void nativeDestroy(long var0);

    private static native int nativeStart(long var0, boolean var2);

    private static native int nativeStop(long var0);

    private static native int nativeDecodeFrame(long var0, EncodedVideoFrame var2, ByteBuffer var3, int var4, int var5, int var6, long var7, long var9);

    private static native void nativeAbandonDecodingFrames(long var0);
}

