/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.encoder;

import android.annotation.SuppressLint;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import androidx.annotation.RequiresApi;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.storage.PersistStorage;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.videoproducer.encoder.SoftwareEncoderWrapper;
import com.tencent.liteav.videoproducer.encoder.VideoEncoderDef;
import com.tencent.liteav.videoproducer.producer.ServerVideoProducerConfig;

@JNINamespace(value="liteav::video")
public class EncodeAbilityProvider {
    private static final String TAG = "EncodeAbilityProvider";
    private static final int DEVICE_SUPPORT_CHECK_WIDTH = 1080;
    private static final int DEVICE_SUPPORT_CHECK_HEIGHT = 1920;
    private static final int DEVICE_SUPPORT_CHECK_FPS = 30;
    private static final String KEY_HEVC_ENCODE_ABILITY = "Liteav.Video.android.local.encoder.enable.hw.hevc";
    private final VideoEncoderDef.EncodeAbility mEncodeAbility = new VideoEncoderDef.EncodeAbility();
    private final l mAsyncRunner = new l();

    @CalledByNative
    public static EncodeAbilityProvider getInstance() {
        return a.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EncodeAbilityProvider() {
        this.mAsyncRunner.a(com.tencent.liteav.videoproducer.encoder.a.a(this));
        EncodeAbilityProvider encodeAbilityProvider = this;
        synchronized (encodeAbilityProvider) {
            this.mEncodeAbility.c = this.isSWHevcEncodeSupport();
            this.mEncodeAbility.d = this.isHWHevcEncodeSupport();
            return;
        }
    }

    public VideoEncoderDef.EncodeAbility getEncodeAbility() {
        return this.mEncodeAbility;
    }

    public void setHwHevcEncodeSupported(boolean supported) {
        this.mEncodeAbility.d = supported;
    }

    public void setRPSEncodeSupported(boolean supported) {
        this.mEncodeAbility.a = supported;
    }

    public boolean isHevcEncodeSupport() {
        return this.mEncodeAbility.c || this.mEncodeAbility.d;
    }

    @CalledByNative
    public boolean isHWHevcEncodeSupport() {
        if (!ServerVideoProducerConfig.isHWHevcEncodeAllowed()) {
            return false;
        }
        Integer n2 = new PersistStorage("com.liteav.storage.global").getInt(KEY_HEVC_ENCODE_ABILITY);
        return n2 != null && n2 > 0;
    }

    public boolean isSWHevcEncodeSupport() {
        return SoftwareEncoderWrapper.nativeIsSoftwareHevcEncoderSupport();
    }

    @SuppressLint(value={"NewApi"})
    private static boolean isDeviceHWHevcEncodeSupport(int width, int height, int fps) {
        if (!ServerVideoProducerConfig.isHWHevcEncodeAllowed()) {
            return false;
        }
        if (LiteavSystemInfo.getSystemOSVersionInt() < 21) {
            return false;
        }
        return EncodeAbilityProvider.isMediaCodecSupportHevc(width, height, fps);
    }

    @RequiresApi(api=21)
    private static boolean isMediaCodecSupportHevc(int width, int height, int fps) {
        block0: for (MediaCodecInfo mediaCodecInfo : new MediaCodecList(1).getCodecInfos()) {
            if (!mediaCodecInfo.isEncoder()) continue;
            for (String string : mediaCodecInfo.getSupportedTypes()) {
                if (!string.contains("video/hevc")) continue;
                MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(string);
                if (codecCapabilities == null) {
                    return false;
                }
                MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities.getVideoCapabilities();
                if (videoCapabilities == null) {
                    return false;
                }
                if (!videoCapabilities.areSizeAndRateSupported(width, height, (double)fps) || !videoCapabilities.areSizeAndRateSupported(height, width, (double)fps)) continue block0;
                LiteavLog.i(TAG, "got hevc encoder:%s, type:%s", mediaCodecInfo.getName(), string);
                return true;
            }
        }
        LiteavLog.w(TAG, "not got hevc encoder");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void lambda$new$0(EncodeAbilityProvider this_) {
        boolean bl2 = EncodeAbilityProvider.isDeviceHWHevcEncodeSupport(1080, 1920, 30);
        PersistStorage persistStorage = new PersistStorage("com.liteav.storage.global");
        persistStorage.put(KEY_HEVC_ENCODE_ABILITY, bl2 ? 1 : 0);
        persistStorage.commit();
        EncodeAbilityProvider encodeAbilityProvider = this_;
        synchronized (encodeAbilityProvider) {
            this_.mEncodeAbility.c = this_.isSWHevcEncodeSupport();
            this_.mEncodeAbility.d = this_.isHWHevcEncodeSupport();
            return;
        }
    }

    static final class a {
        private static final EncodeAbilityProvider a = new EncodeAbilityProvider();
    }
}

