/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.api.stream;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import cn.rongcloud.rtc.api.RCRTCEngine;
import cn.rongcloud.rtc.api.stream.RCRTCScreenShareService;
import cn.rongcloud.rtc.center.stream.RCScreenShareOutputStreamImpl;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.utils.ReportUtil;

@TargetApi(value=21)
public class RCRTCScreenShareActivity
extends Activity {
    private static final int SCREEN_CAPTURE_REQUEST_CODE = 10101;
    private MediaProjectionManager mediaProjectionManager;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        ReportUtil.libStatus(ReportUtil.TAG.START_SCREEN_CAPTURE_ACTIVITY, "", "");
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.mediaProjectionManager = (MediaProjectionManager)this.getApplicationContext().getSystemService("media_projection");
        Intent intent = this.mediaProjectionManager.createScreenCaptureIntent();
        this.startActivityForResult(intent, 10101);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (Build.VERSION.SDK_INT >= 26) {
            Intent intent = new Intent((Context)this, RCRTCScreenShareService.class);
            intent.putExtra("code", resultCode);
            intent.putExtra("data", (Parcelable)data);
            this.startForegroundService(intent);
        } else {
            MediaProjection mediaProjection = this.mediaProjectionManager.getMediaProjection(resultCode, data);
            RCScreenShareOutputStreamImpl screenShareOutputStream = (RCScreenShareOutputStreamImpl)((RTCEngineImpl)RCRTCEngine.getInstance()).getScreenShareVideoStream();
            if (mediaProjection == null) {
                screenShareOutputStream.setScreenCaptureResult(false, null);
            } else {
                screenShareOutputStream.setScreenCaptureResult(true, mediaProjection);
            }
        }
        ReportUtil.libStatus(ReportUtil.TAG.STOP_SCREEN_CAPTURE_ACTIVITY, "", "");
        this.finish();
    }
}

