/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.opengl.GLES20;
import cn.rongcloud.rtc.core.GlUtil;
import cn.rongcloud.rtc.core.ShaderUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class OesToRgbFilter {
    private static final String VERTEX_SHADER = "attribute vec4 vPosition;\nattribute vec4 vTexCoordinate;\nuniform mat4 textureTransform;\nvarying vec2 v_TexCoordinate;\n\nvoid main () {\n    v_TexCoordinate = (textureTransform * vTexCoordinate).xy;\n    gl_Position = vPosition;\n}";
    private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES texture;\nvarying vec2 v_TexCoordinate;\n\nvoid main () {\n    vec4 color = texture2D(texture, v_TexCoordinate);\n    gl_FragColor = color;\n}";
    private static float squareSize = 1.0f;
    private static float[] squareCoords = new float[]{-squareSize, squareSize, -squareSize, -squareSize, squareSize, -squareSize, squareSize, squareSize};
    private float[] textureCoords = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private static short[] drawOrder = new short[]{0, 1, 2, 0, 2, 3};
    private int mProgram = 0;
    private FloatBuffer vertexBuffer;
    private FloatBuffer textureBuffer;
    private ShortBuffer drawListBuffer;
    private int positionLoc;
    private int textureCoordinateLoc;
    private int textureTransformHandle;
    private int textureHandle;
    private int mFrameBufferTextureId = 0;
    private int mFramebuffer = 0;
    private int mWidth = 0;
    private int mHeight = 0;

    public OesToRgbFilter() {
        this.setupBuffer();
    }

    private void setupBuffer() {
        ByteBuffer dlb = ByteBuffer.allocateDirect(drawOrder.length * 2);
        dlb.order(ByteOrder.nativeOrder());
        this.drawListBuffer = dlb.asShortBuffer();
        this.drawListBuffer.put(drawOrder);
        this.drawListBuffer.position(0);
        ByteBuffer bb = ByteBuffer.allocateDirect(squareCoords.length * 4);
        bb.order(ByteOrder.nativeOrder());
        this.vertexBuffer = bb.asFloatBuffer();
        this.vertexBuffer.put(squareCoords);
        this.vertexBuffer.position(0);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.textureCoords.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.textureBuffer = byteBuffer.asFloatBuffer();
        this.textureBuffer.put(this.textureCoords);
        this.textureBuffer.position(0);
    }

    public void init() {
        int vertexShaderHandle = ShaderUtils.compileShader(35633, VERTEX_SHADER);
        int fragmentShaderHandle = ShaderUtils.compileShader(35632, FRAGMENT_SHADER);
        this.mProgram = ShaderUtils.createAndLinkProgram(vertexShaderHandle, fragmentShaderHandle);
        GLES20.glUseProgram((int)this.mProgram);
        this.positionLoc = GLES20.glGetAttribLocation((int)this.mProgram, (String)"vPosition");
        this.textureCoordinateLoc = GLES20.glGetAttribLocation((int)this.mProgram, (String)"vTexCoordinate");
        this.textureTransformHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"textureTransform");
        this.textureHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"texture");
    }

    public void onSizeChanged(int width, int height) {
        if (width != this.mWidth || height != this.mHeight) {
            this.destroyFrameBuffer();
            this.mWidth = width;
            this.mHeight = height;
            this.prepareFramebuffer(width, height);
        }
    }

    private void prepareFramebuffer(int width, int height) {
        GlUtil.checkNoGLES2Error("prepareFramebuffer start");
        int[] values = new int[1];
        GLES20.glGenTextures((int)1, (int[])values, (int)0);
        GlUtil.checkNoGLES2Error("glGenTextures");
        this.mFrameBufferTextureId = values[0];
        GLES20.glBindTexture((int)3553, (int)this.mFrameBufferTextureId);
        GlUtil.checkNoGLES2Error("glBindTexture " + this.mFrameBufferTextureId);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlUtil.checkNoGLES2Error("glTexParameter");
        GLES20.glGenFramebuffers((int)1, (int[])values, (int)0);
        GlUtil.checkNoGLES2Error("glGenFramebuffers");
        this.mFramebuffer = values[0];
        GLES20.glBindFramebuffer((int)36160, (int)this.mFramebuffer);
        GlUtil.checkNoGLES2Error("glBindFramebuffer " + this.mFramebuffer);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mFrameBufferTextureId, (int)0);
        GlUtil.checkNoGLES2Error("glFramebufferTexture2D");
        int status = GLES20.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            throw new RuntimeException("Framebuffer not complete, status=" + status);
        }
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GlUtil.checkNoGLES2Error("prepareFramebuffer done");
    }

    private void destroyFrameBuffer() {
        int[] value;
        if (this.mFrameBufferTextureId != 0) {
            value = new int[]{this.mFrameBufferTextureId};
            GLES20.glDeleteTextures((int)1, (int[])value, (int)0);
            this.mFrameBufferTextureId = 0;
        }
        if (this.mFramebuffer != 0) {
            value = new int[]{this.mFramebuffer};
            GLES20.glDeleteFramebuffers((int)1, (int[])value, (int)0);
            this.mFramebuffer = 0;
        }
        this.mWidth = 0;
        this.mHeight = 0;
    }

    public int drawTexture(int textureId, float[] textureMatrix) {
        GLES20.glBindFramebuffer((int)36160, (int)this.mFramebuffer);
        GLES20.glViewport((int)0, (int)0, (int)this.mWidth, (int)this.mHeight);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16384);
        GLES20.glUseProgram((int)this.mProgram);
        GLES20.glEnableVertexAttribArray((int)this.positionLoc);
        GLES20.glVertexAttribPointer((int)this.positionLoc, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.vertexBuffer);
        GLES20.glActiveTexture((int)33984);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        GLES20.glBindTexture((int)36197, (int)textureId);
        GLES20.glEnableVertexAttribArray((int)this.textureCoordinateLoc);
        GLES20.glVertexAttribPointer((int)this.textureCoordinateLoc, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.textureBuffer);
        GLES20.glUniformMatrix4fv((int)this.textureTransformHandle, (int)1, (boolean)false, (float[])textureMatrix, (int)0);
        GLES20.glDrawElements((int)5, (int)drawOrder.length, (int)5123, (Buffer)this.drawListBuffer);
        GLES20.glDisableVertexAttribArray((int)this.positionLoc);
        GLES20.glDisableVertexAttribArray((int)this.textureCoordinateLoc);
        GLES20.glUseProgram((int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        return this.mFrameBufferTextureId;
    }

    public void destroy() {
        this.destroyFrameBuffer();
        if (this.mProgram != 0) {
            GLES20.glDeleteProgram((int)this.mProgram);
        }
        this.mProgram = 0;
    }
}

