/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.graphics.Matrix;
import android.os.Handler;
import cn.rongcloud.rtc.core.RefCountDelegate;
import cn.rongcloud.rtc.core.RendererCommon;
import cn.rongcloud.rtc.core.ThreadUtils;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.core.YuvConverter;
import java.util.concurrent.Callable;

public class TextureBufferImpl
implements VideoFrame.TextureBuffer {
    private final int unscaledWidth;
    private final int unscaledHeight;
    private final int width;
    private final int height;
    private VideoFrame.TextureBuffer.Type type;
    private int id;
    private Matrix transformMatrix;
    private final float[] originalMatrix = new float[16];
    private final Handler toI420Handler;
    private final YuvConverter yuvConverter;
    private final RefCountDelegate refCountDelegate;

    public TextureBufferImpl(int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix, Handler toI420Handler, YuvConverter yuvConverter, Runnable releaseCallback) {
        this.unscaledWidth = width;
        this.unscaledHeight = height;
        this.width = width;
        this.height = height;
        this.type = type;
        this.id = id;
        this.transformMatrix = transformMatrix;
        this.toI420Handler = toI420Handler;
        this.yuvConverter = yuvConverter;
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
    }

    public TextureBufferImpl(int width, int height, VideoFrame.TextureBuffer.Type type, int id, float[] transformMatrix, Handler toI420Handler, YuvConverter yuvConverter, Runnable releaseCallback) {
        this.unscaledWidth = width;
        this.unscaledHeight = height;
        this.width = width;
        this.height = height;
        this.type = type;
        this.id = id;
        System.arraycopy(transformMatrix, 0, this.originalMatrix, 0, transformMatrix.length);
        this.transformMatrix = RendererCommon.convertMatrixToAndroidGraphicsMatrix(transformMatrix);
        this.toI420Handler = toI420Handler;
        this.yuvConverter = yuvConverter;
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
    }

    private TextureBufferImpl(int unscaledWidth, int unscaledHeight, int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix, Handler toI420Handler, YuvConverter yuvConverter, Runnable releaseCallback) {
        this.unscaledWidth = unscaledWidth;
        this.unscaledHeight = unscaledHeight;
        this.width = width;
        this.height = height;
        this.type = type;
        this.id = id;
        float[] tempMatrix = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(transformMatrix);
        System.arraycopy(tempMatrix, 0, this.originalMatrix, 0, tempMatrix.length);
        this.transformMatrix = transformMatrix;
        this.toI420Handler = toI420Handler;
        this.yuvConverter = yuvConverter;
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        return this.type;
    }

    public void setType(VideoFrame.TextureBuffer.Type type) {
        this.type = type;
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    public void setTextureId(int textureId) {
        this.id = textureId;
    }

    @Override
    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    public void setTransformMatrix(Matrix matrix) {
        this.transformMatrix = matrix;
    }

    @Override
    public float[] getOriginalMatrix() {
        return this.originalMatrix;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, new Callable<VideoFrame.I420Buffer>(){

            @Override
            public VideoFrame.I420Buffer call() throws Exception {
                return TextureBufferImpl.this.yuvConverter.convert(TextureBufferImpl.this);
            }
        });
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        Matrix cropAndScaleMatrix = new Matrix();
        int cropYFromBottom = this.height - (cropY + cropHeight);
        cropAndScaleMatrix.preTranslate((float)cropX / (float)this.width, (float)cropYFromBottom / (float)this.height);
        cropAndScaleMatrix.preScale((float)cropWidth / (float)this.width, (float)cropHeight / (float)this.height);
        return this.applyTransformMatrix(cropAndScaleMatrix, Math.round((float)(this.unscaledWidth * cropWidth) / (float)this.width), Math.round((float)(this.unscaledHeight * cropHeight) / (float)this.height), scaleWidth, scaleHeight);
    }

    public int getUnscaledWidth() {
        return this.unscaledWidth;
    }

    public int getUnscaledHeight() {
        return this.unscaledHeight;
    }

    public Handler getToI420Handler() {
        return this.toI420Handler;
    }

    public YuvConverter getYuvConverter() {
        return this.yuvConverter;
    }

    public TextureBufferImpl applyTransformMatrix(Matrix transformMatrix, int newWidth, int newHeight) {
        return this.applyTransformMatrix(transformMatrix, newWidth, newHeight, newWidth, newHeight);
    }

    private TextureBufferImpl applyTransformMatrix(Matrix transformMatrix, int unscaledWidth, int unscaledHeight, int scaledWidth, int scaledHeight) {
        Matrix newMatrix = new Matrix(this.transformMatrix);
        newMatrix.preConcat(transformMatrix);
        this.retain();
        return new TextureBufferImpl(unscaledWidth, unscaledHeight, scaledWidth, scaledHeight, this.type, this.id, newMatrix, this.toI420Handler, this.yuvConverter, new Runnable(){

            @Override
            public void run() {
                TextureBufferImpl.this.release();
            }
        });
    }
}

