/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.sniffer;

import cn.rongcloud.rtc.sniffer.HostInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class SnifferInfo {
    private static final String TAG = "SnifferInfo";
    private String serverHost;
    private String protocol;
    private int port;
    private List<String> allHosts;
    private static final String format = "%s://%s";
    private BlockingQueue<HostInfo> orderedHosts = new LinkedBlockingQueue<HostInfo>();
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private String mediaServer;

    public SnifferInfo(String mediaServer) {
        this.mediaServer = mediaServer;
        if (mediaServer.startsWith(HTTPS)) {
            this.protocol = HTTPS;
            this.port = 443;
            this.serverHost = mediaServer.substring(8);
        } else if (mediaServer.startsWith(HTTP)) {
            this.protocol = HTTP;
            this.port = 80;
            this.serverHost = mediaServer.substring(7);
        }
    }

    public int getPort() {
        return this.port;
    }

    public List<String> getAllHosts() {
        return this.allHosts;
    }

    public void setAllHosts(List<String> allHosts) {
        this.allHosts = allHosts;
    }

    public List<String> getOrderedHosts() {
        ArrayList<String> hosts = new ArrayList<String>();
        for (HostInfo info : this.orderedHosts) {
            hosts.add(info.getHost());
        }
        return hosts;
    }

    public BlockingQueue<HostInfo> getOrderedHostInfos() {
        return this.orderedHosts;
    }

    public void addOrderedHost(String host, long timeCost) {
        this.orderedHosts.offer(new HostInfo(String.format(format, this.protocol, host), timeCost));
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public String getMediaServer() {
        return this.mediaServer;
    }

    public String toString() {
        return "SnifferInfo{serverHost='" + this.serverHost + '\'' + ", protocol='" + this.protocol + '\'' + '}';
    }
}

