/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.proxy.message;

import android.os.Parcel;
import android.os.Parcelable;
import cn.rongcloud.rtc.proxy.message.messagebeans.CDNResourceInfo;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RCRTC:TotalContentResources", flag=16)
public class TotalContentResources
extends MessageContent {
    private static final String TAG = "TotalContentResources";
    private List<MediaResourceInfo> uris = new ArrayList<MediaResourceInfo>();
    private List<MediaResourceInfo> mcu_uris = new ArrayList<MediaResourceInfo>();
    private List<CDNResourceInfo> cdn_uris = new ArrayList<CDNResourceInfo>();
    private String extra;
    public static final Parcelable.Creator<TotalContentResources> CREATOR = new Parcelable.Creator<TotalContentResources>(){

        public TotalContentResources createFromParcel(Parcel source) {
            return new TotalContentResources(source);
        }

        public TotalContentResources[] newArray(int size) {
            return new TotalContentResources[size];
        }
    };

    public TotalContentResources(List<MediaResourceInfo> mediaResourceInfoList) {
        this.uris = mediaResourceInfoList;
    }

    private TotalContentResources(Parcel source) {
        this.extra = source.readString();
        source.readList(this.uris, ((Object)((Object)this)).getClass().getClassLoader());
        source.readList(this.mcu_uris, ((Object)((Object)this)).getClass().getClassLoader());
        source.readList(this.cdn_uris, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public TotalContentResources(byte[] data) {
        super(data);
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
            ReportUtil.report("L-", ReportUtil.TAG.REMOTEUSERTOTALCONTENTTAG, "-S", "TotalContent", jsonStr);
        }
        catch (UnsupportedEncodingException e) {
            RLog.e((String)TAG, (String)"UnsupportedEncodingException ", (Throwable)e);
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("uris")) {
                int i;
                if (jsonObj.has("extra")) {
                    this.extra = jsonObj.getString("extra");
                }
                JSONArray array = null;
                if (jsonObj.has("uris")) {
                    array = jsonObj.getJSONArray("uris");
                }
                this.uris = new ArrayList<MediaResourceInfo>();
                if (array != null) {
                    FinLog.d(TAG, "TotalContentResources size() =  " + array.length());
                    for (i = 0; i < array.length(); ++i) {
                        this.uris.add(new MediaResourceInfo((JSONObject)array.get(i), ""));
                    }
                }
                array = null;
                if (jsonObj.has("mcu_uris")) {
                    array = new JSONArray(jsonObj.getString("mcu_uris"));
                }
                this.mcu_uris = new ArrayList<MediaResourceInfo>();
                if (array != null) {
                    for (i = 0; i < array.length(); ++i) {
                        this.mcu_uris.add(new MediaResourceInfo((JSONObject)array.get(i), ""));
                    }
                }
                JSONArray jsonArray_cdn_uris = new JSONArray();
                if (jsonObj.has("cdn_uris")) {
                    jsonArray_cdn_uris = new JSONArray(jsonObj.optString("cdn_uris"));
                }
                this.cdn_uris = new ArrayList<CDNResourceInfo>();
                if (jsonArray_cdn_uris != null) {
                    for (int i2 = 0; i2 < jsonArray_cdn_uris.length(); ++i2) {
                        this.cdn_uris.add(new CDNResourceInfo((JSONObject)jsonArray_cdn_uris.get(i2)));
                    }
                }
            }
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException " + e.getMessage()));
        }
    }

    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            JSONArray jsonArray = new JSONArray();
            for (MediaResourceInfo mediaResourceInfo : this.uris) {
                jsonArray.put((Object)mediaResourceInfo.getJsonObject());
            }
            JSONArray mcuArray = new JSONArray();
            for (MediaResourceInfo info : this.mcu_uris) {
                mcuArray.put((Object)info.getJsonObject());
            }
            jsonObj.putOpt("extra", (Object)this.extra);
            jsonObj.putOpt("uris", (Object)jsonArray);
            jsonObj.putOpt("mcu_uris", (Object)mcuArray);
            JSONArray jSONArray = new JSONArray();
            for (CDNResourceInfo info : this.cdn_uris) {
                jSONArray.put((Object)info.getJsonObject());
            }
            jsonObj.putOpt("cdn_uris", (Object)jSONArray);
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.extra);
        dest.writeList(this.uris);
        dest.writeList(this.mcu_uris);
        dest.writeList(this.cdn_uris);
    }

    public List<MediaResourceInfo> getMediaResourceInfo() {
        return this.uris;
    }

    public List<MediaResourceInfo> getMCUMediaResourceInfo() {
        return this.mcu_uris;
    }

    public List<CDNResourceInfo> getCDN_Uris() {
        return this.cdn_uris;
    }
}

