/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.dom.CSSShorthand;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.feature.uniapp.ui.component.AbsVContainer;

public abstract class WXVContainer<T extends ViewGroup>
extends AbsVContainer<T> {
    private static final String TAG = "WXVContainer";
    private BoxShadowHost mBoxShadowHost;

    public WXVContainer(WXSDKInstance instance, WXVContainer parent, String instanceId, boolean isLazy, BasicComponentData basicComponentData) {
        super(instance, parent, instanceId, isLazy, basicComponentData);
    }

    public WXVContainer(WXSDKInstance instance, WXVContainer parent, boolean lazy, BasicComponentData basicComponentData) {
        super(instance, parent, lazy, basicComponentData);
    }

    public WXVContainer(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) {
        super(instance, parent, basicComponentData);
    }

    @Override
    protected int getChildrenLayoutTopOffset() {
        return 0;
    }

    @Override
    @Nullable
    public View getBoxShadowHost(boolean isClear) {
        if (isClear) {
            return this.mBoxShadowHost;
        }
        ViewGroup hostView = (ViewGroup)this.getHostView();
        if (hostView == null) {
            return null;
        }
        try {
            String type = this.getComponentType();
            if ("div".equals(type) || "view".equals(type)) {
                WXLogUtils.d("BoxShadow", "Draw box-shadow with BoxShadowHost on div: " + this.toString());
                if (this.mBoxShadowHost == null) {
                    this.mBoxShadowHost = new BoxShadowHost(this.getContext());
                    WXViewUtils.setBackGround(this.mBoxShadowHost, null, this);
                    hostView.addView((View)this.mBoxShadowHost);
                }
                CSSShorthand padding = this.getPadding();
                CSSShorthand border = this.getBorder();
                int left = (int)(padding.get(CSSShorthand.EDGE.LEFT) + border.get(CSSShorthand.EDGE.LEFT));
                int top = (int)(padding.get(CSSShorthand.EDGE.TOP) + border.get(CSSShorthand.EDGE.TOP));
                int right = (int)(padding.get(CSSShorthand.EDGE.RIGHT) + border.get(CSSShorthand.EDGE.RIGHT));
                int bottom = (int)(padding.get(CSSShorthand.EDGE.BOTTOM) + border.get(CSSShorthand.EDGE.BOTTOM));
                ViewGroup.MarginLayoutParams layoutParams = new ViewGroup.MarginLayoutParams(hostView.getLayoutParams());
                this.setMarginsSupportRTL(layoutParams, -left, -top, -right, -bottom);
                this.mBoxShadowHost.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                hostView.removeView((View)this.mBoxShadowHost);
                hostView.addView((View)this.mBoxShadowHost);
                return this.mBoxShadowHost;
            }
        }
        catch (Throwable t) {
            WXLogUtils.w("BoxShadow", t);
        }
        return hostView;
    }

    @Override
    public void removeBoxShadowHost() {
        ViewGroup hostView = (ViewGroup)this.getHostView();
        if (hostView == null) {
            return;
        }
        try {
            String type = this.getComponentType();
            if (this.mBoxShadowHost != null && ("div".equals(type) || "view".equals(type))) {
                hostView.removeView((View)this.mBoxShadowHost);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class BoxShadowHost
    extends View {
        public BoxShadowHost(Context context) {
            super(context);
        }
    }
}

