/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.text.TextUtils;
import cn.rongcloud.rtc.base.RCRTCRect;
import cn.rongcloud.rtc.core.JavaI420Buffer;
import cn.rongcloud.rtc.core.MediaSource;
import cn.rongcloud.rtc.core.NativeAndroidVideoTrackSource;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.core.VideoProcessor;
import cn.rongcloud.rtc.core.VideoSink;
import cn.rongcloud.rtc.core.VideoSourceObserver;
import cn.rongcloud.rtc.jni.video.RCWaterMarkFilter;
import cn.rongcloud.rtc.utils.ReportUtil;
import io.rong.common.RLog;

public class VideoSource
extends MediaSource {
    private String TAG = "VideoSource";
    private RCWaterMarkFilter waterMarkFilter;
    private final NativeAndroidVideoTrackSource nativeAndroidVideoTrackSource;
    private final Object videoProcessorLock = new Object();
    private VideoProcessor videoProcessor;
    private boolean isCapturerRunning = true;
    private final VideoSourceObserver capturerObserver = new VideoSourceObserver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCapturerStarted(boolean success) {
            if (VideoSource.this.nativeSource != 0L) {
                VideoSource.this.nativeAndroidVideoTrackSource.setState(success);
            }
            Object object = VideoSource.this.videoProcessorLock;
            synchronized (object) {
                VideoSource.this.isCapturerRunning = success;
                if (VideoSource.this.videoProcessor != null) {
                    VideoSource.this.videoProcessor.onCapturerStarted(success);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCapturerStopped() {
            if (VideoSource.this.nativeSource != 0L) {
                VideoSource.this.nativeAndroidVideoTrackSource.setState(false);
            }
            Object object = VideoSource.this.videoProcessorLock;
            synchronized (object) {
                VideoSource.this.isCapturerRunning = false;
                if (VideoSource.this.videoProcessor != null) {
                    VideoSource.this.videoProcessor.onCapturerStopped();
                }
            }
        }

        @Override
        public void onFrameCaptured(VideoFrame frame) {
            this.onFrameCaptured(frame, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrameCaptured(VideoFrame frame, VideoSourceObserver.VideoFrameCallBack callBack) {
            boolean ret;
            if (VideoSource.this.nativeSource == 0L || !VideoSource.this.isCapturerRunning) {
                return;
            }
            NativeAndroidVideoTrackSource.FrameAdaptationParameters parameters = VideoSource.this.nativeAndroidVideoTrackSource.adaptFrame(frame);
            if (parameters == null) {
                return;
            }
            VideoFrame.Buffer scaleBuffer = frame.getBuffer().cropAndScale(parameters.cropX, parameters.cropY, parameters.cropWidth, parameters.cropHeight, parameters.scaleWidth, parameters.scaleHeight);
            VideoFrame.I420Buffer i420Buffer = scaleBuffer.toI420();
            scaleBuffer.release();
            VideoFrame.I420Buffer adaptedBuffer = ((JavaI420Buffer)i420Buffer).rotate(parameters.scaleWidth, parameters.scaleHeight, frame.getRotation());
            i420Buffer.release();
            if (VideoSource.this.waterMarkFilter != null && !(ret = VideoSource.this.waterMarkFilter.reInitWatermarkEnv(parameters.scaleHeight, parameters.scaleWidth, frame.getRotation())) && VideoSource.this.waterMarkFilter != null) {
                VideoSource.this.waterMarkFilter.destroyWatermarkEnv();
                VideoSource.this.waterMarkFilter = null;
            }
            if (VideoSource.this.waterMarkFilter != null && VideoSource.this.waterMarkFilter.isInitWatermarkEnv()) {
                VideoSource.this.waterMarkFilter.drawWatermark(((JavaI420Buffer)adaptedBuffer).getDataY(), ((JavaI420Buffer)adaptedBuffer).getDataU(), ((JavaI420Buffer)adaptedBuffer).getDataV(), parameters.scaleHeight, parameters.scaleWidth, frame.getRotation());
            }
            VideoFrame adaptedFrame = new VideoFrame(adaptedBuffer, 0, parameters.timestampNs);
            if (frame.getMirror()) {
                adaptedFrame.setMirror(true);
            }
            if (callBack != null) {
                callBack.onFrame(adaptedFrame);
            }
            Object object = VideoSource.this.videoProcessorLock;
            synchronized (object) {
                if (VideoSource.this.videoProcessor != null && VideoSource.this.isCapturerRunning) {
                    VideoSource.this.videoProcessor.onFrameCaptured(adaptedFrame);
                    adaptedBuffer.release();
                    return;
                }
                if (VideoSource.this.nativeSource != 0L && VideoSource.this.isCapturerRunning) {
                    VideoSource.this.nativeAndroidVideoTrackSource.onFrameCaptured(adaptedFrame);
                }
            }
            frame.updateAdaptedSize(adaptedBuffer.getWidth(), adaptedBuffer.getHeight());
            adaptedBuffer.release();
        }
    };

    public void initWatermarkEnv(String waterPath, RCRTCRect rect, int waterWidth, int waterHeight) {
        if (this.waterMarkFilter != null) {
            this.waterMarkFilter.destroyWatermarkEnv();
            this.waterMarkFilter = null;
        }
        if (!TextUtils.isEmpty((CharSequence)waterPath)) {
            this.waterMarkFilter = new RCWaterMarkFilter();
            if (!this.waterMarkFilter.isInitWatermarkEnv()) {
                this.waterMarkFilter.setWatermarkParams(waterPath, rect, waterWidth, waterHeight);
            }
        } else {
            RLog.d((String)this.TAG, (String)"- initWatermarkEnv(): waterPath == null !");
        }
        boolean existed = !TextUtils.isEmpty((CharSequence)waterPath);
        ReportUtil.libStatus(ReportUtil.TAG.INITWATERMARKENV, "status|haswm", "- initWatermarkEnv", existed);
    }

    public void destroyWatermarkEnv() {
        if (this.waterMarkFilter != null) {
            RLog.d((String)this.TAG, (String)"- destroyWatermarkEnv()");
            this.waterMarkFilter.destroyWatermarkEnv();
            this.waterMarkFilter = null;
        }
    }

    public VideoSource(long nativeSource) {
        super(nativeSource);
        this.nativeAndroidVideoTrackSource = new NativeAndroidVideoTrackSource(nativeSource);
    }

    public void adaptOutputFormat(int width, int height, int fps) {
        int maxSide = Math.max(width, height);
        int minSide = Math.min(width, height);
        this.adaptOutputFormat(maxSide, minSide, minSide, maxSide, fps);
    }

    public void adaptExactOutputFormat(int width, int height, int fps) {
        int maxSide = Math.max(width, height);
        int minSide = Math.min(width, height);
        this.adaptExactOutputFormat(maxSide, minSide, minSide, maxSide, fps);
    }

    public void adaptOutputFormat(int landscapeWidth, int landscapeHeight, int portraitWidth, int portraitHeight, int fps) {
        this.adaptOutputFormat(new AspectRatio(landscapeWidth, landscapeHeight), (Integer)(landscapeWidth * landscapeHeight), new AspectRatio(portraitWidth, portraitHeight), (Integer)(portraitWidth * portraitHeight), (Integer)fps);
    }

    public void adaptOutputFormat(AspectRatio targetLandscapeAspectRatio, Integer maxLandscapePixelCount, AspectRatio targetPortraitAspectRatio, Integer maxPortraitPixelCount, Integer maxFps) {
        if (this.nativeSource != 0L) {
            this.nativeAndroidVideoTrackSource.adaptOutputFormat(targetLandscapeAspectRatio, maxLandscapePixelCount, targetPortraitAspectRatio, maxPortraitPixelCount, maxFps);
        }
    }

    public void adaptExactOutputFormat(int landscapeWidth, int landscapeHeight, int portraitWidth, int portraitHeight, int fps) {
        this.adaptExactOutputFormat(new AspectRatio(landscapeWidth, landscapeHeight), (Integer)(landscapeWidth * landscapeHeight), new AspectRatio(portraitWidth, portraitHeight), (Integer)(portraitWidth * portraitHeight), (Integer)fps);
    }

    public void adaptExactOutputFormat(AspectRatio targetLandscapeAspectRatio, Integer maxLandscapePixelCount, AspectRatio targetPortraitAspectRatio, Integer maxPortraitPixelCount, Integer maxFps) {
        if (this.nativeSource != 0L) {
            this.nativeAndroidVideoTrackSource.adaptExactOutputFormat(targetLandscapeAspectRatio, maxLandscapePixelCount, targetPortraitAspectRatio, maxPortraitPixelCount, maxFps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVideoProcessor(VideoProcessor newVideoProcessor) {
        Object object = this.videoProcessorLock;
        synchronized (object) {
            if (this.videoProcessor != null) {
                this.videoProcessor.setSink(null);
                if (this.isCapturerRunning) {
                    this.videoProcessor.onCapturerStopped();
                }
            }
            this.videoProcessor = newVideoProcessor;
            if (newVideoProcessor != null) {
                newVideoProcessor.setSink(new VideoSink(){

                    @Override
                    public void onFrame(VideoFrame frame) {
                        if (VideoSource.this.nativeSource != 0L) {
                            VideoSource.this.nativeAndroidVideoTrackSource.onFrameCaptured(frame);
                        }
                    }
                });
                if (this.isCapturerRunning) {
                    newVideoProcessor.onCapturerStarted(true);
                }
            }
        }
    }

    public VideoSourceObserver getCapturerObserver() {
        return this.capturerObserver;
    }

    long getNativeVideoTrackSource() {
        return this.getNativeMediaSource();
    }

    @Override
    public void dispose() {
        this.setVideoProcessor(null);
        super.dispose();
    }

    public static class AspectRatio {
        public static final AspectRatio UNDEFINED = new AspectRatio(0, 0);
        public final int width;
        public final int height;

        public AspectRatio(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

