/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.custom;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.io.File;
import java.io.FileDescriptor;

public abstract class MediaDecoder {
    private static final String TAG = "MediaDecoder";
    private static final String ASSET_DESCRIPTOR = "file:///android_asset/";
    private static final String ASSET_FLUTTER = "flutter_assets/";
    private static final String FILE_URI = "file://";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean init(String path, Context context) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            ReportUtil.libError(ReportUtil.TAG.STARTMIX, "exception", "path is null");
            return false;
        }
        AssetFileDescriptor afd = null;
        ParcelFileDescriptor pfd = null;
        try {
            if (path.startsWith(ASSET_DESCRIPTOR)) {
                String assetFilePath = path.substring(ASSET_DESCRIPTOR.length());
                afd = context.getAssets().openFd(assetFilePath);
                boolean bl = this.init(afd.getFileDescriptor(), afd.getStartOffset(), afd.getDeclaredLength());
                return bl;
            }
            if (path.startsWith(ASSET_FLUTTER)) {
                afd = context.getAssets().openFd(path);
                boolean assetFilePath = this.init(afd.getFileDescriptor(), afd.getStartOffset(), afd.getDeclaredLength());
                return assetFilePath;
            }
            if (path.startsWith(FILE_URI)) {
                File file = new File(Uri.parse((String)path).getPath());
                pfd = ParcelFileDescriptor.open((File)file, (int)0x10000000);
                boolean bl = this.init(pfd.getFileDescriptor(), 0L, file.length());
                return bl;
            }
            File file = new File(path);
            pfd = ParcelFileDescriptor.open((File)file, (int)0x10000000);
            boolean bl = this.init(pfd.getFileDescriptor(), 0L, file.length());
            return bl;
        }
        catch (Exception e) {
            ReportUtil.libError(ReportUtil.TAG.STARTMIX, "exception", e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (pfd != null) {
                    pfd.close();
                }
                if (afd != null) {
                    afd.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public abstract boolean init(FileDescriptor var1, long var2, long var4);

    public abstract void start();

    public abstract void stop();
}

