/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Rotation;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.egl.EGLCore;
import com.tencent.liteav.videobase.egl.f;
import com.tencent.liteav.videobase.frame.FrameMetaData;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.d;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.frame.j;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.h;
import com.tencent.liteav.videoconsumer.renderer.VideoRenderListener;
import com.tencent.liteav.videoconsumer.renderer.t;
import com.tencent.liteav.videoproducer.encoder.VideoEncodeParams;
import com.tencent.liteav.videoproducer.encoder.VideoEncoderDef;
import com.tencent.liteav.videoproducer.preprocessor.ah;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.TXVideoEditer;
import com.tencent.ugc.UGCAVSyncer;
import com.tencent.ugc.UGCCombineProcessor;
import com.tencent.ugc.UGCMediaListSource;
import com.tencent.ugc.UGCTransitionProcessor;
import com.tencent.ugc.datereport.UGCDataReport;
import com.tencent.ugc.encoder.UGCVideoEncodeController;
import com.tencent.ugc.ga;
import com.tencent.ugc.gb;
import com.tencent.ugc.gc;
import com.tencent.ugc.gd;
import com.tencent.ugc.ge;
import com.tencent.ugc.gf;
import com.tencent.ugc.gg;
import com.tencent.ugc.gh;
import com.tencent.ugc.gi;
import com.tencent.ugc.gj;
import com.tencent.ugc.gk;
import com.tencent.ugc.gl;
import com.tencent.ugc.gm;
import com.tencent.ugc.gn;
import com.tencent.ugc.go;
import com.tencent.ugc.gp;
import com.tencent.ugc.gq;
import com.tencent.ugc.gr;
import com.tencent.ugc.gs;
import com.tencent.ugc.gt;
import com.tencent.ugc.gu;
import com.tencent.ugc.gv;
import com.tencent.ugc.gw;
import com.tencent.ugc.videoprocessor.SpeedProcessor;
import com.tencent.ugc.videoprocessor.VideoEffectProcessor;
import com.tencent.ugc.videoprocessor.VideoProcessManager;
import com.tencent.ugc.videoprocessor.VideoTransitionProcessor;
import com.tencent.ugc.videoprocessor.WatermarkProcessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class UGCVideoProcessor {
    private static final String TAG = "UGCVideoProcessor";
    private final b mThrottlers = new b();
    private boolean mIsInit = false;
    private EGLCore mEGLCore;
    private CustomHandler mVideoProcessHandler;
    private HandlerThread mRenderThread;
    private VideoProcessManager mVideoProcessManager;
    private UGCMediaListSource mUGCMediaListSource;
    private final UGCAVSyncer mUGCAVSyncer;
    private t mRenderer;
    private IVideoReporter mReporter;
    private a mStatus;
    private PixelFrame mLastRenderFrame;
    private SpeedProcessor mSpeedProcessor;
    private UGCTransitionProcessor mUGCTransitionProcessor;
    private UGCCombineProcessor mUGCCombineProcessor;
    private e mGLTexturePool;
    private int mTransitionType = -1;
    private UGCVideoEncodeController mVideoEncodeController;
    private long mFinalPts = -1L;
    private DisplayTarget mDisplayTarget;
    private GLConstants.GLScaleType mScaleType = GLConstants.GLScaleType.b;
    private Rotation mRotation = Rotation.a;
    private VideoEncodeParams mVideoEncodeParams;
    private boolean mIsRecord = false;
    private VideoProcessListener mVideoProcessListener;
    private VideoEncodedFrameListener mVideoEncodedFrameListener;
    private static final int MSG_START = 100;
    private static final int MSG_PROCESS_FROM_SOURCE = 101;
    private static final int MSG_PAUSE = 102;
    private static final int MSG_STOP = 103;
    private static final int MSG_REFRESH = 104;
    private static final int MSG_FORCE_PROCESS = 105;
    private boolean mInvalidate;
    private Object mCurEGLContext = null;
    private int mCurEGLWidth = -1;
    private int mCurEGLHeight = -1;
    private int mOutputWidth = -1;
    private int mOutputHeight = -1;
    private j mPreScaleRenderer;
    private List<TXVideoEditConstants.TXAbsoluteRect> mRectList;
    private AtomicReference<Long> mTargetSeekPts = new AtomicReference();
    private final long MIN_SEEK_DIR = 100L;
    private long mLastProgressedFrame = -1L;
    private boolean mReverse = false;
    private int mSkipFrameCount = 0;
    private final int MAX_SKIP_FRAME_COUNT = 3;
    private final VideoRenderListener mVideoRenderListener = new VideoRenderListener(){

        @Override
        public final void onRenderTargetSizeChanged(int width, int height) {
            LiteavLog.i(UGCVideoProcessor.TAG, "onRenderSizeChange " + width + "," + height);
            UGCVideoProcessor.this.runOnVideoProcessHandler(gt.a(this, width, height));
        }

        static /* synthetic */ void a(1 var0, int n2, int n3) {
            if (var0.UGCVideoProcessor.this.mVideoProcessManager != null) {
                var0.UGCVideoProcessor.this.mVideoProcessManager.setOutputSize(n2, n3);
            }
        }
    };
    private ah mVideoPreprocessorListener = new ah(){

        @Override
        public final void a(int n2, PixelFrame pixelFrame) {
            if (UGCVideoProcessor.this.filtInvalidatedFrame(pixelFrame.getTimestamp())) {
                return;
            }
            pixelFrame.retain();
            if (pixelFrame.getPixelBufferType() == GLConstants.PixelBufferType.b || pixelFrame.getPixelBufferType() == GLConstants.PixelBufferType.c) {
                GLES20.glFinish();
            }
            if (!UGCVideoProcessor.this.runOnVideoProcessHandler(gu.a(this, pixelFrame))) {
                pixelFrame.release();
            }
        }
    };
    private VideoEncoderDef.VideoEncoderDataListener mVideoEncoderDataListener = new VideoEncoderDef.VideoEncoderDataListener(){

        @Override
        public final void onOutputFormatChanged(MediaFormat format) {
            LiteavLog.i(UGCVideoProcessor.TAG, "onOutputFormatChanged: ".concat(String.valueOf(format)));
        }

        @Override
        public final void onEncodedNAL(EncodedVideoFrame nal, boolean isEos) {
            UGCVideoProcessor.this.runOnVideoProcessHandler(gv.a(this, nal, isEos));
        }

        @Override
        public final void onEncodedFail(h.a code) {
            LiteavLog.e(UGCVideoProcessor.TAG, "onEncodedFail: ");
            TXVideoEditConstants.TXGenerateResult tXGenerateResult = new TXVideoEditConstants.TXGenerateResult();
            new TXVideoEditConstants.TXGenerateResult().retCode = code.ordinal();
            tXGenerateResult.descMsg = code.name();
            if (UGCVideoProcessor.this.mVideoProcessListener != null) {
                UGCVideoProcessor.this.mVideoProcessListener.onComplete(tXGenerateResult);
            }
        }

        static /* synthetic */ void a(3 var0, EncodedVideoFrame encodedVideoFrame, boolean bl2) {
            if (var0.UGCVideoProcessor.this.mVideoEncodedFrameListener == null) {
                return;
            }
            if (encodedVideoFrame != null) {
                var0.UGCVideoProcessor.this.mVideoEncodedFrameListener.onVideoFrameEncoded(encodedVideoFrame);
                if (encodedVideoFrame.pts == var0.UGCVideoProcessor.this.mFinalPts || bl2) {
                    var0.UGCVideoProcessor.this.mVideoEncodedFrameListener.onVideoEncodingCompleted();
                    var0.UGCVideoProcessor.this.stopEncoder();
                    return;
                }
            } else {
                var0.UGCVideoProcessor.this.mVideoEncodedFrameListener.onVideoEncodingCompleted();
                var0.UGCVideoProcessor.this.stopEncoder();
            }
        }
    };
    private TXVideoEditer.TXVideoCustomProcessListener mTXVideoCustomProcessListener;
    private VideoProcessManager.IVideoProcessorListener mEffectProcessorListener = new VideoProcessManager.IVideoProcessorListener(){

        @Override
        public final void didProcessFrame(PixelFrame frame) {
            if (UGCVideoProcessor.this.filtInvalidatedFrame(frame.getTimestamp())) {
                return;
            }
            frame.retain();
            if (frame.getPixelBufferType() == GLConstants.PixelBufferType.b || frame.getPixelBufferType() == GLConstants.PixelBufferType.c) {
                GLES20.glFinish();
            }
            if (!UGCVideoProcessor.this.runOnVideoProcessHandler(gw.a(this, frame))) {
                frame.release();
            }
        }

        @Override
        public final int customProcessFrame(PixelFrame frame) {
            if (UGCVideoProcessor.this.mTXVideoCustomProcessListener == null || frame == null) {
                return -1;
            }
            if (frame.getPixelBufferType() == GLConstants.PixelBufferType.b || frame.getPixelBufferType() == GLConstants.PixelBufferType.c) {
                GLES20.glFinish();
            }
            return UGCVideoProcessor.this.mTXVideoCustomProcessListener.onTextureCustomProcess(frame.getTextureId(), frame.getWidth(), frame.getHeight(), frame.getTimestamp());
        }

        static /* synthetic */ void a(4 var0, PixelFrame pixelFrame) {
            var0.UGCVideoProcessor.this.handleProcessFrame(pixelFrame);
            pixelFrame.release();
        }
    };
    private Runnable onCompleteBroadcastRunnable = ga.a(this);

    public UGCVideoProcessor(Context context, UGCMediaListSource source, UGCAVSyncer syncer, IVideoReporter reporter, boolean isEnterpriseProEnabled) {
        this.mUGCMediaListSource = source;
        this.mUGCAVSyncer = syncer;
        this.mReporter = reporter;
        this.mVideoProcessManager = new VideoProcessManager(context, isEnterpriseProEnabled, reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        if (this.mIsInit) {
            return;
        }
        this.mIsInit = true;
        LiteavLog.i(TAG, "initialize: ");
        HandlerThread handlerThread = new HandlerThread("VideoProcess_" + this.hashCode());
        handlerThread.start();
        UGCVideoProcessor uGCVideoProcessor = this;
        synchronized (uGCVideoProcessor) {
            this.mVideoProcessHandler = new CustomHandler(handlerThread.getLooper(), gl.a(this));
        }
        UGCVideoProcessor uGCVideoProcessor2 = this;
        uGCVideoProcessor2.runOnVideoProcessHandler(gm.a(uGCVideoProcessor2));
    }

    private void stopEncoder() {
        if (this.mVideoEncodeController == null) {
            return;
        }
        this.mFinalPts = -1L;
        this.mVideoEncodeController.signalEndOfStream();
        this.mVideoEncodeController.stop();
        this.mVideoEncodeController = null;
    }

    @SuppressLint(value={"NewApi"})
    public void unInitialize() {
        if (!this.mIsInit) {
            return;
        }
        this.mIsInit = false;
        LiteavLog.i(TAG, "uninitialize");
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gn.a(uGCVideoProcessor));
    }

    public void start(boolean isRecord) {
        LiteavLog.i(TAG, "start: ".concat(String.valueOf(isRecord)));
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(go.a(uGCVideoProcessor, isRecord));
        this.sendMsgToVideoProcessHandler(100);
        this.sendMsgToVideoProcessHandler(101);
    }

    private void initEncoder() {
        if (this.mVideoEncodeController != null || this.mVideoEncodeParams == null) {
            return;
        }
        this.mVideoEncodeController = new UGCVideoEncodeController();
        this.mVideoEncodeController.start(this.mVideoEncodeParams, this.mVideoEncoderDataListener);
        if (this.mVideoEncodedFrameListener != null) {
            this.mVideoEncodedFrameListener.onVideoEncodeStarted();
        }
        this.mFinalPts = -1L;
    }

    private void initRenderer() {
        if (this.mRenderer != null) {
            return;
        }
        if (this.mRenderThread == null) {
            this.mRenderThread = new HandlerThread("VideoProcessRender" + this.hashCode());
            this.mRenderThread.start();
        }
        this.mRenderer = new t(this.mRenderThread.getLooper(), this.mReporter);
        if (this.mDisplayTarget != null) {
            this.mRenderer.a(this.mDisplayTarget, true);
            this.mRenderer.a(this.mScaleType);
        }
        this.mRenderer.a(this.mVideoRenderListener);
    }

    public void stop() {
        LiteavLog.i(TAG, "stop: ");
        this.removeMsgFromVideoProcessHandler(101);
        this.sendMsgToVideoProcessHandler(103);
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gp.a(uGCVideoProcessor));
    }

    public void seekTo(long time) {
        this.mTargetSeekPts.set(time);
        this.removeMsgFromVideoProcessHandler(105);
        this.sendMsgToVideoProcessHandler(105);
    }

    private void onCompleteBroadcast() {
        if (this.mVideoProcessListener != null) {
            TXVideoEditConstants.TXGenerateResult tXGenerateResult = new TXVideoEditConstants.TXGenerateResult();
            new TXVideoEditConstants.TXGenerateResult().retCode = 0;
            tXGenerateResult.descMsg = "";
            this.mVideoProcessListener.onComplete(tXGenerateResult);
        }
    }

    private boolean handleMessage(@NonNull Message msg) {
        LiteavLog.d(TAG, "handleMessage: " + msg.what);
        switch (msg.what) {
            case 100: {
                this.mStatus = a.b;
                if (this.mIsRecord) {
                    this.initEncoder();
                    break;
                }
                this.initRenderer();
                break;
            }
            case 102: {
                this.mStatus = a.c;
                break;
            }
            case 103: {
                this.mStatus = a.a;
                break;
            }
            case 104: {
                if (this.mStatus == a.b || this.mLastRenderFrame == null || this.mVideoProcessManager == null) break;
                this.mVideoProcessManager.processFrame(this.mLastRenderFrame);
                break;
            }
            case 105: {
                LiteavLog.i(TAG, "handleMessage: MSG_FORCE_PROCESS");
                this.removeMsgFromVideoProcessHandler(105);
                this.mInvalidate = true;
            }
            case 101: {
                if (this.mStatus != a.b && !this.mInvalidate) {
                    LiteavLog.e(TAG, "MSG_PROCESS_FROM_SOURCE FAILD AS mStatus == " + (Object)((Object)this.mStatus));
                    return true;
                }
                this.processFrame();
                this.mInvalidate = false;
            }
        }
        return true;
    }

    public void setSplitScreenList(List<TXVideoEditConstants.TXAbsoluteRect> rectList, int canvasWidth, int canvasHeight) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gq.a(uGCVideoProcessor, rectList, canvasWidth, canvasHeight));
    }

    public void setOutputSize(int width, int height, GLConstants.GLScaleType scaleType) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gr.a(uGCVideoProcessor, width, height, scaleType));
    }

    private PixelFrame preScale(PixelFrame frameIn) {
        if (this.mEGLCore == null || this.mOutputHeight <= 0 || this.mOutputWidth <= 0 || frameIn.getWidth() == this.mOutputWidth && frameIn.getHeight() == this.mOutputHeight) {
            frameIn.retain();
            return frameIn;
        }
        if (this.mPreScaleRenderer == null) {
            this.mPreScaleRenderer = new j(this.mOutputWidth, this.mOutputHeight);
        }
        d d2 = this.mGLTexturePool.a(this.mOutputWidth, this.mOutputHeight);
        this.mPreScaleRenderer.a(frameIn, this.mScaleType, d2);
        PixelFrame pixelFrame = d2.a(frameIn.getGLContext());
        pixelFrame.setTimestamp(frameIn.getTimestamp());
        d2.release();
        return pixelFrame;
    }

    public void setDisplayView(DisplayTarget displayTarget, GLConstants.GLScaleType scaleType) {
        LiteavLog.i(TAG, "setDisplayView: displayTarget:" + displayTarget + "scaleType:" + (Object)((Object)scaleType));
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gs.a(uGCVideoProcessor, displayTarget, scaleType));
    }

    public void setRenderRotation(Rotation rotation) {
        LiteavLog.i(TAG, "setRenderRotation: ".concat(String.valueOf((Object)rotation)));
        if (rotation == null) {
            return;
        }
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gb.a(uGCVideoProcessor, rotation));
        this.sendMsgToVideoProcessHandler(104);
    }

    public void setEncodeParams(VideoEncodeParams encodeParams) {
        LiteavLog.i(TAG, "setEncodeParams: ".concat(String.valueOf(encodeParams)));
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gc.a(uGCVideoProcessor, encodeParams));
    }

    public void setVideoEncodedFrameListener(VideoEncodedFrameListener listener) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gd.a(uGCVideoProcessor, listener));
    }

    public void setPictureTransition(int type) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(ge.a(uGCVideoProcessor, type));
    }

    public void setSpeedList(List<TXVideoEditConstants.TXSpeed> speedList) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gf.a(uGCVideoProcessor, speedList));
    }

    public WatermarkProcessor getWatermarkProcessor() {
        VideoProcessManager videoProcessManager = this.mVideoProcessManager;
        if (videoProcessManager != null) {
            return videoProcessManager.getWatermarkProcessor();
        }
        return null;
    }

    public VideoEffectProcessor getEffectProcessor() {
        VideoProcessManager videoProcessManager = this.mVideoProcessManager;
        if (videoProcessManager != null) {
            return videoProcessManager.getEffectProcessor();
        }
        return null;
    }

    public VideoTransitionProcessor getTransitionProcessor() {
        VideoProcessManager videoProcessManager = this.mVideoProcessManager;
        if (videoProcessManager != null) {
            return videoProcessManager.getTransitionProcessor();
        }
        return null;
    }

    public void setBeautyFilter(int beautyLevel, int whiteningLevel) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gg.a(uGCVideoProcessor, beautyLevel, whiteningLevel));
    }

    public void setSpecialRatio(float specialRatio) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gh.a(uGCVideoProcessor, specialRatio));
        this.sendMsgToVideoProcessHandler(104);
    }

    public void setFilter(Bitmap leftBitmap, float leftIntensity, Bitmap rightBitmap, float rightIntensity, float leftRatio) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gi.a(uGCVideoProcessor, leftBitmap, leftIntensity, rightBitmap, rightIntensity, leftRatio));
        this.sendMsgToVideoProcessHandler(104);
    }

    public void setCustomVideoProcessListener(TXVideoEditer.TXVideoCustomProcessListener listener) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gj.a(uGCVideoProcessor, listener));
    }

    public void setProgressListener(VideoProcessListener listener) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gk.a(uGCVideoProcessor, listener));
    }

    private void initProcessChain(int width, int height) {
        LiteavLog.i(TAG, "initProcessChain:  width:" + width + " height:" + height);
        if (this.mEGLCore == null) {
            return;
        }
        if (this.mVideoProcessManager != null) {
            this.mVideoProcessManager.initFilter(this.mGLTexturePool, width, height, this.mVideoPreprocessorListener);
            this.mVideoProcessManager.setListener(this.mEffectProcessorListener);
        }
        this.mUGCTransitionProcessor = new UGCTransitionProcessor(width, height, this.mGLTexturePool);
        this.mUGCCombineProcessor = new UGCCombineProcessor(width, height, this.mGLTexturePool);
    }

    private void reInitProcessorChain(int width, int height) {
        if (this.mEGLCore == null) {
            return;
        }
        if (this.mVideoProcessManager != null) {
            this.mVideoProcessManager.reInitFilter(this.mGLTexturePool, width, height, this.mVideoPreprocessorListener);
        }
        if (this.mUGCTransitionProcessor == null) {
            this.mUGCTransitionProcessor = new UGCTransitionProcessor(width, height, this.mGLTexturePool);
        }
        if (this.mUGCCombineProcessor == null) {
            this.mUGCCombineProcessor = new UGCCombineProcessor(width, height, this.mGLTexturePool);
        }
    }

    private void unInitVideoProcessor() {
        LiteavLog.i(TAG, "uninitVideoProcessor: ");
        if (this.mVideoProcessManager != null) {
            this.mVideoProcessManager.unInitFilter(this.mVideoPreprocessorListener);
            this.mVideoProcessManager.unInitialize();
            this.mVideoProcessManager = null;
        }
        if (this.mUGCTransitionProcessor != null) {
            this.mUGCTransitionProcessor.release();
            this.mUGCTransitionProcessor = null;
        }
        if (this.mUGCCombineProcessor != null) {
            this.mUGCCombineProcessor.release();
            this.mUGCCombineProcessor = null;
        }
    }

    private void processFrame() {
        if (!this.mIsInit) {
            return;
        }
        List<PixelFrame> list = this.mUGCMediaListSource.readNextVideoFrame();
        if (list == null || list.size() <= 0) {
            if (this.mLastRenderFrame != null) {
                this.mFinalPts = this.mLastRenderFrame.getTimestamp();
                LiteavLog.i(TAG, "processFrameFromSource: get no frame mFinalPts:" + this.mFinalPts + "  mLastProgressedFrame\uff1a" + this.mLastProgressedFrame);
                CustomHandler customHandler = this.mVideoProcessHandler;
                if (customHandler != null) {
                    customHandler.removeCallbacks(this.onCompleteBroadcastRunnable);
                    customHandler.postDelayed(this.onCompleteBroadcastRunnable, 100L);
                }
            }
            return;
        }
        PixelFrame pixelFrame = list.get(0);
        int n2 = pixelFrame.getWidth();
        int n3 = pixelFrame.getHeight();
        if (this.mOutputWidth > 0 && this.mOutputHeight > 0) {
            n2 = this.mOutputWidth;
            n3 = this.mOutputHeight;
        }
        boolean bl2 = false;
        if (this.isNeedReCreateEGL(pixelFrame.getGLContext(), n2, n3)) {
            if (this.mVideoProcessManager != null) {
                this.mVideoProcessManager.unInitFilter(this.mVideoPreprocessorListener);
            }
            if (this.mUGCTransitionProcessor != null) {
                this.mUGCTransitionProcessor.release();
                this.mUGCTransitionProcessor = null;
            }
            if (this.mUGCCombineProcessor != null) {
                this.mUGCCombineProcessor.release();
                this.mUGCCombineProcessor = null;
            }
            if (this.mPreScaleRenderer != null) {
                this.mPreScaleRenderer.a();
                this.mPreScaleRenderer = null;
            }
            this.uninitializedEGL();
            bl2 = true;
        }
        if (this.mEGLCore == null) {
            this.initializeEGL(pixelFrame.getGLContext(), n2, n3);
            if (!bl2) {
                this.initProcessChain(n2, n3);
            } else {
                this.reInitProcessorChain(n2, n3);
            }
        }
        if (this.mUGCCombineProcessor == null || this.mUGCTransitionProcessor == null) {
            return;
        }
        long l2 = pixelFrame.getTimestamp();
        if (this.mUGCAVSyncer.syncVideo(l2) == UGCAVSyncer.SkipMode.SKIP_CURRENT_FRAME) {
            ++this.mSkipFrameCount;
            if (this.mSkipFrameCount < 3) {
                Iterator<PixelFrame> iterator = list.iterator();
                while (iterator.hasNext()) {
                    iterator.next().release();
                }
                if (this.mStatus == a.b) {
                    this.sendMsgToVideoProcessHandler(101);
                }
                return;
            }
        }
        this.mSkipFrameCount = 0;
        if (list.size() > 1) {
            pixelFrame = this.mRectList != null ? this.mUGCCombineProcessor.processFrame(list, this.mRectList) : this.mUGCTransitionProcessor.processFrame(list, this.mTransitionType);
        }
        if (pixelFrame == null) {
            PixelFrame.releasePixelFrames(list);
            return;
        }
        if (this.mLastRenderFrame != null) {
            this.mLastRenderFrame.release();
        }
        this.mLastRenderFrame = this.preScale(pixelFrame);
        if (this.mVideoProcessManager != null) {
            this.mVideoProcessManager.processFrame(this.mLastRenderFrame);
        }
        if (list.size() > 1) {
            pixelFrame.release();
        }
        Iterator<PixelFrame> iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next().release();
        }
    }

    public void setReverse(boolean reverse) {
        this.mReverse = reverse;
    }

    private boolean filtInvalidatedFrame(long framePts) {
        if (this.mReverse) {
            framePts = Math.abs(this.mUGCMediaListSource.getDuration() - framePts);
        }
        framePts = Math.min(this.mUGCMediaListSource.getDuration(), framePts);
        if (this.mTargetSeekPts.get() != null && Math.abs(framePts - this.mTargetSeekPts.get()) > 100L) {
            LiteavLog.i(TAG, "filtInvalidatedFrame: framePts:" + framePts + "  mTargetSeekPts:" + this.mTargetSeekPts + "  d :" + Math.abs(framePts - this.mTargetSeekPts.get()));
            return true;
        }
        return false;
    }

    private void handleProcessFrame(PixelFrame frame) {
        CustomHandler customHandler;
        if (this.filtInvalidatedFrame(frame.getTimestamp())) {
            return;
        }
        this.mTargetSeekPts.set(null);
        if (this.mVideoProcessListener != null) {
            this.mLastProgressedFrame = frame.getTimestamp();
            this.mVideoProcessListener.onProgress(frame.getTimestamp());
        }
        FrameMetaData frameMetaData = new FrameMetaData();
        frameMetaData.setEncodeRotation(this.mRotation);
        frameMetaData.setRenderRotation(this.mRotation);
        frame.setMetaData(frameMetaData);
        if (!this.mIsRecord && this.mRenderer != null) {
            this.mRenderer.a(frame);
        }
        if (this.mIsRecord && this.mVideoEncodeController != null) {
            this.mVideoEncodeController.encodeFrame(frame);
            if (this.mFinalPts > 0L && frame.getTimestamp() == this.mFinalPts) {
                LiteavLog.i(TAG, "processFrameFromSource: signalEndOfStream");
                this.mVideoEncodeController.signalEndOfStream();
                return;
            }
        } else if (this.mFinalPts > 0L && frame.getTimestamp() == this.mFinalPts && (customHandler = this.mVideoProcessHandler) != null) {
            customHandler.removeCallbacks(this.onCompleteBroadcastRunnable);
            customHandler.post(this.onCompleteBroadcastRunnable);
        }
        if (this.mStatus == a.b) {
            this.sendMsgToVideoProcessHandler(101);
        }
    }

    private boolean isNeedReCreateEGL(Object sharedContext, int width, int height) {
        if (this.mCurEGLContext == null || width < 0 || height < 0) {
            return false;
        }
        if (!sharedContext.equals(this.mCurEGLContext) || this.mCurEGLWidth != width || this.mCurEGLHeight != height) {
            LiteavLog.i(this.mThrottlers.a("recreateGL"), TAG, "isNeedReCreateEGL: true", new Object[0]);
            return true;
        }
        return false;
    }

    private void initializeEGL(Object sharedContext, int width, int height) {
        try {
            this.mEGLCore = new EGLCore();
            this.mEGLCore.initialize(sharedContext, null, width, height);
            this.mEGLCore.makeCurrent();
            this.mCurEGLContext = sharedContext;
            this.mCurEGLWidth = width;
            this.mCurEGLHeight = height;
            this.mGLTexturePool = new e();
            return;
        }
        catch (f f2) {
            this.mEGLCore = null;
            LiteavLog.e(this.mThrottlers.a("initGL"), TAG, f2.getMessage(), new Object[0]);
            return;
        }
    }

    private void uninitializedEGL() {
        LiteavLog.i(this.mThrottlers.a("uninitGL"), TAG, "uninitializedEGL", new Object[0]);
        if (this.mGLTexturePool != null) {
            this.mGLTexturePool.b();
        }
        if (this.mTXVideoCustomProcessListener != null) {
            this.mTXVideoCustomProcessListener.onTextureDestroyed();
        }
        EGLCore.destroy(this.mEGLCore);
        this.mEGLCore = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runOnVideoProcessHandler(Runnable runnable) {
        CustomHandler customHandler;
        UGCVideoProcessor uGCVideoProcessor = this;
        synchronized (uGCVideoProcessor) {
            if (this.mVideoProcessHandler == null || this.mVideoProcessHandler.getLooper() == null || this.mVideoProcessHandler.getLooper().getThread() == null || !this.mVideoProcessHandler.getLooper().getThread().isAlive()) {
                LiteavLog.e(TAG, "handler post fail thread is not alive ");
                return false;
            }
            customHandler = this.mVideoProcessHandler;
        }
        if (customHandler != null) {
            if (Looper.myLooper() == customHandler.getLooper()) {
                runnable.run();
                return true;
            }
            boolean bl2 = customHandler.post(runnable);
            if (!bl2) {
                LiteavLog.e(TAG, "handler post fail ret = ".concat(String.valueOf(bl2)));
            }
            return bl2;
        }
        return false;
    }

    public void refreshOneFrame() {
        this.sendMsgToVideoProcessHandler(104);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMsgToVideoProcessHandler(int msg) {
        UGCVideoProcessor uGCVideoProcessor = this;
        synchronized (uGCVideoProcessor) {
            if (this.mVideoProcessHandler != null) {
                this.mVideoProcessHandler.sendEmptyMessage(msg);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMsgFromVideoProcessHandler(int msg) {
        UGCVideoProcessor uGCVideoProcessor = this;
        synchronized (uGCVideoProcessor) {
            if (this.mVideoProcessHandler != null) {
                this.mVideoProcessHandler.removeMessages(msg);
            }
            return;
        }
    }

    static /* synthetic */ void lambda$new$16(UGCVideoProcessor this_) {
        this_.onCompleteBroadcast();
    }

    static /* synthetic */ void lambda$setProgressListener$15(UGCVideoProcessor this_, VideoProcessListener listener) {
        this_.mVideoProcessListener = listener;
    }

    static /* synthetic */ void lambda$setCustomVideoProcessListener$14(UGCVideoProcessor this_, TXVideoEditer.TXVideoCustomProcessListener listener) {
        this_.mTXVideoCustomProcessListener = listener;
    }

    static /* synthetic */ void lambda$setFilter$13(UGCVideoProcessor this_, Bitmap leftBitmap, float leftIntensity, Bitmap rightBitmap, float rightIntensity, float leftRatio) {
        if (this_.mVideoProcessManager != null) {
            this_.mVideoProcessManager.setFilter(leftBitmap, leftIntensity, rightBitmap, rightIntensity, leftRatio);
        }
    }

    static /* synthetic */ void lambda$setSpecialRatio$12(UGCVideoProcessor this_, float specialRatio) {
        if (this_.mVideoProcessManager != null) {
            this_.mVideoProcessManager.setSpecialRatio(specialRatio);
        }
    }

    static /* synthetic */ void lambda$setBeautyFilter$11(UGCVideoProcessor this_, int beautyLevel, int whiteningLevel) {
        if (this_.mVideoProcessManager != null) {
            this_.mVideoProcessManager.setBeautyFilter(beautyLevel, whiteningLevel);
        }
    }

    static /* synthetic */ void lambda$setSpeedList$10(UGCVideoProcessor this_, List speedList) {
        if (this_.mSpeedProcessor == null) {
            this_.mSpeedProcessor = new SpeedProcessor();
        }
        LiteavLog.i(TAG, "==== setSpeedList ==== ");
        if (speedList != null) {
            UGCDataReport.reportDAU(1019);
            ArrayList<TXVideoEditConstants.TXSpeed> arrayList = new ArrayList<TXVideoEditConstants.TXSpeed>();
            for (int i2 = 0; i2 < speedList.size(); ++i2) {
                TXVideoEditConstants.TXSpeed tXSpeed = (TXVideoEditConstants.TXSpeed)speedList.get(i2);
                TXVideoEditConstants.TXSpeed tXSpeed2 = new TXVideoEditConstants.TXSpeed();
                new TXVideoEditConstants.TXSpeed().speedLevel = tXSpeed.speedLevel;
                tXSpeed2.startTime = tXSpeed.startTime;
                tXSpeed2.endTime = tXSpeed.endTime;
                arrayList.add(tXSpeed2);
            }
            this_.mSpeedProcessor.setSpeedList(arrayList);
            return;
        }
        this_.mSpeedProcessor.setSpeedList(null);
    }

    static /* synthetic */ void lambda$setPictureTransition$9(UGCVideoProcessor this_, int type) {
        this_.mTransitionType = type;
    }

    static /* synthetic */ void lambda$setVideoEncodedFrameListener$8(UGCVideoProcessor this_, VideoEncodedFrameListener listener) {
        this_.mVideoEncodedFrameListener = listener;
    }

    static /* synthetic */ void lambda$setEncodeParams$7(UGCVideoProcessor this_, VideoEncodeParams encodeParams) {
        this_.mVideoEncodeParams = encodeParams;
    }

    static /* synthetic */ void lambda$setRenderRotation$6(UGCVideoProcessor this_, Rotation rotation) {
        this_.mRotation = rotation;
    }

    static /* synthetic */ void lambda$setDisplayView$5(UGCVideoProcessor this_, DisplayTarget displayTarget, GLConstants.GLScaleType scaleType) {
        this_.mDisplayTarget = displayTarget;
        if (scaleType != null) {
            this_.mScaleType = scaleType;
        }
        if (this_.mRenderer != null) {
            this_.mRenderer.a(this_.mDisplayTarget, true);
            this_.mRenderer.a(this_.mScaleType);
        }
        if (this_.mVideoProcessManager != null) {
            this_.mVideoProcessManager.setScaleType(this_.mScaleType);
        }
    }

    static /* synthetic */ void lambda$setOutputSize$4(UGCVideoProcessor this_, int width, int height, GLConstants.GLScaleType scaleType) {
        this_.mOutputWidth = width;
        this_.mOutputHeight = height;
        if (width > 0) {
            this_.mScaleType = scaleType;
        }
    }

    static /* synthetic */ void lambda$setSplitScreenList$3(UGCVideoProcessor this_, List rectList, int canvasWidth, int canvasHeight) {
        this_.mRectList = rectList;
        this_.setOutputSize(canvasWidth, canvasHeight, GLConstants.GLScaleType.b);
    }

    static /* synthetic */ void lambda$start$2(UGCVideoProcessor this_, boolean isRecord) {
        this_.mIsRecord = isRecord;
        this_.mTargetSeekPts.set(null);
        this_.mFinalPts = -1L;
        this_.mSkipFrameCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void lambda$unInitialize$1(UGCVideoProcessor this_) {
        this_.mFinalPts = -1L;
        if (this_.mLastRenderFrame != null) {
            this_.mLastRenderFrame.release();
            this_.mLastRenderFrame = null;
        }
        if (this_.mRenderer != null) {
            this_.mRenderer.a(false);
            this_.mRenderer = null;
        }
        this_.stopEncoder();
        if (this_.mPreScaleRenderer != null) {
            this_.mPreScaleRenderer.a();
            this_.mPreScaleRenderer = null;
        }
        this_.unInitVideoProcessor();
        if (this_.mRenderThread != null) {
            if (LiteavSystemInfo.getSystemOSVersionInt() >= 18) {
                this_.mRenderThread.quitSafely();
            } else {
                this_.mRenderThread.quit();
            }
            this_.mRenderThread = null;
        }
        this_.uninitializedEGL();
        UGCVideoProcessor uGCVideoProcessor = this_;
        synchronized (uGCVideoProcessor) {
            if (this_.mVideoProcessHandler != null) {
                this_.mVideoProcessHandler.quitLooper();
                this_.mVideoProcessHandler = null;
            }
            return;
        }
    }

    static /* synthetic */ void lambda$initialize$0(UGCVideoProcessor this_) {
        if (this_.mVideoProcessManager != null) {
            this_.mVideoProcessManager.initialize();
        }
    }

    static /* synthetic */ boolean access$lambda$0(UGCVideoProcessor uGCVideoProcessor, Message message) {
        return uGCVideoProcessor.handleMessage(message);
    }

    static /* synthetic */ void access$lambda$1(UGCVideoProcessor uGCVideoProcessor) {
        uGCVideoProcessor.stopEncoder();
    }

    public static interface VideoProcessListener {
        public void onProgress(long var1);

        public void onComplete(TXVideoEditConstants.TXGenerateResult var1);
    }

    public static interface VideoEncodedFrameListener {
        public void onVideoEncodeStarted();

        public void onVideoFrameEncoded(EncodedVideoFrame var1);

        public void onVideoEncodingCompleted();
    }

    static enum a {
        a,
        b,
        c;

    }
}

