/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import cn.rongcloud.rtc.api.callback.IRCRTCAudioDataListener;
import cn.rongcloud.rtc.base.RCRTCAudioFrame;
import cn.rongcloud.rtc.core.AudioFrame;
import cn.rongcloud.rtc.core.AudioSink;
import cn.rongcloud.rtc.core.AudioSource;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import java.nio.ByteBuffer;

public class AudioTrack
extends MediaStreamTrack {
    protected AudioSource mAudioSource;
    private IRCRTCAudioDataListener mAudioDataListener;
    private long sink = 0L;
    AudioSink mAudioSink = new AudioSink(){
        RCRTCAudioFrame audioFrame = new RCRTCAudioFrame();
        byte[] localFrame;

        @Override
        public void onFrame(AudioFrame frame) {
            IRCRTCAudioDataListener audioDataListener = AudioTrack.this.mAudioDataListener;
            if (audioDataListener != null) {
                if (frame.getSampleRate() != 48000) {
                    return;
                }
                ByteBuffer frameBuffer = frame.getData();
                if (this.localFrame == null) {
                    this.localFrame = new byte[frameBuffer.capacity()];
                }
                frameBuffer.rewind();
                frameBuffer.get(this.localFrame, 0, this.localFrame.length);
                this.audioFrame.setBytes(this.localFrame);
                this.audioFrame.setChannels(frame.getChannels());
                this.audioFrame.setSampleRate(frame.getSampleRate());
                this.audioFrame.setBytesPerSample(frame.getBitsPerSample() / 8);
                this.audioFrame.setTimestamp(frame.getTimestamp());
                audioDataListener.onAudioFrame(this.audioFrame);
            }
        }
    };

    public AudioTrack(long nativeTrack) {
        super(nativeTrack);
        this.setSink(this.mAudioSink);
    }

    public void setVolume(double volume) {
        AudioTrack.nativeSetVolume(this.getNativeAudioTrack(), volume);
    }

    long getNativeAudioTrack() {
        return this.getNativeMediaStreamTrack();
    }

    public AudioSource getAudioSource() {
        return this.mAudioSource;
    }

    public void setAudioSource(AudioSource audioSource) {
        this.mAudioSource = audioSource;
    }

    private void setSink(AudioSink audioSink) {
        this.sink = AudioTrack.nativeWrapSink(audioSink);
        AudioTrack.nativeAddSink(this.getNativeAudioTrack(), this.sink);
    }

    @Override
    public void dispose() {
        this.removeSink();
        super.dispose();
        this.mAudioSink = null;
        this.mAudioDataListener = null;
    }

    private void removeSink() {
        if (this.sink != 0L) {
            AudioTrack.nativeRemoveSink(this.getNativeAudioTrack(), this.sink);
        }
    }

    public void setAudioDataListener(IRCRTCAudioDataListener audioDataListener) {
        this.mAudioDataListener = audioDataListener;
    }

    private static native void nativeSetVolume(long var0, double var2);

    private static native void nativeAddSink(long var0, long var2);

    private static native void nativeRemoveSink(long var0, long var2);

    private static native long nativeWrapSink(AudioSink var0);
}

