/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static final int MIN_BUCKET_NAME_LENGTH = 3;
    public static final int MAX_BUCKET_NAME_LENGTH = 63;
    private static List<Class<?>> clazzs = Arrays.asList(String.class, Boolean.class, Integer.class, Long.class, Double.class, Float.class, Short.class, Byte.class, Collection.class, Map.class, HashMap.class, ArrayList.class, HashSet.class, Date.class);
    private static List<Character> need = Arrays.asList(Character.valueOf('\\'), Character.valueOf('\"'), Character.valueOf('$'), Character.valueOf('\''));

    public static String join(Object[] strings, String spliter) {
        boolean i = false;
        StringBuffer buffer = new StringBuffer();
        for (Object s : strings) {
            if (!i) {
                buffer.append(s);
                i = true;
                continue;
            }
            buffer.append(spliter + s);
        }
        return buffer.toString();
    }

    public static String join(int[] strings, String spliter) {
        boolean i = false;
        StringBuffer buffer = new StringBuffer();
        int[] nArray = strings;
        int n = nArray.length;
        for (int j = 0; j < n; ++j) {
            Integer s = nArray[j];
            if (!i) {
                buffer.append(s);
                i = true;
                continue;
            }
            buffer.append(spliter + s);
        }
        return buffer.toString();
    }

    public static String join(byte[] strings, String spliter) {
        boolean i = false;
        StringBuffer buffer = new StringBuffer();
        byte[] byArray = strings;
        int n = byArray.length;
        for (int j = 0; j < n; ++j) {
            Byte s = byArray[j];
            if (!i) {
                buffer.append(s);
                i = true;
                continue;
            }
            buffer.append(spliter + s);
        }
        return buffer.toString();
    }

    public static String join(List<String> strings, String spliter) {
        return StringUtils.join(strings.toArray(), spliter);
    }

    public static boolean isBlank(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().length() == 0;
    }

    public static String validateBucketName(String bname) {
        if (bname == null) {
            return null;
        }
        if (bname.length() < 3 || bname.length() > 63) {
            return null;
        }
        int previous = 0;
        for (int i = 0; i < bname.length(); ++i) {
            char next = bname.charAt(i);
            if (next >= 'A' && next <= 'Z') {
                return null;
            }
            if (next == ' ' || next == '\t' || next == '\r' || next == '\n') {
                return null;
            }
            if (next == '.') {
                if (previous == 46) {
                    return null;
                }
                if (previous == 45) {
                    return null;
                }
            } else if (next == '-' ? previous == 46 : next < '0' || next > '9' && next < 'a' || next > 'z') {
                return null;
            }
            previous = next;
        }
        if (previous == 46 || previous == 45) {
            return null;
        }
        return bname;
    }

    public static String object2string(Object obj) {
        return StringUtils.object2string(0, obj, null);
    }

    private static String object2string(int index, Object obj, Field fieldF) {
        StringBuffer value = new StringBuffer();
        StringBuffer prefixSb = new StringBuffer();
        for (int i = 0; i < index - 1; ++i) {
            prefixSb.append("       ");
        }
        String prefix = prefixSb.toString();
        if (fieldF != null) {
            value.append("\n" + prefix + fieldF.getName() + "=" + obj.getClass() + "\n");
        } else {
            value.append("\n" + prefix + obj.getClass() + "\n");
        }
        if (index != 0) {
            prefixSb.append("       ");
        }
        prefix = prefixSb.toString();
        Field[] fields = obj.getClass().getDeclaredFields();
        HashMap<Field, Object> valuesToAdd = new HashMap<Field, Object>();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            field.setAccessible(true);
            Object fieldValue = null;
            try {
                fieldValue = field.get(obj);
            }
            catch (IllegalArgumentException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            if (fieldValue != null) {
                if (clazzs.contains(fieldValue.getClass())) {
                    value.append(prefix + field.getName() + "=" + fieldValue.toString() + "\n");
                    continue;
                }
                if (fieldValue.getClass().isEnum()) {
                    value.append(prefix + field.getName() + "=" + fieldValue.toString() + "\n");
                    continue;
                }
                valuesToAdd.put(field, fieldValue);
                continue;
            }
            if (fieldValue != null) continue;
            value.append(prefix + field.getName() + "=null\n");
        }
        for (Map.Entry obj1 : valuesToAdd.entrySet()) {
            value.append(StringUtils.object2string(index + 1, obj1.getValue(), (Field)obj1.getKey()));
        }
        return value.toString();
    }

    public static byte[] getBytesUnchecked(String string, String charsetName) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw StringUtils.newIllegalStateException(charsetName, e);
        }
    }

    private static IllegalStateException newIllegalStateException(String charsetName, UnsupportedEncodingException e) {
        return new IllegalStateException(charsetName + ": " + e);
    }

    public static boolean isNumeric(String string) {
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(string).matches();
    }

    public static String object2json(Object obj) {
        return StringUtils.object2json(obj, false);
    }

    private static String object2json(Object obj, boolean escape) {
        StringBuffer buffer = new StringBuffer();
        if (obj instanceof Map) {
            buffer.append("{");
            Map map = (Map)obj;
            int size = map.size();
            int count = 0;
            for (Map.Entry entry : map.entrySet()) {
                buffer.append("\"" + StringUtils.escape(entry.getKey(), false) + "\":" + StringUtils.object2json(entry.getValue(), true));
                if (count < size - 1) {
                    buffer.append(",");
                }
                ++count;
            }
            buffer.append("}");
        } else if (obj instanceof Collection) {
            buffer.append("[");
            Collection collect = (Collection)obj;
            int size = collect.size();
            int count = 0;
            for (Object o : collect) {
                if (count == 2) {
                    buffer.append(StringUtils.object2json(o, true));
                } else {
                    buffer.append(StringUtils.object2json(o));
                }
                if (count < size - 1) {
                    buffer.append(",");
                }
                ++count;
            }
            buffer.append("]");
        } else if (obj instanceof Number || obj instanceof Boolean) {
            buffer.append(obj.toString());
        } else if (escape) {
            buffer.append("\"" + StringUtils.escape(obj.toString(), true) + "\"");
        } else {
            buffer.append("\"" + StringUtils.escape(obj.toString(), false) + "\"");
        }
        return buffer.toString();
    }

    private static String escape(Object obj, boolean dollar) {
        String s = obj.toString();
        byte[] chars = s.getBytes();
        int count = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (!need.contains(Character.valueOf((char)chars[i])) || !dollar && (char)chars[i] == '$') continue;
            ++count;
        }
        byte[] newChars = new byte[chars.length + count];
        int j = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (need.contains(Character.valueOf((char)chars[i])) && (dollar || (char)chars[i] != '$')) {
                newChars[i + j] = 92;
                newChars[i + j + 1] = chars[i];
                ++j;
                continue;
            }
            newChars[i + j] = chars[i];
        }
        return new String(newChars);
    }

    public static boolean checkLong(Object o) {
        String value = String.valueOf(o);
        Pattern pattern = Pattern.compile("^[0-9]+$");
        Matcher matcher = pattern.matcher(value);
        return matcher.find();
    }
}

