/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui;

import android.util.Log;
import android.util.Pair;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.Invoker;
import com.taobao.weex.bridge.MethodInvoker;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.IFComponentHolder;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXLogUtils;
import io.dcloud.feature.uniapp.UniSDKInstance;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.ui.action.AbsComponentData;
import io.dcloud.feature.uniapp.ui.component.AbsVContainer;
import io.dcloud.feature.uniapp.ui.component.UniComponent;
import io.dcloud.feature.uniapp.ui.component.UniComponentProp;
import io.dcloud.feature.uniapp.ui.component.UniVContainer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SimpleComponentHolder
implements IFComponentHolder {
    public static final String TAG = "SimpleComponentHolder";
    private final Class<? extends WXComponent> mClz;
    private Map<String, Invoker> mPropertyInvokers;
    private Map<String, Invoker> mMethodInvokers;
    private ComponentCreator mCreator;

    public SimpleComponentHolder(Class<? extends WXComponent> clz) {
        this(clz, new ClazzComponentCreator(clz));
    }

    public SimpleComponentHolder(Class<? extends WXComponent> clz, ComponentCreator customCreator) {
        this.mClz = clz;
        this.mCreator = customCreator;
    }

    @Override
    public void loadIfNonLazy() {
        Annotation[] annotations;
        for (Annotation annotation : annotations = this.mClz.getDeclaredAnnotations()) {
            if (!(annotation instanceof Component)) continue;
            if (!((Component)annotation).lazyload() && this.mMethodInvokers == null) {
                this.generate();
            }
            return;
        }
    }

    private synchronized void generate() {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(TAG, "Generate Component:" + this.mClz.getSimpleName());
        }
        Pair<Map<String, Invoker>, Map<String, Invoker>> methodPair = SimpleComponentHolder.getMethods(this.mClz);
        this.mPropertyInvokers = (Map)methodPair.first;
        this.mMethodInvokers = (Map)methodPair.second;
    }

    public static Pair<Map<String, Invoker>, Map<String, Invoker>> getMethods(Class clz) {
        HashMap<String, MethodInvoker> methods = new HashMap<String, MethodInvoker>();
        HashMap<String, MethodInvoker> mInvokers = new HashMap<String, MethodInvoker>();
        try {
            block5: for (Method method : clz.getMethods()) {
                try {
                    for (Annotation anno : method.getDeclaredAnnotations()) {
                        String name;
                        Annotation methodAnno;
                        String name2;
                        if (anno == null) continue;
                        if (anno instanceof WXComponentProp) {
                            name2 = ((WXComponentProp)anno).name();
                            methods.put(name2, new MethodInvoker(method, true));
                            continue block5;
                        }
                        if (anno instanceof JSMethod) {
                            methodAnno = (JSMethod)anno;
                            name = methodAnno.alias();
                            if ("_".equals(name)) {
                                name = method.getName();
                            }
                            mInvokers.put(name, new MethodInvoker(method, methodAnno.uiThread()));
                            continue block5;
                        }
                        if (anno instanceof UniComponentProp) {
                            name2 = ((UniComponentProp)anno).name();
                            methods.put(name2, new MethodInvoker(method, true));
                            continue block5;
                        }
                        if (!(anno instanceof UniJSMethod)) continue;
                        methodAnno = (UniJSMethod)anno;
                        name = methodAnno.alias();
                        if ("_".equals(name)) {
                            name = method.getName();
                        }
                        mInvokers.put(name, new MethodInvoker(method, methodAnno.uiThread()));
                        continue block5;
                    }
                }
                catch (ArrayIndexOutOfBoundsException | IncompatibleClassChangeError throwable) {
                    // empty catch block
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            WXLogUtils.e(TAG, e);
        }
        return new Pair(methods, mInvokers);
    }

    @Override
    public synchronized WXComponent createInstance(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        WXComponent component = this.mCreator.createInstance(instance, parent, basicComponentData);
        component.bindHolder(this);
        return component;
    }

    @Override
    public synchronized Invoker getPropertyInvoker(String name) {
        if (this.mPropertyInvokers == null) {
            this.generate();
        }
        return this.mPropertyInvokers.get(name);
    }

    @Override
    public Invoker getMethodInvoker(String name) {
        if (this.mMethodInvokers == null) {
            this.generate();
        }
        return this.mMethodInvokers.get(name);
    }

    @Override
    public synchronized String[] getMethods() {
        if (this.mMethodInvokers == null) {
            this.generate();
        }
        Set<String> keys = this.mMethodInvokers.keySet();
        try {
            return keys.toArray(new String[keys.size()]);
        }
        catch (Throwable throwable) {
            if (this.mClz != null) {
                String name = this.mClz.getName();
                String errorMsg = name + ": gen methods failed";
                WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_REGISTER_COMPONENT, "registerComponents", errorMsg, null);
            }
            return new String[1];
        }
    }

    public static class ClazzComponentCreator
    implements ComponentCreator {
        private final Class<? extends WXComponent> mCompClz;
        private Constructor<? extends WXComponent> mConstructor;
        private Constructor<? extends WXComponent> mAbsConstructor;

        public ClazzComponentCreator(Class<? extends WXComponent> c) {
            this.mCompClz = c;
        }

        private Constructor<? extends WXComponent> getComponentConstructor(Boolean isAbs) {
            Constructor<? extends WXComponent> constructor;
            Class<AbsComponentData> componentData;
            Class<AbsVContainer> container;
            Class instance;
            Class<? extends WXComponent> c = this.mCompClz;
            if (isAbs.booleanValue()) {
                instance = UniSDKInstance.class;
                container = AbsVContainer.class;
                componentData = AbsComponentData.class;
            } else {
                instance = WXSDKInstance.class;
                container = WXVContainer.class;
                componentData = BasicComponentData.class;
            }
            try {
                constructor = c.getConstructor(instance, container, componentData);
            }
            catch (NoSuchMethodException e) {
                WXLogUtils.d("ClazzComponentCreator", "Use deprecated component constructor");
                try {
                    constructor = c.getConstructor(instance, container, Boolean.TYPE, componentData);
                }
                catch (NoSuchMethodException e1) {
                    try {
                        constructor = c.getConstructor(instance, container, String.class, Boolean.TYPE, componentData);
                    }
                    catch (NoSuchMethodException e2) {
                        Log.e((String)"shutao", (String)("        " + c.getSuperclass().getSimpleName()));
                        throw new WXRuntimeException("Can't find constructor of component.");
                    }
                }
            }
            return constructor;
        }

        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            Constructor<? extends WXComponent> constructor;
            boolean isAbs;
            boolean bl = isAbs = UniVContainer.class.isAssignableFrom(this.mCompClz) || UniComponent.class.isAssignableFrom(this.mCompClz);
            if (isAbs) {
                if (this.mAbsConstructor == null) {
                    this.mAbsConstructor = this.getComponentConstructor(isAbs);
                }
                constructor = this.mAbsConstructor;
            } else {
                if (this.mConstructor == null) {
                    this.mConstructor = this.getComponentConstructor(isAbs);
                }
                constructor = this.mConstructor;
            }
            int parameters = constructor.getParameterTypes().length;
            WXComponent component = parameters == 3 ? constructor.newInstance(instance, parent, basicComponentData) : (parameters == 4 ? constructor.newInstance(instance, parent, false, basicComponentData) : constructor.newInstance(instance, parent, instance.getInstanceId(), parent.isLazy()));
            return component;
        }
    }
}

