/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.common;

import com.taobao.weex.WXEnvironment;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.Invoker;
import com.taobao.weex.bridge.MethodInvoker;
import com.taobao.weex.bridge.ModuleFactory;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.common.WXModuleAnno;
import com.taobao.weex.utils.WXLogUtils;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.common.UniModuleAnno;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TypeModuleFactory<T extends WXModule>
implements ModuleFactory<T> {
    public static final String TAG = "TypeModuleFactory";
    Class<T> mClazz;
    Map<String, Invoker> mMethodMap;

    public TypeModuleFactory(Class<T> clz) {
        this.mClazz = clz;
    }

    private void generateMethodMap() {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(TAG, "extractMethodNames:" + this.mClazz.getSimpleName());
        }
        HashMap<String, Invoker> methodMap = new HashMap<String, Invoker>();
        try {
            block2: for (Method method : this.mClazz.getMethods()) {
                for (Annotation anno : method.getDeclaredAnnotations()) {
                    String name;
                    Annotation methodAnnotation;
                    if (anno == null) continue;
                    if (anno instanceof JSMethod) {
                        methodAnnotation = (JSMethod)anno;
                        name = "_".equals(methodAnnotation.alias()) ? method.getName() : methodAnnotation.alias();
                        methodMap.put(name, new MethodInvoker(method, methodAnnotation.uiThread()));
                        continue block2;
                    }
                    if (anno instanceof WXModuleAnno) {
                        methodAnnotation = (WXModuleAnno)anno;
                        methodMap.put(method.getName(), new MethodInvoker(method, methodAnnotation.runOnUIThread()));
                        continue block2;
                    }
                    if (anno instanceof UniJSMethod) {
                        methodAnnotation = (UniJSMethod)anno;
                        name = "_".equals(methodAnnotation.alias()) ? method.getName() : methodAnnotation.alias();
                        methodMap.put(name, new MethodInvoker(method, methodAnnotation.uiThread()));
                        continue block2;
                    }
                    if (!(anno instanceof UniModuleAnno)) continue;
                    methodAnnotation = (UniModuleAnno)anno;
                    methodMap.put(method.getName(), new MethodInvoker(method, methodAnnotation.runOnUIThread()));
                    continue block2;
                }
            }
        }
        catch (Throwable e) {
            WXLogUtils.e("[WXModuleManager] extractMethodNames:", e);
        }
        this.mMethodMap = methodMap;
    }

    @Override
    public T buildInstance() throws IllegalAccessException, InstantiationException {
        return (T)((WXModule)this.mClazz.newInstance());
    }

    @Override
    public String[] getMethods() {
        if (this.mMethodMap == null) {
            this.generateMethodMap();
        }
        Set<String> keys = this.mMethodMap.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    public Invoker getMethodInvoker(String name) {
        if (this.mMethodMap == null) {
            this.generateMethodMap();
        }
        return this.mMethodMap.get(name);
    }
}

