/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.adapter.widget.refresh;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import io.dcloud.feature.weex.adapter.widget.refresh.DCWeexBaseRefreshLayout;

public class WeexDcRefreshLayout
extends DCWeexBaseRefreshLayout {
    private boolean mDragger;
    private float mStartY;
    private float mStartX;
    private int mTouchSlop;

    public WeexDcRefreshLayout(Context context) {
        super(context);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.isEnabled()) {
            int action = ev.getAction();
            if (!this.isViewRefresh()) {
                return false;
            }
            switch (action) {
                case 0: {
                    this.mStartY = ev.getY();
                    this.mStartX = ev.getX();
                    this.mDragger = false;
                    break;
                }
                case 2: {
                    if (this.mDragger) {
                        return false;
                    }
                    float endY = ev.getY();
                    float endX = ev.getX();
                    float distanceX = Math.abs(endX - this.mStartX);
                    float distanceY = Math.abs(endY - this.mStartY);
                    if (!(distanceX > (float)this.mTouchSlop) || !(distanceX > distanceY)) break;
                    this.mDragger = true;
                    return false;
                }
                case 1: 
                case 3: {
                    this.mDragger = false;
                }
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    private boolean isViewRefresh() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (!this.canScrollVertically(child)) continue;
            return false;
        }
        return true;
    }

    private boolean canScrollVertically(View view) {
        if (view instanceof ViewGroup) {
            if (view.canScrollVertically(-1)) {
                return true;
            }
            for (int i = 0; i < ((ViewGroup)view).getChildCount(); ++i) {
                View child = ((ViewGroup)view).getChildAt(i);
                if (!this.canScrollVertically(child)) continue;
                return true;
            }
        }
        return false;
    }
}

