/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.extend;

import android.content.SharedPreferences;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.appfram.storage.StorageResultHandler;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.common.WXModule;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.feature.weex.WeexInstanceMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlusStorageModule
extends WXModule {
    HashMap<String, SharedPreferences> mAllAppNStorages = new HashMap(1);

    @JSMethod(uiThread=false)
    public void setItem(String key, String value, @Nullable JSCallback callback) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null) {
            StorageResultHandler.handleInvalidParam(callback);
            return;
        }
        Map<String, Object> data = null;
        SharedPreferences bundle = this.getAppNStorage();
        if (bundle != null) {
            PlatformUtil.setBundleData((SharedPreferences)bundle, (String)key, (String)value);
            data = StorageResultHandler.setItemResult(true);
        } else {
            data = StorageResultHandler.setItemResult(false);
        }
        if (callback != null) {
            callback.invoke(data);
        }
    }

    @JSMethod(uiThread=false)
    public void getItem(String key, @Nullable JSCallback callback) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            StorageResultHandler.handleInvalidParam(callback);
            return;
        }
        Map<String, Object> data = null;
        SharedPreferences bundle = this.getAppNStorage();
        if (bundle != null) {
            String v = bundle.getString(key, null);
            data = StorageResultHandler.getItemResult(v);
        } else {
            data = StorageResultHandler.getItemResult(null);
        }
        if (callback != null) {
            callback.invoke(data);
        }
    }

    @JSMethod(uiThread=false)
    public void removeItem(String key, @Nullable JSCallback callback) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            StorageResultHandler.handleInvalidParam(callback);
            return;
        }
        Map<String, Object> data = null;
        SharedPreferences bundle = this.getAppNStorage();
        if (bundle != null) {
            PlatformUtil.removeBundleData((SharedPreferences)bundle, (String)key);
            data = StorageResultHandler.removeItemResult(true);
        } else {
            data = StorageResultHandler.removeItemResult(false);
        }
        if (callback != null) {
            callback.invoke(data);
        }
    }

    @JSMethod(uiThread=false)
    public void length(@Nullable JSCallback callback) {
        SharedPreferences bundle = this.getAppNStorage();
        if (bundle != null) {
            Map<String, Object> data = StorageResultHandler.getLengthResult(this.getBundleDataSize(bundle));
            if (callback != null) {
                callback.invoke(data);
            }
        } else {
            StorageResultHandler.handleNoHandlerError(callback);
        }
    }

    @JSMethod(uiThread=false)
    public void getAllKeys(@Nullable JSCallback callback) {
        SharedPreferences bundle = this.getAppNStorage();
        if (bundle != null) {
            Map<String, Object> data = StorageResultHandler.getAllkeysResult(this.getBundleKeys(bundle));
            if (callback != null) {
                callback.invoke(data);
            }
        } else {
            StorageResultHandler.handleNoHandlerError(callback);
        }
    }

    private int getBundleDataSize(SharedPreferences bundle) {
        try {
            return bundle.getAll().size();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private List<String> getBundleKeys(SharedPreferences bundle) {
        ArrayList list = null;
        Map dataMap = bundle.getAll();
        if (dataMap.size() > 0) {
            list = new ArrayList(dataMap.keySet());
        }
        return list;
    }

    private SharedPreferences initAppNStorages(String pAppid) {
        return PlatformUtil.getOrCreateBundle((String)(pAppid + "_storages"));
    }

    private SharedPreferences getAppNStorage() {
        IWebview webview = WeexInstanceMgr.self().findWebview(this.mWXSDKInstance);
        if (webview != null) {
            String _appid = webview.obtainFrameView().obtainApp().obtainAppId();
            SharedPreferences bundle = this.mAllAppNStorages.get(_appid);
            if (bundle == null) {
                bundle = this.initAppNStorages(_appid);
                this.mAllAppNStorages.put(_appid, bundle);
            }
            return bundle;
        }
        return null;
    }
}

