/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio;

import android.content.Context;
import android.media.AudioManager;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;

@JNINamespace(value="liteav::audio")
public class AudioDeviceManager {
    private static final String TAG = "AudioDeviceManager";
    private AudioManager mAudioManager;

    @CalledByNative
    public AudioDeviceManager() {
    }

    @CalledByNative
    private int getAudioMode() {
        try {
            AudioManager audioManager = this.getAudioManager();
            if (audioManager != null) {
                return audioManager.getMode();
            }
        }
        catch (Exception exception) {
            Log.i(TAG, "Exception occurs in getAudioMode " + exception.getMessage(), new Object[0]);
        }
        return -1;
    }

    @CalledByNative
    private int getSystemVolume() {
        try {
            int n2 = this.getAudioMode() == 0 ? 3 : 0;
            AudioManager audioManager = this.getAudioManager();
            if (audioManager != null) {
                return audioManager.getStreamVolume(n2);
            }
        }
        catch (Exception exception) {
            Log.i(TAG, "Exception occurs in getSystemVolume " + exception.getMessage(), new Object[0]);
        }
        return -1;
    }

    @CalledByNative
    private int getStreamMaxVolume(int streamType) {
        int n2 = 0;
        AudioManager audioManager = this.getAudioManager();
        if (audioManager != null) {
            n2 = audioManager.getStreamMaxVolume(streamType);
        }
        return n2;
    }

    @CalledByNative
    private int getStreamVolume(int streamType) {
        int n2 = 0;
        AudioManager audioManager = this.getAudioManager();
        if (audioManager != null) {
            n2 = audioManager.getStreamVolume(streamType);
        }
        return n2;
    }

    @CalledByNative
    private void setStreamVolume(int streamType, int index, int flags) {
        AudioManager audioManager = this.getAudioManager();
        if (audioManager != null) {
            audioManager.setStreamVolume(streamType, index, flags);
        }
    }

    private synchronized AudioManager getAudioManager() {
        if (this.mAudioManager == null) {
            Context context = ContextUtils.getApplicationContext();
            this.mAudioManager = (AudioManager)context.getSystemService("audio");
        }
        return this.mAudioManager;
    }
}

