/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.CpuUsageMeasurer;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.a;
import com.tencent.liteav.base.util.t;

@JNINamespace(value="liteav")
public class SystemUtil {
    private static final String TAG = "SystemUtil";
    private static boolean mFirstTimeRun;
    private static final a<CpuUsageMeasurer> sCpuUsageMeasurer;

    public static int[] getProcessCPURate() {
        if (mFirstTimeRun) {
            mFirstTimeRun = false;
            sCpuUsageMeasurer.a();
            CpuUsageMeasurer.a();
            return new int[]{0, 0};
        }
        sCpuUsageMeasurer.a();
        return CpuUsageMeasurer.a();
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnectedOrConnecting();
    }

    @SuppressLint(value={"NewApi"})
    @CalledByNative
    public static Size getDisplaySize(Context context) {
        if (context == null) {
            context = ContextUtils.getApplicationContext();
        }
        try {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            if (windowManager != null) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                windowManager.getDefaultDisplay().getRealMetrics(displayMetrics);
                return new Size(displayMetrics.widthPixels, displayMetrics.heightPixels);
            }
        }
        catch (Exception exception) {
            LiteavLog.e(TAG, "get display size failed.", exception);
        }
        return new Size(720, 1280);
    }

    @SuppressLint(value={"NewApi"})
    public static int getDisplayRotation(Context context) {
        if (context == null) {
            context = ContextUtils.getApplicationContext();
        }
        try {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            if (windowManager != null) {
                return windowManager.getDefaultDisplay().getRotation();
            }
        }
        catch (Exception exception) {
            LiteavLog.e(TAG, "get display rotation failed.", exception);
        }
        return 0;
    }

    @SuppressLint(value={"NewApi"})
    @CalledByNative
    public static int getDisplayRotationDegree(Context context) {
        switch (SystemUtil.getDisplayRotation(context)) {
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    static {
        sCpuUsageMeasurer = new a(t.b());
    }
}

