/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.common;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;

public class TPNativeAudioAttributes {
    public static final int TP_NATIVE_CONTENT_UNKNOWN = 0;
    public static final int TP_NATIVE_CONTENT_SPEECH = 1;
    public static final int TP_NATIVE_CONTENT_MUSIC = 2;
    public static final int TP_NATIVE_CONTENT_MOVIE = 3;
    public static final int TP_NATIVE_CONTENT_SONIFICATION = 4;
    public static final int TP_NATIVE_USAGE_UNKNOWN = 0;
    public static final int TP_NATIVE_USAGE_MEDIA = 1;
    public static final int TP_NATIVE_USAGE_VOICE_COMMUNICATION = 2;
    public static final int TP_NATIVE_USAGE_VOICE_COMMUNICATION_SIGNALLING = 3;
    public static final int TP_NATIVE_USAGE_ALARM = 4;
    public static final int TP_NATIVE_USAGE_NOTIFICATION = 5;
    public static final int TP_NATIVE_USAGE_NOTIFICATION_RINGTONE = 6;
    public static final int TP_NATIVE_USAGE_NOTIFICATION_COMMUNICATION_REQUEST = 7;
    public static final int TP_NATIVE_USAGE_NOTIFICATION_COMMUNICATION_INSTANT = 8;
    public static final int TP_NATIVE_USAGE_NOTIFICATION_COMMUNICATION_DELAYED = 9;
    public static final int TP_NATIVE_USAGE_NOTIFICATION_EVENT = 10;
    public static final int TP_NATIVE_USAGE_ASSISTANCE_ACCESSIBILITY = 11;
    public static final int TP_NATIVE_USAGE_ASSISTANCE_NAVIGATION_GUIDANCE = 12;
    public static final int TP_NATIVE_USAGE_ASSISTANCE_SONIFICATION = 13;
    public static final int TP_NATIVE_USAGE_GAME = 14;
    public static final int TP_NATIVE_USAGE_ASSISTANT = 16;
    public static final int TP_NATIVE_FLAG_UNKNOWN = 0;
    public static final int TP_NATIVE_FLAG_AUDIBILITY_ENFORCED = 1;
    public static final int TP_NATIVE_FLAG_HW_AV_SYNC = 16;
    public static final int TP_NATIVE_FLAG_LOW_LATENCY = 256;
    public static final int TP_NATIVE_STREAM_UNKNOWN = -1;
    public static final int TP_NATIVE_STREAM_VOICE_CALL = 0;
    public static final int TP_NATIVE_STREAM_SYSTEM = 1;
    public static final int TP_NATIVE_STREAM_RING = 2;
    public static final int TP_NATIVE_STREAM_MUSIC = 3;
    public static final int TP_NATIVE_STREAM_ALARM = 4;
    public static final int TP_NATIVE_STREAM_NOTIFICATION = 5;
    public static final int TP_NATIVE_STREAM_DTMF = 8;
    private static final int TP_NATIVE_FLAG_PUBLIC = 273;
    private static final HashMap<Integer, String> mMapContentTypeToString = new HashMap<Integer, String>();
    private static final HashMap<Integer, String> mMapUsageToString;
    private int mUsage = 0;
    private int mContentType = 0;
    private int mFlags = 0;

    private TPNativeAudioAttributes() {
    }

    @TPNativeAudioAttributeUsage
    public int getUsage() {
        return this.mUsage;
    }

    @TPNativeAudioAttributeContentType
    public int getContentType() {
        return this.mContentType;
    }

    public int getFlags() {
        return this.mFlags & 0x111;
    }

    public String toString() {
        return "AudioAttributes: usage=" + TPNativeAudioAttributes.usageToString(this.mUsage) + " content=" + TPNativeAudioAttributes.contentTypeToString(this.mContentType) + " flags=0x" + Integer.toHexString(this.mFlags).toUpperCase();
    }

    public static String usageToString(@TPNativeAudioAttributeUsage int n2) {
        if (mMapUsageToString.containsKey(n2)) {
            return mMapUsageToString.get(n2);
        }
        return "unknown usage ".concat(String.valueOf(n2));
    }

    public static String contentTypeToString(@TPNativeAudioAttributeContentType int n2) {
        if (mMapContentTypeToString.containsKey(n2)) {
            return mMapContentTypeToString.get(n2);
        }
        return "unknown content type".concat(String.valueOf(n2));
    }

    static {
        mMapContentTypeToString.put(0, "TP_NATIVE_CONTENT_UNKNOWN");
        mMapContentTypeToString.put(1, "TP_NATIVE_CONTENT_SPEECH");
        mMapContentTypeToString.put(2, "TP_NATIVE_CONTENT_MUSIC");
        mMapContentTypeToString.put(3, "TP_NATIVE_CONTENT_MOVIE");
        mMapContentTypeToString.put(4, "TP_NATIVE_CONTENT_SONIFICATION");
        mMapUsageToString = new HashMap<Integer, String>();
        mMapUsageToString.put(0, "TP_NATIVE_USAGE_UNKNOWN");
        mMapUsageToString.put(1, "TP_NATIVE_USAGE_MEDIA");
        mMapUsageToString.put(2, "TP_NATIVE_USAGE_VOICE_COMMUNICATION");
        mMapUsageToString.put(3, "TP_NATIVE_USAGE_VOICE_COMMUNICATION_SIGNALLING");
        mMapUsageToString.put(4, "TP_NATIVE_USAGE_ALARM");
        mMapUsageToString.put(5, "TP_NATIVE_USAGE_NOTIFICATION");
        mMapUsageToString.put(6, "TP_NATIVE_USAGE_NOTIFICATION_RINGTONE");
        mMapUsageToString.put(7, "TP_NATIVE_USAGE_NOTIFICATION_COMMUNICATION_REQUEST");
        mMapUsageToString.put(8, "TP_NATIVE_USAGE_NOTIFICATION_COMMUNICATION_INSTANT");
        mMapUsageToString.put(9, "TP_NATIVE_USAGE_NOTIFICATION_COMMUNICATION_DELAYED");
        mMapUsageToString.put(10, "TP_NATIVE_USAGE_NOTIFICATION_EVENT");
        mMapUsageToString.put(11, "TP_NATIVE_USAGE_ASSISTANCE_ACCESSIBILITY");
        mMapUsageToString.put(12, "TP_NATIVE_USAGE_ASSISTANCE_NAVIGATION_GUIDANCE");
        mMapUsageToString.put(13, "TP_NATIVE_USAGE_ASSISTANCE_SONIFICATION");
        mMapUsageToString.put(14, "TP_NATIVE_USAGE_GAME");
        mMapUsageToString.put(16, "TP_NATIVE_USAGE_ASSISTANT");
    }

    @Target(value={ElementType.METHOD, ElementType.LOCAL_VARIABLE, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TPNativeAudioAttributeStreamType {
    }

    @Target(value={ElementType.METHOD, ElementType.LOCAL_VARIABLE, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TPNativeAudioAttributeFlag {
    }

    @Target(value={ElementType.METHOD, ElementType.LOCAL_VARIABLE, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TPNativeAudioAttributeUsage {
    }

    @Target(value={ElementType.METHOD, ElementType.LOCAL_VARIABLE, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TPNativeAudioAttributeContentType {
    }

    public static class Builder {
        private static final HashMap<Integer, Integer> mMapStreamTypeToContentType = new HashMap<Integer, Integer>();
        private static final HashMap<Integer, Integer> mMapStreamTypeToUsage;
        private int mUsage = 0;
        private int mContentType = 0;
        private int mFlags = 0;

        public TPNativeAudioAttributes build() {
            TPNativeAudioAttributes tPNativeAudioAttributes = new TPNativeAudioAttributes();
            tPNativeAudioAttributes.mContentType = this.mContentType;
            tPNativeAudioAttributes.mUsage = this.mUsage;
            tPNativeAudioAttributes.mFlags = this.mFlags;
            return tPNativeAudioAttributes;
        }

        public Builder setUsage(@TPNativeAudioAttributeUsage int n2) {
            this.mUsage = mMapUsageToString.containsKey(n2) ? n2 : 0;
            return this;
        }

        public Builder setContentType(@TPNativeAudioAttributeContentType int n2) {
            this.mContentType = mMapContentTypeToString.containsKey(n2) ? n2 : 0;
            return this;
        }

        public Builder addFlags(int n2) {
            this.mFlags |= (n2 &= 0x111);
            return this;
        }

        public Builder setFlags(int n2) {
            this.mFlags = n2 &= 0x111;
            return this;
        }

        public Builder setLegacyStreamType(@TPNativeAudioAttributeStreamType int n2) {
            this.mContentType = mMapStreamTypeToContentType.containsKey(n2) ? mMapStreamTypeToContentType.get(n2) : 0;
            this.mUsage = mMapStreamTypeToUsage.containsKey(n2) ? mMapStreamTypeToUsage.get(n2) : 0;
            return this;
        }

        static {
            mMapStreamTypeToContentType.put(-1, 0);
            mMapStreamTypeToContentType.put(0, 1);
            mMapStreamTypeToContentType.put(1, 4);
            mMapStreamTypeToContentType.put(2, 4);
            mMapStreamTypeToContentType.put(3, 2);
            mMapStreamTypeToContentType.put(4, 4);
            mMapStreamTypeToContentType.put(5, 4);
            mMapStreamTypeToContentType.put(8, 4);
            mMapStreamTypeToUsage = new HashMap<Integer, Integer>();
            mMapStreamTypeToUsage.put(-1, 0);
            mMapStreamTypeToUsage.put(0, 2);
            mMapStreamTypeToUsage.put(1, 13);
            mMapStreamTypeToUsage.put(2, 6);
            mMapStreamTypeToUsage.put(3, 1);
            mMapStreamTypeToUsage.put(4, 4);
            mMapStreamTypeToUsage.put(5, 5);
            mMapStreamTypeToUsage.put(8, 3);
        }
    }
}

