/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.midifile;

import com.jinmingyunle.midiplaylib.midifile.MidiFileException;
import java.io.UnsupportedEncodingException;

public class MidiFileReader {
    private byte[] data;
    private int parse_offset;
    private static final String TAG = "MidiFileReaderTAG";

    public MidiFileReader(byte[] bytes) {
        this.data = bytes;
        this.parse_offset = 0;
    }

    private void checkRead(int amount) {
        if (this.parse_offset + amount > this.data.length) {
            throw new MidiFileException("File is truncated", this.parse_offset);
        }
    }

    public byte Peek() {
        this.checkRead(1);
        return this.data[this.parse_offset];
    }

    public byte ReadByte() {
        this.checkRead(1);
        byte x = this.data[this.parse_offset];
        ++this.parse_offset;
        return x;
    }

    public byte[] ReadBytes(int amount) {
        this.checkRead(amount);
        byte[] result = new byte[amount];
        for (int i = 0; i < amount; ++i) {
            result[i] = this.data[i + this.parse_offset];
        }
        this.parse_offset += amount;
        return result;
    }

    public int ReadShort() {
        this.checkRead(2);
        int x = (this.data[this.parse_offset] & 0xFF) << 8 | this.data[this.parse_offset + 1] & 0xFF;
        this.parse_offset += 2;
        return x;
    }

    public int ReadInt() {
        this.checkRead(4);
        int x = (this.data[this.parse_offset] & 0xFF) << 24 | (this.data[this.parse_offset + 1] & 0xFF) << 16 | (this.data[this.parse_offset + 2] & 0xFF) << 8 | this.data[this.parse_offset + 3] & 0xFF;
        this.parse_offset += 4;
        return x;
    }

    public String ReadAscii(int len) {
        this.checkRead(len);
        String s = "";
        try {
            s = new String(this.data, this.parse_offset, len, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            s = new String(this.data, this.parse_offset, len);
        }
        this.parse_offset += len;
        return s;
    }

    public int ReadVarlen() {
        int result = 0;
        byte b = this.ReadByte();
        result = b & 0x7F;
        for (int i = 0; i < 3 && (b & 0x80) != 0; ++i) {
            b = this.ReadByte();
            result = (result << 7) + (b & 0x7F);
        }
        return result;
    }

    public void Skip(int amount) {
        this.checkRead(amount);
        this.parse_offset += amount;
    }

    public int GetOffset() {
        return this.parse_offset;
    }

    public byte[] GetData() {
        return this.data;
    }
}

