/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.api.stream;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.graphics.drawable.LayerDrawable;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.IBinder;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import cn.rongcloud.rtc.api.RCRTCEngine;
import cn.rongcloud.rtc.center.stream.RCScreenShareOutputStreamImpl;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.utils.ReportUtil;

@RequiresApi(value=26)
public class RCRTCScreenShareService
extends Service {
    private static final String TAG = "RCRTCScreenShareService";
    private static final String DEFAULT_CHANNEL_NAME = "ScreenShare";
    private static final String DEFAULT_CHANNEL_ID = "ScreenShareID";

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        try {
            this.createChannelAndShowNotification();
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"onCreate: ", (Throwable)e);
        }
    }

    private void createChannelAndShowNotification() {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
            NotificationChannel notificationChannel = new NotificationChannel(this.getChannelId(), (CharSequence)this.getChannelName(), 3);
            notificationChannel.enableLights(false);
            notificationChannel.enableVibration(false);
            notificationChannel.setLockscreenVisibility(0);
            notificationManager.createNotificationChannel(notificationChannel);
        }
        Notification.Builder builder = new Notification.Builder(this.getApplicationContext(), this.getChannelId()).setContentText((CharSequence)this.getContentText()).setContentTitle((CharSequence)this.getContentTitle()).setOngoing(true).setWhen(System.currentTimeMillis());
        int icon = this.getIcon();
        if (icon > 0) {
            builder.setSmallIcon(icon);
        } else {
            Bitmap iconBitmap = this.getAppIcon(this.getApplicationContext());
            if (iconBitmap != null) {
                builder.setSmallIcon(Icon.createWithAdaptiveBitmap((Bitmap)iconBitmap));
            } else {
                ReportUtil.libError(ReportUtil.TAG.START_AUDIO_CAPTURE, "desc", "can not get app icon");
            }
        }
        Notification notification = builder.build();
        notification.defaults = -1;
        if (Build.VERSION.SDK_INT >= 29) {
            this.startForeground(3, notification, 32);
        } else {
            this.startForeground(3, notification);
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null) {
            return 2;
        }
        Intent data = (Intent)intent.getParcelableExtra("data");
        int code = intent.getIntExtra("code", -1);
        this.startScreenCapture(data, code);
        return 2;
    }

    private void startScreenCapture(Intent data, int code) {
        MediaProjectionManager mediaProjectionManager = (MediaProjectionManager)this.getApplicationContext().getSystemService("media_projection");
        MediaProjection mediaProjection = mediaProjectionManager.getMediaProjection(code, data);
        RCScreenShareOutputStreamImpl screenShareOutputStream = (RCScreenShareOutputStreamImpl)((RTCEngineImpl)RCRTCEngine.getInstance()).getScreenShareVideoStream();
        if (screenShareOutputStream == null) {
            ReportUtil.libError(ReportUtil.TAG.SCREEN_CAPTURE_CONFIG, "des", "screenShareOutputStream is null in service");
            return;
        }
        if (mediaProjection == null) {
            screenShareOutputStream.setScreenCaptureResult(false, null);
        } else {
            screenShareOutputStream.setScreenCaptureResult(true, mediaProjection);
        }
    }

    public void onDestroy() {
        this.stopForeground(true);
        this.stopSelf();
        super.onDestroy();
    }

    private String getChannelId() {
        return DEFAULT_CHANNEL_ID;
    }

    private String getChannelName() {
        int id = this.getResources().getIdentifier("rc_screen_share_channel_name", "string", this.getPackageName());
        return id <= 0 ? DEFAULT_CHANNEL_NAME : this.getString(id);
    }

    private String getContentText() {
        int id = this.getResources().getIdentifier("rc_screen_share_notification_text", "string", this.getPackageName());
        return id <= 0 ? "\u5c4f\u5e55\u5171\u4eab\u4e2d..." : this.getString(id);
    }

    private String getContentTitle() {
        int id = this.getResources().getIdentifier("rc_screen_share_notification_title", "string", this.getPackageName());
        if (id > 0) {
            return this.getString(id);
        }
        if (!TextUtils.isEmpty((CharSequence)this.getString(this.getApplicationInfo().labelRes))) {
            return this.getString(this.getApplicationInfo().labelRes);
        }
        if (!TextUtils.isEmpty((CharSequence)RCRTCScreenShareService.getAppName(this.getApplicationContext()))) {
            return RCRTCScreenShareService.getAppName(this.getApplicationContext());
        }
        return null;
    }

    @DrawableRes
    private int getIcon() {
        int id = this.getResources().getIdentifier("rc_screen_share_notification_icon", "drawable", this.getPackageName());
        return id <= 0 ? this.getApplicationInfo().icon : id;
    }

    public Bitmap getAppIcon(Context context) {
        block6: {
            if (context == null) {
                return null;
            }
            try {
                PackageManager packageManager = context.getApplicationContext().getPackageManager();
                String packageName = context.getApplicationContext().getPackageName();
                Drawable drawable = packageManager.getApplicationIcon(packageName);
                if (Build.VERSION.SDK_INT >= 26) {
                    if (drawable instanceof BitmapDrawable) {
                        return ((BitmapDrawable)drawable).getBitmap();
                    }
                    if (drawable instanceof AdaptiveIconDrawable) {
                        Drawable[] drr = new Drawable[]{((AdaptiveIconDrawable)drawable).getBackground(), ((AdaptiveIconDrawable)drawable).getForeground()};
                        LayerDrawable layerDrawable = new LayerDrawable(drr);
                        int width = layerDrawable.getIntrinsicWidth();
                        int height = layerDrawable.getIntrinsicHeight();
                        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        Canvas canvas = new Canvas(bitmap);
                        layerDrawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                        layerDrawable.draw(canvas);
                        return bitmap;
                    }
                    break block6;
                }
                return ((BitmapDrawable)drawable).getBitmap();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static synchronized String getAppName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            int labelRes = packageInfo.applicationInfo.labelRes;
            return context.getResources().getString(labelRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

