/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.stream;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import android.view.WindowManager;
import androidx.annotation.RequiresApi;
import cn.rongcloud.rtc.api.RCRTCAudioMixer;
import cn.rongcloud.rtc.api.RCRTCEngine;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.stream.RCRTCScreenShareActivity;
import cn.rongcloud.rtc.api.stream.RCRTCScreenShareAudioConfig;
import cn.rongcloud.rtc.api.stream.RCRTCScreenShareOutputStream;
import cn.rongcloud.rtc.api.stream.RCRTCScreenShareService;
import cn.rongcloud.rtc.api.stream.RCRTCSurfaceTextureHelper;
import cn.rongcloud.rtc.api.stream.RCRTCVideoStreamConfig;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCRect;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.config.RCRTCConfigImpl;
import cn.rongcloud.rtc.center.stream.RCDefaultStream;
import cn.rongcloud.rtc.center.stream.RCScreenShareAudioConfigImpl;
import cn.rongcloud.rtc.center.stream.RCVideoOutStreamImpl;
import cn.rongcloud.rtc.core.ThreadUtils;
import cn.rongcloud.rtc.core.audio.OnAudioBufferAvailableListener;
import cn.rongcloud.rtc.core.audio.ScreenShareAudioRecord;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

@RequiresApi(api=21)
public class RCScreenShareOutputStreamImpl
extends RCVideoOutStreamImpl
implements RCRTCScreenShareOutputStream,
RCDefaultStream {
    private static final String SCREEN_TAG = "RongCloudScreenShare";
    private static final int DISPLAY_FLAGS = 3;
    private static final int VIRTUAL_DISPLAY_DPI = 400;
    private final Context context;
    private final RCRTCConfigImpl rtcConfig;
    private MediaProjection mediaProjection;
    private IRCRTCResultCallback startScreenShareCallback;
    private VirtualDisplay mVirtualDisplay;
    private boolean isCapturing = false;
    private int lastOrientation = 0;
    private final RCRTCSurfaceTextureHelper.Sink screenFrameSink = new RCRTCSurfaceTextureHelper.Sink(){

        @Override
        public void onTexture(int textureWidth, int textureHeight, int oexTextureId, float[] transformMatrix, int rotation, long timestampNs) {
            if (RCScreenShareOutputStreamImpl.this.lastOrientation == RCScreenShareOutputStreamImpl.this.getDeviceOrientation() || RCScreenShareOutputStreamImpl.this.lastOrientation % 180 == RCScreenShareOutputStreamImpl.this.getDeviceOrientation() % 180) {
                RCScreenShareOutputStreamImpl.this.writeTexture(textureWidth, textureHeight, oexTextureId, transformMatrix, rotation, timestampNs);
            } else {
                RCScreenShareOutputStreamImpl.this.lastOrientation = RCScreenShareOutputStreamImpl.this.getDeviceOrientation();
                ThreadUtils.invokeAtFrontUninterruptibly(RCScreenShareOutputStreamImpl.this.getTextureHelper().getHandler(), new Runnable(){

                    @Override
                    @RequiresApi(api=21)
                    public void run() {
                        RCScreenShareOutputStreamImpl.this.mVirtualDisplay.release();
                        if (RCScreenShareOutputStreamImpl.this.lastOrientation % 180 == 0) {
                            RCScreenShareOutputStreamImpl.this.mVirtualDisplay = RCScreenShareOutputStreamImpl.this.createVirtualDisplay(RCScreenShareOutputStreamImpl.this.getWidth(), RCScreenShareOutputStreamImpl.this.getHeight());
                        } else {
                            RCScreenShareOutputStreamImpl.this.mVirtualDisplay = RCScreenShareOutputStreamImpl.this.createVirtualDisplay(RCScreenShareOutputStreamImpl.this.getHeight(), RCScreenShareOutputStreamImpl.this.getWidth());
                        }
                    }
                });
            }
        }
    };
    private RCRTCScreenShareAudioConfig audioStreamConfig;
    private ScreenShareAudioRecord audioRecord;
    private volatile float audioVolume = 0.5f;
    private byte[] audioData = null;

    public RCScreenShareOutputStreamImpl(String userId, Context context, RCRTCConfigImpl audioConfig) {
        super(SCREEN_TAG, userId);
        this.context = context;
        RCRTCVideoStreamConfig.Builder configBuilder = RCRTCVideoStreamConfig.Builder.create();
        configBuilder.setVideoResolution(RCRTCParamsType.RCRTCVideoResolution.RESOLUTION_720_960);
        configBuilder.setVideoFps(RCRTCParamsType.RCRTCVideoFps.Fps_15);
        this.rtcConfig = audioConfig;
        super.setVideoConfig(configBuilder.build());
    }

    @Override
    public synchronized void startCaptureScreen(IRCRTCResultCallback callback) {
        ReportUtil.appTask(ReportUtil.TAG.START_SCREEN_CAPTURE, "streamId", this.getStreamId());
        if (this.isCapturing) {
            ReportUtil.appError(ReportUtil.TAG.START_SCREEN_CAPTURE, "already capturing", this.getStreamId());
            if (callback != null) {
                callback.onFailed(RTCErrorCode.SCREEN_SHARE_ALREADY_CAPTURE);
            }
            return;
        }
        this.isCapturing = true;
        this.startScreenShareCallback = callback;
        this.startScreenCapture();
    }

    @Override
    public void setVideoConfig(RCRTCVideoStreamConfig config) {
        super.setVideoConfig(config);
    }

    @Override
    @RequiresApi(api=29)
    public synchronized void startCaptureAudio(RCRTCScreenShareAudioConfig config, IRCRTCResultCallback callback) {
        if (!(config instanceof RCScreenShareAudioConfigImpl)) {
            ReportUtil.appError(ReportUtil.TAG.START_AUDIO_CAPTURE, "desc", "config is null or error type");
            callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            return;
        }
        if (Build.VERSION.SDK_INT < 29) {
            ReportUtil.appError(ReportUtil.TAG.START_AUDIO_CAPTURE, "desc", "current device not support capture audio");
            callback.onFailed(RTCErrorCode.OS_NOT_SUPPORT_FUNCTION);
            return;
        }
        if (!this.isCapturing || this.mediaProjection == null) {
            ReportUtil.appError(ReportUtil.TAG.START_AUDIO_CAPTURE, "desc", "please start screen capture first");
            callback.onFailed(RTCErrorCode.START_SCREEN_CAPTURE_FIRST);
            return;
        }
        if (((RCScreenShareAudioConfigImpl)config).getAudioUsageSet().isEmpty() && ((RCScreenShareAudioConfigImpl)config).getAudioUidSet().isEmpty()) {
            ReportUtil.appError(ReportUtil.TAG.START_AUDIO_CAPTURE, "desc", "Unknown mixing rule type");
            callback.onFailed(RTCErrorCode.START_SCREEN_CAPTURE_FIRST);
            return;
        }
        if (this.audioRecord != null) {
            this.audioRecord.stopRecord();
        }
        this.audioStreamConfig = config;
        ReportUtil.appOperate(ReportUtil.TAG.START_AUDIO_CAPTURE, "config", config.toString());
        this.startRecordAudioInternal(callback);
    }

    @Override
    public void stopCaptureAudio() {
        ReportUtil.appTask(ReportUtil.TAG.STOP_AUDIO_CAPTURE, "", "");
        this.audioStreamConfig = null;
        if (Build.VERSION.SDK_INT >= 29 && this.audioRecord != null) {
            this.audioRecord.stopRecord();
            this.audioRecord = null;
            RCRTCAudioMixer.getInstance().stopWrite();
        }
    }

    @Override
    public void setCaptureAudioVolume(int volume) {
        this.audioVolume = (float)Math.max(0.0, Math.min(1.0, (double)volume / 100.0));
    }

    @Override
    public void stopCaptureScreen() {
        ReportUtil.appOperate(ReportUtil.TAG.STOP_SCREEN_CAPTURE, "streamId", this.getStreamId());
        this.isCapturing = false;
        this.dispose();
    }

    @Override
    public void resetStream() {
        this.dispose();
    }

    private void dispose() {
        if (this.mVirtualDisplay != null) {
            this.mVirtualDisplay.release();
            this.mVirtualDisplay = null;
        }
        if (this.mediaProjection != null) {
            this.mediaProjection.stop();
            this.mediaProjection = null;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            Intent intent = new Intent(this.context, RCRTCScreenShareService.class);
            this.context.stopService(intent);
        }
        this.stopCaptureAudio();
        ((RTCEngineImpl)RCRTCEngine.getInstance()).getHandler().post(new Runnable(){

            @Override
            public void run() {
                RCRTCSurfaceTextureHelper textureHelper = RCScreenShareOutputStreamImpl.this.getTextureHelper();
                if (textureHelper != null) {
                    textureHelper.stopListening();
                }
            }
        });
    }

    public void setMediaProjection(MediaProjection mediaProjection) {
        this.mediaProjection = mediaProjection;
    }

    private void startScreenCapture() {
        Intent intent = new Intent(this.context, RCRTCScreenShareActivity.class);
        intent.setFlags(0x10000000);
        this.context.startActivity(intent);
    }

    private int getDeviceOrientation() {
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        switch (wm.getDefaultDisplay().getRotation()) {
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public void setScreenCaptureResult(boolean success, MediaProjection mediaProjection) {
        ReportUtil.libStatus(ReportUtil.TAG.START_SCREEN_CAPTURE, "permission", success);
        if (!success) {
            if (this.startScreenShareCallback != null) {
                this.startScreenShareCallback.onFailed(RTCErrorCode.SCREEN_SHARE_NO_PERMISSION_ERROR);
                ReportUtil.appError(ReportUtil.TAG.START_SCREEN_CAPTURE, "streamId", this.streamId);
                this.isCapturing = false;
            }
        } else {
            this.mediaProjection = mediaProjection;
            ((RTCEngineImpl)RCRTCEngine.getInstance()).getHandler().post(new Runnable(){

                @Override
                public void run() {
                    Log.d((String)RCScreenShareOutputStreamImpl.SCREEN_TAG, (String)"run: startListening");
                    RCScreenShareOutputStreamImpl.this.getTextureHelper().startListening(RCScreenShareOutputStreamImpl.this.screenFrameSink);
                }
            });
            this.captureScreen();
            ReportUtil.appRes(ReportUtil.TAG.START_SCREEN_CAPTURE, "streamId", this.streamId);
            if (this.startScreenShareCallback != null) {
                this.startScreenShareCallback.onSuccess();
            }
        }
    }

    @RequiresApi(api=29)
    private void startRecordAudioInternal(IRCRTCResultCallback callback) {
        ReportUtil.libTask(ReportUtil.TAG.START_AUDIO_CAPTURE, "desc", "start audio capture");
        RCRTCAudioMixer.getInstance().startWrite();
        RCRTCAudioMixer.getInstance().setPlayback(false);
        this.initAudioRecord();
        callback.onSuccess();
    }

    @RequiresApi(api=29)
    private void initAudioRecord() {
        ReportUtil.libTask(ReportUtil.TAG.START_AUDIO_CAPTURE, "desc", "init audio record");
        this.audioRecord = new ScreenShareAudioRecord(this.context, (RCScreenShareAudioConfigImpl)this.audioStreamConfig, this.rtcConfig, this.mediaProjection, new OnAudioBufferAvailableListener(){

            @Override
            public void onAudioBuffer(ByteBuffer byteBuffer, int sizeInBytes, int sampleRate, int channelCount, int audioFormat) {
                byteBuffer.rewind();
                ShortBuffer shortBuffer = byteBuffer.order(ByteOrder.nativeOrder()).asShortBuffer();
                for (int i = 0; i < shortBuffer.capacity(); ++i) {
                    shortBuffer.put(i, (short)Math.max(-32768.0f, Math.min(32767.0f, (float)shortBuffer.get(i) * RCScreenShareOutputStreamImpl.this.audioVolume)));
                }
                if (RCScreenShareOutputStreamImpl.this.audioData == null || RCScreenShareOutputStreamImpl.this.audioData.length != byteBuffer.capacity()) {
                    RCScreenShareOutputStreamImpl.access$602(RCScreenShareOutputStreamImpl.this, new byte[byteBuffer.capacity()]);
                }
                byteBuffer.rewind();
                byteBuffer.get(RCScreenShareOutputStreamImpl.this.audioData);
                RCRTCAudioMixer.getInstance().write(RCScreenShareOutputStreamImpl.this.audioData, sampleRate, channelCount, audioFormat, 100, RCRTCAudioMixer.Mode.MIX);
            }
        });
        this.audioRecord.startRecord();
    }

    private void captureScreen() {
        this.lastOrientation = this.getDeviceOrientation();
        this.mVirtualDisplay = this.lastOrientation % 180 == 0 ? this.createVirtualDisplay(this.getWidth(), this.getHeight()) : this.createVirtualDisplay(this.getHeight(), this.getWidth());
    }

    private VirtualDisplay createVirtualDisplay(int width, int height) {
        this.getTextureHelper().setTextureSize(width, height);
        return this.mediaProjection.createVirtualDisplay(SCREEN_TAG, width, height, 400, 3, new Surface(this.getTextureHelper().getSurfaceTexture()), null, null);
    }

    @Override
    public boolean setWatermark(Bitmap logoIcon, RCRTCRect rect) {
        return super.setWatermark(logoIcon, rect);
    }

    static /* synthetic */ byte[] access$602(RCScreenShareOutputStreamImpl x0, byte[] x1) {
        x0.audioData = x1;
        return x1;
    }
}

