/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.downloader;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Pair;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.txcvodplayer.b.c;
import com.tencent.rtmp.TXPlayInfoParams;
import com.tencent.rtmp.downloader.ITXVodFilePreloadListener;
import com.tencent.rtmp.downloader.ITXVodPreloadListener;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPDownloadProxy;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPPreLoadListener;
import com.tencent.thumbplayer.core.downloadproxy.api.TPDLProxyInitParam;
import com.tencent.thumbplayer.core.downloadproxy.api.TPDownloadParam;
import com.tencent.thumbplayer.core.downloadproxy.api.TPDownloadProxyFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;

public class TXVodPreloadManager {
    private static final String TAG = "TXVodPreloadManager";
    private static final String THUMB_PLAYER_GUID = "liteav_tbplayer_android_";
    private static final int THUMB_PLAYER_PLATFORM_ID = 2330303;
    private ITPDownloadProxy mTpDownloadProxy;
    private boolean mInit = false;
    private static Context mAppContext;

    private TXVodPreloadManager() {
    }

    public static TXVodPreloadManager getInstance(Context context) {
        if (context != null) {
            mAppContext = context.getApplicationContext();
            ContextUtils.initApplicationContext(mAppContext);
            ContextUtils.setDataDirectorySuffix("liteav");
            return a.a;
        }
        return null;
    }

    private synchronized Pair<Integer, String> checkInit() {
        this.mTpDownloadProxy = TPDownloadProxyFactory.getTPDownloadProxy(2330303);
        if (this.mTpDownloadProxy != null) {
            int n2 = com.tencent.liteav.txcplayer.common.b.b();
            if (n2 < 0) {
                return new Pair((Object)-1, (Object)"MaxCacheSize not set.");
            }
            String string = com.tencent.liteav.txcplayer.common.b.a();
            if (TextUtils.equals((CharSequence)string, (CharSequence)"NO_SET")) {
                return new Pair((Object)-2, (Object)"CacheFolderPath not set.");
            }
            if (!this.mInit) {
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("VodCacheReserveSizeMB", n2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                TPDLProxyInitParam tPDLProxyInitParam = new TPDLProxyInitParam(2330303, "1.0.0", THUMB_PLAYER_GUID + mAppContext.getPackageName(), null, string, jSONObject.toString());
                this.mTpDownloadProxy.init(mAppContext, tPDLProxyInitParam);
                this.mInit = true;
            }
            this.mTpDownloadProxy.updateStoragePath(string);
            this.mTpDownloadProxy.setMaxStorageSizeMB(n2);
            return new Pair((Object)0, null);
        }
        return new Pair((Object)-3, (Object)"Inner error.");
    }

    public int startPreload(String url, float preloadSizeMB, long preferredResolution, ITXVodPreloadListener listener) {
        return this.startPreload(url, preloadSizeMB, preferredResolution, listener, 0);
    }

    private int startPreload(String url, float preloadSizeMB, long preferredResolution, ITXVodPreloadListener listener, int dlType) {
        int n2;
        Pair<Integer, String> pair = this.checkInit();
        if ((Integer)pair.first < 0) {
            if (listener != null) {
                listener.onError(-1, url, (Integer)pair.first, (String)pair.second);
            }
            return -1;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(url);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("dl_param_preload_size", (long)(preloadSizeMB * 1024.0f * 1024.0f));
        hashMap.put("dl_param_preferred_resolution", preferredResolution);
        TPDownloadParam tPDownloadParam = new TPDownloadParam(arrayList, dlType, hashMap);
        b b2 = new b(this.mTpDownloadProxy, url, listener);
        b2.a = n2 = this.mTpDownloadProxy.startPreload(com.tencent.liteav.txcplayer.a.a.d(url), tPDownloadParam, b2);
        return n2;
    }

    private int checkDlType(int mediaType) {
        switch (mediaType) {
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 10;
            }
            case 4: {
                return 19;
            }
        }
        return 0;
    }

    public int startPreload(final TXPlayInfoParams playInfoParams, final float preloadSizeMB, final long preferredResolution, final ITXVodFilePreloadListener listener) throws RuntimeException {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("startPreload for TXPlayInfoParams can not be called on the main thread.");
        }
        Pair<Integer, String> pair = this.checkInit();
        if ((Integer)pair.first < 0) {
            if (listener != null) {
                listener.onError(-1, "", (Integer)pair.first, (String)pair.second);
            }
            return -1;
        }
        if (playInfoParams != null && !TextUtils.isEmpty((CharSequence)playInfoParams.getUrl()) && TextUtils.isEmpty((CharSequence)playInfoParams.getFileId())) {
            return this.startPreload(playInfoParams.getUrl(), preloadSizeMB, preferredResolution, listener, this.checkDlType(playInfoParams.getMediaType()));
        }
        if (playInfoParams == null || playInfoParams.getAppId() == 0 || TextUtils.isEmpty((CharSequence)playInfoParams.getFileId())) {
            if (listener != null) {
                listener.onError(-1, "", -1, " invalid params, appId or fileId is null");
            }
            return -1;
        }
        final AtomicInteger atomicInteger = new AtomicInteger(-1);
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        new c(playInfoParams).a(new c.a(){

            @Override
            public final void a(c c2, TXPlayInfoParams tXPlayInfoParams) {
                int n2;
                Object object;
                ArrayList<String> arrayList;
                List<c.d> list;
                Object object2;
                String string = c2.a();
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    string = com.tencent.liteav.txcplayer.a.a.a(string, c2.c());
                    object2 = c2.k();
                    if (TextUtils.isEmpty((CharSequence)object2)) {
                        object2 = "plain";
                    }
                    string = com.tencent.liteav.txcplayer.a.a.a(string, tXPlayInfoParams.getFileId(), (String)object2, tXPlayInfoParams.getAppId());
                }
                object2 = new Bundle();
                object2.putString("EVT_PLAY_URL", string);
                object2.putString("EVT_PLAY_COVER_URL", c2.b());
                object2.putString("EVT_PLAY_NAME", c2.d());
                object2.putString("EVT_PLAY_DESCRIPTION", c2.e());
                object2.putInt("EVT_PLAY_DURATION", c2.f());
                c.c c3 = c2.h();
                if (c3 != null) {
                    object2.putString("EVT_IMAGESPRIT_WEBVTTURL", c3.b);
                    object2.putStringArrayList("EVT_IMAGESPRIT_IMAGEURL_LIST", c3.a);
                }
                if ((list = c2.i()) != null && !list.isEmpty()) {
                    arrayList = new ArrayList<String>();
                    object = new float[list.size()];
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        arrayList.add(list.get((int)i2).a);
                        object[i2] = list.get((int)i2).b;
                    }
                    object2.putStringArrayList("EVT_KEY_FRAME_CONTENT_LIST", arrayList);
                    object2.putFloatArray("EVT_KEY_FRAME_TIME_LIST", (float[])object);
                }
                object2.putString("EVT_DRM_TYPE", c2.k());
                arrayList = new ArrayList<String>();
                arrayList.add(string);
                HashMap<String, Float> hashMap = new HashMap<String, Float>();
                object = hashMap;
                hashMap.put("dl_param_preload_size", Float.valueOf(preloadSizeMB * 1024.0f * 1024.0f));
                object.put("dl_param_preferred_resolution", preferredResolution);
                TPDownloadParam tPDownloadParam = new TPDownloadParam(arrayList, TXVodPreloadManager.this.checkDlType(playInfoParams.getMediaType()), (Map<String, Object>)object);
                b b2 = new b(TXVodPreloadManager.this.mTpDownloadProxy, string, listener);
                b2.a = n2 = TXVodPreloadManager.this.mTpDownloadProxy.startPreload(com.tencent.liteav.txcplayer.a.a.d(string), tPDownloadParam, b2);
                atomicInteger.set(n2);
                countDownLatch.countDown();
                if (listener != null) {
                    listener.onStart(n2, tXPlayInfoParams.getFileId(), string, (Bundle)object2);
                }
            }

            @Override
            public final void a(int n2, String string) {
                countDownLatch.countDown();
                if (listener != null) {
                    listener.onError(-1, "", n2, "getPlayInfo failed: ".concat(String.valueOf(string)));
                }
            }
        });
        try {
            countDownLatch.await(8L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return atomicInteger.get();
    }

    public void stopPreload(int taskID) {
        if ((Integer)this.checkInit().first < 0) {
            return;
        }
        this.mTpDownloadProxy.stopPreload(taskID);
    }

    static final class b
    implements ITPPreLoadListener {
        private final ITXVodPreloadListener b;
        private final String c;
        int a = -1;
        private ITPDownloadProxy d;

        public b(ITPDownloadProxy iTPDownloadProxy, String string, ITXVodPreloadListener iTXVodPreloadListener) {
            this.c = string;
            this.b = iTXVodPreloadListener;
            this.d = iTPDownloadProxy;
        }

        @Override
        public final void onPrepareOK() {
            LiteavLog.d(TXVodPreloadManager.TAG, "preload: onPrepareOK");
            if (this.b != null) {
                this.b.onComplete(this.a, this.c);
            }
            b b2 = this;
            b2.a(b2.a);
        }

        @Override
        public final void onPrepareError(int moduleId, int errorCode, String extInfo) {
            LiteavLog.e(TXVodPreloadManager.TAG, "preload error: moduleId: " + moduleId + ", errorCode: " + errorCode + ", extInfo: " + extInfo);
            if (this.b != null) {
                this.b.onError(this.a, this.c, errorCode, extInfo);
            }
            b b2 = this;
            b2.a(b2.a);
        }

        @Override
        public final void onPrepareDownloadProgressUpdate(int playableDurationMs, int downloadSpeedKbytes, long currentDownloadSizeByte, long totalFileSizeByte, String exInfo) {
            LiteavLog.i(TXVodPreloadManager.TAG, "preload: prepare process:" + playableDurationMs + "," + downloadSpeedKbytes + "," + currentDownloadSizeByte + "," + totalFileSizeByte);
        }

        private void a(int n2) {
            if (this.d != null) {
                this.d.stopPreload(n2);
            }
        }
    }

    static final class a {
        static TXVodPreloadManager a = new TXVodPreloadManager();
    }
}

