/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.downloadproxy.apiinner;

import android.net.Network;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPDownloadListener;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPOfflineDownloadListener;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPPlayListener;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPPreLoadListener;
import com.tencent.thumbplayer.core.downloadproxy.jni.TPDownloadProxyNative;
import com.tencent.thumbplayer.core.downloadproxy.utils.TPCGIRequester;
import com.tencent.thumbplayer.core.downloadproxy.utils.TPDLProxyLog;
import com.tencent.thumbplayer.core.downloadproxy.utils.TPDLProxyUtils;
import com.tencent.thumbplayer.core.downloadproxy.utils.TVKThreadUtil;
import java.io.FileDescriptor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TPListenerManager {
    private static final String FILE_NAME = "TPListenerManager";
    private static final String THREAD_NAME = "TVKDL-Listener";
    private static final int MSG_PROGRESS = 2;
    private static final int MSG_FINISH = 3;
    private static final int MSG_ERROR = 4;
    private static final int MSG_CURRENT_CDN_URL = 5;
    private static final int MSG_CURRENT_CDN_URL_INFO = 6;
    private static final int MSG_URL_EXPIRED = 7;
    private static final int MSG_DOWNLOAD_STATUS = 8;
    private static final int MSG_DOWNLOAD_PROTOCOL = 9;
    private static final int MSG_PREPARE_FINISH = 50;
    private static final int MSG_PLAY_VIDEO_NOT_FOUND = 101;
    private static final int MSG_PROXY_START_READ_DATA = 200;
    private static final int MSG_PROXY_READ_DATA = 201;
    private static final int MSG_PROXY_CANCEL_READ_DATA = 202;
    private static final int MSG_PROXY_GET_DATA_TOTAL_SIZE = 203;
    private static final int MSG_PROXY_GET_DATA_FILE_PATH = 204;
    private static final int MSG_PROXY_GET_CONTENT_TYPE = 205;
    private static final int MSG_NOTIFY_PLAYER_SWITCH_DEFINITION = 2003;
    private static final int MSG_NOTIFY_LOSE_PACKAGE_CEHCK = 2004;
    private static final int MSG_NOTIFY_HTTP_HEADER = 2006;
    private static final int MSG_NOTIFY_M3U8_CONTENT = 2007;
    private static final int MSG_NOTIFY_SOCKET_FD = 2008;
    private static final int MSG_NOTIFY_FLV_PRELOAD_STATUS = 2009;
    private static final int MSG_REPORT_URL = 2010;
    private static final int MSG_CONFIG_URL = 2011;
    private static final int MSG_WUJI_CONFIG_URL = 2013;
    private static final int MSG_TAB_TESTID = 2014;
    private static final int MSG_WILL_RELEASE_MEMORY = 2015;
    private static final int MSG_DID_RELEASE_MEMORY = 2016;
    private static final int MSG_M3U8_REFRESH = 2017;
    private static final int MSG_MULTI_NETWORK_LOW_SPEED = 2020;
    private static final int MSG_MULTI_NETWORK_STATUS = 2021;
    private static final int MSG_QUIC_DOWNLOAD_STATUS = 3001;
    private static final int MSG_REPORT_QUIC_QUALITY = 3002;
    private static final int MSG_NOTIFY_HIT_CACHE = 3201;
    private Network mNetwork = null;
    private ITPDownloadListener mITPDownloadListener = null;
    private Handler mMsgHandler;
    private HandlerThread mMsgHandlerThread;
    private Map<Integer, ITPPlayListener> mPlayListenerMap = new HashMap<Integer, ITPPlayListener>();
    private Map<Integer, ITPPreLoadListener> mPreLoadListenerMap = new HashMap<Integer, ITPPreLoadListener>();
    private Map<Integer, ITPOfflineDownloadListener> mOfflineDownloadListenerMap = new HashMap<Integer, ITPOfflineDownloadListener>();
    private static final Object PLAY_LISTENER_MAP_MUTEX = new Object();
    private static final Object PRELOAD_LISTENER_MAP_MUTEX = new Object();
    private static final Object OFFLINE_LISTENER_MAP_MUTEX = new Object();
    private Runnable updatePlayerInfo = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map map;
            Iterator iterator = PLAY_LISTENER_MAP_MUTEX;
            synchronized (iterator) {
                map = TPListenerManager.this.mPlayListenerMap;
            }
            try {
                for (Map.Entry entry : map.entrySet()) {
                    int n2 = (Integer)entry.getKey();
                    ITPPlayListener iTPPlayListener = (ITPPlayListener)entry.getValue();
                    int n3 = (int)(iTPPlayListener.getCurrentPosition() / 1000L);
                    int n4 = (int)(iTPPlayListener.getPlayerBufferLength() / 1000L);
                    int n5 = (int)(iTPPlayListener.getAdvRemainTime() / 1000L);
                    long l2 = iTPPlayListener.getCurrentPlayOffset();
                    TPDownloadProxyNative.getInstance().updateTaskInfo(n2, "taskinfo_play_offset", String.valueOf(l2));
                    TPDownloadProxyNative.getInstance().updatePlayerPlayMsg(n2, n3, n4, n5);
                }
                return;
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(TPListenerManager.FILE_NAME, 0, "tpdlnative", "updatePlayerInfo failed, error:" + throwable.toString());
                return;
            }
            finally {
                TPListenerManager.this.mMsgHandler.postDelayed(TPListenerManager.this.updatePlayerInfo, 1000L);
            }
        }
    };

    private TPListenerManager() {
    }

    public static TPListenerManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void initHandler() {
        if (this.mMsgHandlerThread == null) {
            this.mMsgHandlerThread = new HandlerThread(THREAD_NAME);
            this.mMsgHandlerThread.start();
            this.mMsgHandler = new Handler(this.mMsgHandlerThread.getLooper());
            this.mMsgHandler.postDelayed(this.updatePlayerInfo, 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayListener(int playId, ITPPlayListener listener) {
        if (playId > 0 && listener != null) {
            Object object = PLAY_LISTENER_MAP_MUTEX;
            synchronized (object) {
                this.mPlayListenerMap.put(playId, listener);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayListener(int playId) {
        if (playId > 0) {
            Object object = PLAY_LISTENER_MAP_MUTEX;
            synchronized (object) {
                this.mPlayListenerMap.remove(playId);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllPlayListener() {
        Object object = PLAY_LISTENER_MAP_MUTEX;
        synchronized (object) {
            this.mPlayListenerMap.clear();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITPPlayListener getPlaylistener(int playId) {
        ITPPlayListener playListener;
        Object object = PLAY_LISTENER_MAP_MUTEX;
        synchronized (object) {
            playListener = this.mPlayListenerMap.get(playId);
        }
        return playListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreLoadListener(int preloadId, ITPPreLoadListener listener) {
        if (preloadId > 0 && listener != null) {
            Object object = PRELOAD_LISTENER_MAP_MUTEX;
            synchronized (object) {
                this.mPreLoadListenerMap.put(preloadId, listener);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePreLoadListener(int preloadId) {
        if (preloadId > 0) {
            Object object = PRELOAD_LISTENER_MAP_MUTEX;
            synchronized (object) {
                this.mPreLoadListenerMap.remove(preloadId);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllPreLoadListener() {
        Object object = PRELOAD_LISTENER_MAP_MUTEX;
        synchronized (object) {
            this.mPreLoadListenerMap.clear();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITPPreLoadListener getPreLoadListener(int preloadId) {
        ITPPreLoadListener preloadListener;
        Object object = PRELOAD_LISTENER_MAP_MUTEX;
        synchronized (object) {
            preloadListener = this.mPreLoadListenerMap.get(preloadId);
        }
        return preloadListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOfflineDownloadListener(int downloadId, ITPOfflineDownloadListener listener) {
        if (downloadId > 0 && listener != null) {
            Object object = OFFLINE_LISTENER_MAP_MUTEX;
            synchronized (object) {
                this.mOfflineDownloadListenerMap.put(downloadId, listener);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOfflineDownloadListener(int downloadId) {
        if (downloadId > 0) {
            Object object = OFFLINE_LISTENER_MAP_MUTEX;
            synchronized (object) {
                this.mOfflineDownloadListenerMap.remove(downloadId);
                return;
            }
        }
    }

    public void setNetwork(Network network) {
        TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "cellular_network, set network");
        this.mNetwork = network;
    }

    public void setITPDownloadListener(ITPDownloadListener mITPDownloadListener) {
        this.mITPDownloadListener = mITPDownloadListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITPOfflineDownloadListener getOfflineDownloadListener(int downloadId) {
        ITPOfflineDownloadListener offlineDownloadListener;
        Object object = OFFLINE_LISTENER_MAP_MUTEX;
        synchronized (object) {
            offlineDownloadListener = this.mOfflineDownloadListenerMap.get(downloadId);
        }
        return offlineDownloadListener;
    }

    public synchronized void handleCallbackMessage(final int message, final int taskId, final Object arg1, final Object arg2, final Object arg3, final Object arg4, final Object arg5) {
        if (2008 == message) {
            if (this.mNetwork == null) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "cellular_network, network is null");
                return;
            }
            String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
            int n2 = Integer.parseInt(string);
            try {
                FileDescriptor fileDescriptor = new FileDescriptor();
                Field field = FileDescriptor.class.getDeclaredField("descriptor");
                field.setAccessible(true);
                field.setInt(fileDescriptor, n2);
                TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "cellular_network, bind begin, sock fd: ".concat(String.valueOf(n2)));
                if (Build.VERSION.SDK_INT >= 23) {
                    this.mNetwork.bindSocket(fileDescriptor);
                    TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "cellular_network, bind socket success, sock fd: ".concat(String.valueOf(n2)));
                }
            }
            catch (Throwable throwable) {
                TPDownloadProxyNative.getInstance().setUserData("cellular_interface_id", "-1");
                TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "cellular_network, bind socket failed: " + throwable.toString());
            }
            TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "cellular_network, sock call back end, sock fd: " + n2 + ", str_sock: " + string);
            return;
        }
        if (message == 2010 || message == 2011 || message == 2013) {
            String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
            TPCGIRequester.getInstance().addRequestItem(string, message);
            return;
        }
        this.mMsgHandler.post(new Runnable(){

            @Override
            public void run() {
                TPListenerManager.this.dispatchCallbackMessage(message, taskId, arg1, arg2, arg3, arg4, arg5);
            }
        });
    }

    public int handleIntCallbackMessage(int message, int taskId, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        int n2 = 0;
        ITPPlayListener iTPPlayListener = this.getPlaylistener(taskId);
        if (iTPPlayListener != null) {
            if (message == 200) {
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                long l2 = TPDLProxyUtils.objectToLong(arg2, 0L);
                long l3 = TPDLProxyUtils.objectToLong(arg3, -1L);
                n2 = iTPPlayListener.onStartReadData(taskId, string, l2, l3);
            } else if (message == 202) {
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                int n3 = TPDLProxyUtils.objectToInt(arg2, 0);
                n2 = iTPPlayListener.onStopReadData(taskId, string, n3);
            } else if (message == 201) {
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                long l4 = TPDLProxyUtils.objectToLong(arg2, 0L);
                int n4 = TPDLProxyUtils.objectToInt(arg3, 0);
                n2 = iTPPlayListener.onReadData(taskId, string, l4, n4);
            }
        }
        return n2;
    }

    public String handleStringCallbackMessage(int message, int taskId, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        String string = "";
        ITPPlayListener iTPPlayListener = this.getPlaylistener(taskId);
        if (iTPPlayListener != null) {
            if (message == 205) {
                String string2 = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                string = iTPPlayListener.getContentType(taskId, string2);
            } else if (message == 203) {
                String string3 = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                string = String.valueOf(iTPPlayListener.getDataTotalSize(taskId, string3));
            } else if (message == 204) {
                String string4 = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                string = iTPPlayListener.getDataFilePath(taskId, string4);
            }
        }
        return string;
    }

    private void dispatchCallbackMessage(int message, int taskId, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        ITPPlayListener iTPPlayListener = this.getPlaylistener(taskId);
        if (iTPPlayListener != null) {
            this.dispatchPlayMessage(iTPPlayListener, message, taskId, arg1, arg2, arg3, arg4, arg5);
            return;
        }
        ITPPreLoadListener iTPPreLoadListener = this.getPreLoadListener(taskId);
        if (iTPPreLoadListener != null) {
            this.dispatchPreLoadMessage(iTPPreLoadListener, message, taskId, arg1, arg2, arg3, arg4, arg5);
            return;
        }
        ITPOfflineDownloadListener iTPOfflineDownloadListener = this.getOfflineDownloadListener(taskId);
        if (iTPOfflineDownloadListener != null) {
            this.dispatchOfflineDownloadMessage(iTPOfflineDownloadListener, message, taskId, arg1, arg2, arg3, arg4, arg5);
            return;
        }
        if (this.mITPDownloadListener != null) {
            switch (message) {
                case 3002: {
                    String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                    this.mITPDownloadListener.onQuicQualityReportUpdate(string);
                    return;
                }
                case 2015: {
                    String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                    this.mITPDownloadListener.willReleaseMemory(string);
                    return;
                }
                case 2016: {
                    String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                    this.mITPDownloadListener.didReleaseMemory(string);
                }
            }
        }
    }

    private void dispatchPlayMessage(ITPPlayListener listener, int message, int taskId, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (listener == null) {
            return;
        }
        switch (message) {
            case 2: {
                int n2 = TPDLProxyUtils.objectToInt(arg1, 0);
                int n3 = TPDLProxyUtils.objectToInt(arg2, 0);
                long l2 = TPDLProxyUtils.objectToLong(arg3, 0L);
                long l3 = TPDLProxyUtils.objectToLong(arg4, 0L);
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg5);
                listener.onDownloadProgressUpdate(n2, n3, l2, l3, string);
                return;
            }
            case 3: {
                listener.onDownloadFinish();
                return;
            }
            case 4: {
                return;
            }
            case 5: {
                listener.onDownloadCdnUrlUpdate(TPDLProxyUtils.byteArrayToString((byte[])arg1));
                return;
            }
            case 6: {
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                String string2 = TPDLProxyUtils.byteArrayToString((byte[])arg2);
                String string3 = TPDLProxyUtils.byteArrayToString((byte[])arg3);
                String string4 = TPDLProxyUtils.byteArrayToString((byte[])arg4);
                listener.onDownloadCdnUrlInfoUpdate(string, string2, string3, string4);
                return;
            }
            case 7: {
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                long l4 = TPDLProxyUtils.objectToLong(arg2, 0L);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    hashMap.put("exttag", string);
                    hashMap.put("randnum", String.valueOf(l4));
                }
                listener.onDownloadCdnUrlExpired(hashMap);
                return;
            }
            case 8: {
                int n4 = TPDLProxyUtils.objectToInt(arg1, 0);
                listener.onDownloadStatusUpdate(n4);
                return;
            }
            case 9: {
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                String string5 = TPDLProxyUtils.byteArrayToString((byte[])arg2);
                listener.onDownloadProtocolUpdate(string, string5);
                return;
            }
            case 101: {
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                long l5 = TPDLProxyUtils.objectToLong(arg2, 0L);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    hashMap.put("exttag", string);
                    hashMap.put("randnum", String.valueOf(l5));
                }
                listener.onPlayCallback(1, hashMap, null, null, null);
                return;
            }
            case 2003: {
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                String string6 = TPDLProxyUtils.byteArrayToString((byte[])arg2);
                int n5 = TPDLProxyUtils.objectToInt(arg3, 0);
                listener.onPlayCallback(2, string, string6, n5, null);
                return;
            }
            case 2004: {
                final int n6 = TPDLProxyUtils.objectToInt(arg2, 0);
                TVKThreadUtil.getScheduledExecutorServiceInstance().execute(new Runnable(){

                    @Override
                    public void run() {
                        String string = TPDLProxyUtils.losePackageCheck(n6);
                        TPDownloadProxyNative.getInstance().setUserData("lose_package_check_info", string);
                    }
                });
                return;
            }
            case 2006: {
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                listener.onPlayCallback(3, string, null, null, null);
                return;
            }
            case 2007: {
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                listener.onPlayCallback(4, string, null, null, null);
                return;
            }
            case 2009: {
                int n7 = TPDLProxyUtils.objectToInt(arg1, 0);
                byte[] byArray = arg2 == null ? null : (byte[])arg2;
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg3);
                int n8 = TPDLProxyUtils.objectToInt(arg4, 0);
                listener.onPlayCallback(5, n7, byArray, string, n8);
                return;
            }
            case 3001: {
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                listener.onPlayCallback(6, string, null, null, null);
                return;
            }
            case 2020: {
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                listener.onPlayCallback(10, string, null, null, null);
                TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "MULTI_NETWORK msg: " + message + ", info: " + string);
                return;
            }
            case 2021: {
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                listener.onPlayCallback(11, string, null, null, null);
                TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "MULTI_NETWORK msg: " + message + ", info: " + string);
                return;
            }
            case 2014: {
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                String string7 = TPDLProxyUtils.byteArrayToString((byte[])arg2);
                listener.onPlayCallback(8, string, string7, null, null);
                TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "MSG_TAB_TESTID: ".concat(String.valueOf(string7)));
                return;
            }
            case 2017: {
                listener.onPlayCallback(9, null, null, null, null);
                return;
            }
            case 3201: {
                listener.onPlayCallback(12, null, null, null, null);
            }
        }
    }

    private void dispatchPreLoadMessage(ITPPreLoadListener listener, int message, int taskId, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (listener == null) {
            return;
        }
        switch (message) {
            case 2: {
                int n2 = TPDLProxyUtils.objectToInt(arg1, 0);
                int n3 = TPDLProxyUtils.objectToInt(arg2, 0);
                long l2 = TPDLProxyUtils.objectToLong(arg3, 0L);
                long l3 = TPDLProxyUtils.objectToLong(arg4, 0L);
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg5);
                listener.onPrepareDownloadProgressUpdate(n2, n3, l2, l3, string);
                return;
            }
            case 50: {
                listener.onPrepareOK();
                return;
            }
            case 4: {
                listener.onPrepareError((Integer)arg1, (Integer)arg2, TPDLProxyUtils.byteArrayToString((byte[])arg3));
            }
        }
    }

    private void dispatchOfflineDownloadMessage(ITPOfflineDownloadListener listener, int message, int taskId, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (listener == null) {
            return;
        }
        switch (message) {
            case 2: {
                int n2 = TPDLProxyUtils.objectToInt(arg1, 0);
                int n3 = TPDLProxyUtils.objectToInt(arg2, 0);
                long l2 = TPDLProxyUtils.objectToLong(arg3, 0L);
                long l3 = TPDLProxyUtils.objectToLong(arg4, 0L);
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg5);
                listener.onDownloadProgressUpdate(n2, n3, l2, l3, string);
                return;
            }
            case 3: {
                listener.onDownloadFinish();
                return;
            }
            case 4: {
                listener.onDownloadError((Integer)arg1, (Integer)arg2, TPDLProxyUtils.byteArrayToString((byte[])arg3));
                return;
            }
            case 5: {
                listener.onDownloadCdnUrlUpdate(TPDLProxyUtils.byteArrayToString((byte[])arg1));
                return;
            }
            case 6: {
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                String string2 = TPDLProxyUtils.byteArrayToString((byte[])arg2);
                String string3 = TPDLProxyUtils.byteArrayToString((byte[])arg3);
                String string4 = TPDLProxyUtils.byteArrayToString((byte[])arg4);
                listener.onDownloadCdnUrlInfoUpdate(string, string2, string3, string4);
                return;
            }
            case 7: {
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                long l4 = TPDLProxyUtils.objectToLong(arg2, 0L);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    hashMap.put("exttag", string);
                    hashMap.put("randnum", String.valueOf(l4));
                }
                listener.onDownloadCdnUrlExpired(hashMap);
                return;
            }
            case 8: {
                int n4 = TPDLProxyUtils.objectToInt(arg1, 0);
                listener.onDownloadStatusUpdate(n4);
                return;
            }
            case 9: {
                String string = TPDLProxyUtils.byteArrayToString((byte[])arg1);
                String string5 = TPDLProxyUtils.byteArrayToString((byte[])arg2);
                listener.onDownloadProtocolUpdate(string, string5);
            }
        }
    }

    static class SingletonHolder {
        private static final TPListenerManager INSTANCE = new TPListenerManager();

        private SingletonHolder() {
        }
    }
}

