/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.encoder;

import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Bundle;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Rotation;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.base.util.w;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.utils.k;
import com.tencent.liteav.videobase.videobase.h;
import com.tencent.liteav.videoproducer.encoder.VideoEncodeParams;
import com.tencent.liteav.videoproducer.encoder.VideoEncoderDef;
import com.tencent.liteav.videoproducer.encoder.al;
import com.tencent.liteav.videoproducer.encoder.bq;
import com.tencent.liteav.videoproducer.encoder.s;
import com.tencent.liteav.videoproducer.producer.VideoProducerDef;
import com.tencent.ugc.encoder.a;
import com.tencent.ugc.encoder.b;
import com.tencent.ugc.encoder.c;
import com.tencent.ugc.encoder.d;
import com.tencent.ugc.encoder.e;
import com.tencent.ugc.encoder.f;
import com.tencent.ugc.encoder.g;
import com.tencent.ugc.encoder.h;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class UGCVideoEncodeController {
    private static final int THREAD_KEEP_ALIVE_TIME_IN_SECOND = 15;
    private static final int MAX_WAIT_TIME_MS = 2000;
    private static final int MAX_ENCODE_COST_TIME_PER_FRAME = 5000;
    private static final int MAX_ENCODE_RESTART_COUNT = 3;
    private static final int FRAME_QUEUE_SIZE = 1;
    private static final int CHECK_INTERVAL_TIME = 1000;
    private static final PixelFrame EOS_FRAME = new PixelFrame();
    private final String mTag;
    private final com.tencent.liteav.base.b.b mThrottlers;
    private final l mSequenceTaskRunner;
    private final k mPendingEncodeFrameQueue;
    private final Bundle mSessionStates = new Bundle();
    private final AtomicBoolean mHasEncoderError = new AtomicBoolean(false);
    private final AtomicBoolean mIsNeedRestart = new AtomicBoolean(false);
    private final Map<Long, Long> mFrameDeliverToEncoderTimeMap = new HashMap<Long, Long>();
    private bq mVideoEncoder;
    private VideoEncoderDef.VideoEncoderDataListener mEncoderListener;
    private VideoEncodeParams mEncodeParams;
    private Rotation mEncodeRotation = Rotation.a;
    private boolean mIsFinishEncode = false;
    private boolean mHasEncodeFailureNotified = false;
    private boolean mIsFirstFrameEncoded = false;
    private boolean mIsUsingHardwareEncoder = true;
    private int mEncoderRestartCount = 0;
    private w mCheckTimer;
    private final bq.a mVideoEncoderListener = new bq.a(){

        @Override
        public final void onEncodedNAL(EncodedVideoFrame nal, boolean isEos) {
            if (nal == null) {
                LiteavLog.d(UGCVideoEncodeController.this.mThrottlers.a("onEncodedNAL"), UGCVideoEncodeController.this.mTag, "onEncodedNAL frame is null.", new Object[0]);
                return;
            }
            UGCVideoEncodeController.this.mSequenceTaskRunner.a(g.a(this, isEos, nal));
        }

        @Override
        public final void a() {
            LiteavLog.i(UGCVideoEncodeController.this.mThrottlers.a("onRequestRestart"), UGCVideoEncodeController.this.mTag, "onRequestRestart", new Object[0]);
            UGCVideoEncodeController.this.mIsNeedRestart.set(true);
        }

        @Override
        public final void onEncodedFail(h.a code) {
            LiteavLog.e(UGCVideoEncodeController.this.mThrottlers.a("onEncodedFail"), UGCVideoEncodeController.this.mTag, "onEncodedFail code = ".concat(String.valueOf((Object)code)), new Object[0]);
            UGCVideoEncodeController.this.mHasEncoderError.set(true);
        }

        @Override
        public final void onOutputFormatChanged(MediaFormat format) {
            UGCVideoEncodeController.this.mSequenceTaskRunner.a(h.a(this, format));
        }

        static /* synthetic */ void a(1 var0, MediaFormat mediaFormat) {
            if (var0.UGCVideoEncodeController.this.mEncoderListener != null) {
                var0.UGCVideoEncodeController.this.mEncoderListener.onOutputFormatChanged(mediaFormat);
            }
        }

        static /* synthetic */ void a(1 var0, boolean bl2, EncodedVideoFrame encodedVideoFrame) {
            if (bl2) {
                LiteavLog.i(var0.UGCVideoEncodeController.this.mThrottlers.a("onEncodedNAL"), var0.UGCVideoEncodeController.this.mTag, "got eos", new Object[0]);
                var0.UGCVideoEncodeController.this.mFrameDeliverToEncoderTimeMap.clear();
                var0.UGCVideoEncodeController.this.mIsFinishEncode = true;
            }
            if (var0.UGCVideoEncodeController.this.mEncoderListener != null) {
                var0.UGCVideoEncodeController.this.mEncoderListener.onEncodedNAL(encodedVideoFrame, bl2);
            }
            var0.UGCVideoEncodeController.this.mIsFirstFrameEncoded = true;
            var0.UGCVideoEncodeController.this.removeEarlierFrameFromFrameDeliverToEncoderTimeMap(encodedVideoFrame.pts);
        }
    };

    public UGCVideoEncodeController() {
        this.mTag = "UGCVideoEncodeController_" + this.hashCode();
        this.mThrottlers = new com.tencent.liteav.base.b.b();
        this.mSequenceTaskRunner = new l(15, this.mTag);
        this.mPendingEncodeFrameQueue = new com.tencent.liteav.videobase.utils.b(1);
    }

    public void start(VideoEncodeParams params, @NonNull VideoEncoderDef.VideoEncoderDataListener listener) {
        LiteavLog.i(this.mThrottlers.a("start"), this.mTag, "start", new Object[0]);
        this.mSequenceTaskRunner.a(a.a(this, params, listener));
    }

    public void stop() {
        LiteavLog.i(this.mThrottlers.a("stop"), this.mTag, "stop", new Object[0]);
        this.mSequenceTaskRunner.a(b.a(this));
    }

    public void encodeFrame(PixelFrame frame) {
        if (frame == null) {
            return;
        }
        if (frame.getGLContext() != null) {
            GLES20.glFinish();
        }
        this.mPendingEncodeFrameQueue.a(frame);
        this.mSequenceTaskRunner.a(c.a(this));
    }

    public void signalEndOfStream() {
        LiteavLog.i(this.mThrottlers.a("signalEndOfStream"), this.mTag, "signalEndOfStream", new Object[0]);
        this.mPendingEncodeFrameQueue.a(EOS_FRAME);
        this.mSequenceTaskRunner.a(d.a(this));
    }

    private boolean createEncoder() {
        this.mVideoEncoder = this.mIsUsingHardwareEncoder ? new s(this.mSessionStates, new com.tencent.liteav.videobase.videobase.f(), VideoProducerDef.StreamType.a) : new al(new com.tencent.liteav.videobase.videobase.f(), VideoProducerDef.StreamType.a);
        this.mVideoEncoder.a();
        return this.mVideoEncoder.a(this.mEncodeParams, this.mVideoEncoderListener);
    }

    private void encodeFrameInternal() {
        this.handleEncoderRestart();
        if (!this.handleEncoderError()) {
            this.mPendingEncodeFrameQueue.b();
            return;
        }
        if (this.mIsFinishEncode || this.mHasEncodeFailureNotified) {
            this.mPendingEncodeFrameQueue.b();
            return;
        }
        if (this.mVideoEncoder == null || this.mVideoEncoder.b()) {
            this.mSequenceTaskRunner.b(e.a(this), 10L);
            return;
        }
        PixelFrame pixelFrame = this.mPendingEncodeFrameQueue.a();
        if (pixelFrame == null) {
            return;
        }
        this.mFrameDeliverToEncoderTimeMap.put(pixelFrame.getTimestamp(), SystemClock.elapsedRealtime());
        if (pixelFrame == EOS_FRAME) {
            this.mVideoEncoder.c();
            this.mIsFinishEncode = false;
            if (this.mCheckTimer != null) {
                UGCVideoEncodeController uGCVideoEncodeController = this;
                this.mCheckTimer = new w(Looper.myLooper(), new f(uGCVideoEncodeController));
                this.mCheckTimer.a(1000, 1000);
                return;
            }
        } else {
            this.mVideoEncoder.a(pixelFrame);
            pixelFrame.release();
        }
    }

    private void handleEncoderRestart() {
        if (!this.mIsNeedRestart.get()) {
            return;
        }
        if (this.mIsFinishEncode || this.mHasEncodeFailureNotified) {
            this.notifyEncodedFail();
            return;
        }
        if (!this.reCreateEncoder()) {
            this.mHasEncoderError.set(true);
            return;
        }
        this.mIsNeedRestart.set(false);
        this.mHasEncoderError.set(false);
        this.mFrameDeliverToEncoderTimeMap.clear();
    }

    private boolean handleEncoderError() {
        if (!this.hasEncoderError()) {
            return true;
        }
        if (this.mIsFinishEncode || this.mHasEncodeFailureNotified) {
            this.notifyEncodedFail();
            return false;
        }
        if (this.mIsUsingHardwareEncoder) {
            if (!this.mIsFirstFrameEncoded) {
                this.mIsUsingHardwareEncoder = false;
            }
            if (this.reCreateEncoder()) {
                this.mHasEncoderError.set(false);
                this.mFrameDeliverToEncoderTimeMap.clear();
                return true;
            }
        }
        this.notifyEncodedFail();
        return false;
    }

    private void notifyEncodedFail() {
        if (this.mHasEncodeFailureNotified) {
            return;
        }
        if (this.mEncoderListener != null) {
            this.mEncoderListener.onEncodedFail(h.a.j);
        }
        this.mHasEncodeFailureNotified = true;
    }

    private boolean hasEncoderError() {
        if (this.mHasEncoderError.get()) {
            LiteavLog.e(this.mThrottlers.a("isEncoderError"), this.mTag, "mIsEncoderError is true", new Object[0]);
            return true;
        }
        long l2 = this.getEarliestTimeFromFrameDeliverToEncoderTimeMap();
        if (l2 != 0L && SystemClock.elapsedRealtime() - l2 > 5000L) {
            LiteavLog.e(this.mThrottlers.a("isEncoderError"), this.mTag, "encoder output frame is outTime", new Object[0]);
            return true;
        }
        return false;
    }

    private boolean reCreateEncoder() {
        if (this.mEncoderRestartCount++ > 3) {
            LiteavLog.e(this.mThrottlers.a("reCreateEncoder"), this.mTag, "encoder failed to restart too many times", new Object[0]);
            return false;
        }
        this.destroyEncoder();
        return this.createEncoder();
    }

    private void destroyEncoder() {
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.d();
            this.mVideoEncoder.g();
            this.mVideoEncoder = null;
        }
    }

    private long getEarliestTimeFromFrameDeliverToEncoderTimeMap() {
        long l2 = Long.MAX_VALUE;
        for (long l3 : this.mFrameDeliverToEncoderTimeMap.values()) {
            if (l3 >= l2) continue;
            l2 = l3;
        }
        return l2;
    }

    private void removeEarlierFrameFromFrameDeliverToEncoderTimeMap(long pts) {
        Iterator<Map.Entry<Long, Long>> iterator = this.mFrameDeliverToEncoderTimeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getKey() > pts) continue;
            iterator.remove();
        }
    }

    static /* synthetic */ void lambda$stop$1(UGCVideoEncodeController this_) {
        this_.mSessionStates.clear();
        this_.mHasEncoderError.set(false);
        this_.mIsNeedRestart.set(false);
        this_.mFrameDeliverToEncoderTimeMap.clear();
        this_.mEncoderRestartCount = 0;
        this_.mEncoderListener = null;
        this_.mEncodeParams = null;
        this_.mEncodeRotation = Rotation.a;
        this_.mIsFinishEncode = true;
        this_.mHasEncodeFailureNotified = false;
        this_.mIsUsingHardwareEncoder = true;
        this_.mIsFirstFrameEncoded = false;
        this_.mPendingEncodeFrameQueue.b();
        if (this_.mCheckTimer != null) {
            this_.mCheckTimer.a();
            this_.mCheckTimer = null;
        }
        this_.destroyEncoder();
    }

    static /* synthetic */ void lambda$start$0(UGCVideoEncodeController this_, @NonNull VideoEncodeParams params, VideoEncoderDef.VideoEncoderDataListener listener) {
        if (this_.mVideoEncoder != null) {
            LiteavLog.i(this_.mThrottlers.a("start"), this_.mTag, "VideoEncoder is started", new Object[0]);
            return;
        }
        this_.mEncodeParams = new VideoEncodeParams(params);
        this_.mEncoderListener = listener;
        this_.mIsFinishEncode = false;
        this_.createEncoder();
    }

    static /* synthetic */ void access$lambda$0(UGCVideoEncodeController uGCVideoEncodeController) {
        uGCVideoEncodeController.encodeFrameInternal();
    }

    static /* synthetic */ void access$lambda$1(UGCVideoEncodeController uGCVideoEncodeController) {
        uGCVideoEncodeController.encodeFrameInternal();
    }

    static /* synthetic */ void access$lambda$2(UGCVideoEncodeController uGCVideoEncodeController) {
        uGCVideoEncodeController.encodeFrameInternal();
    }

    static /* synthetic */ void access$lambda$3(UGCVideoEncodeController uGCVideoEncodeController) {
        uGCVideoEncodeController.encodeFrameInternal();
    }
}

