/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.ViewGroup;
import com.taobao.weex.WXSDKInstance;
import io.dcloud.common.DHInterface.IKeyHandler;
import io.dcloud.common.DHInterface.ISysEventListener;
import io.dcloud.common.DHInterface.IUniNView;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.ui.AdaFrameView;
import io.dcloud.common.adapter.util.ViewOptions;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.feature.weex.WXAnalyzerDelegate;
import io.dcloud.feature.weex.adapter.widget.refresh.DCWeexBaseRefreshLayout;
import io.dcloud.feature.weex.adapter.widget.refresh.WeexDcRefreshLayout;
import java.util.Map;
import org.json.JSONObject;

public class WXBaseWrapper
extends WeexDcRefreshLayout
implements IUniNView {
    protected String mWxId;
    protected WXSDKInstance mWXSDKInstance;
    protected IWebview mWebview;
    protected String mPath = null;
    protected String mSrcPath = null;
    protected static int DE_INDEX = -1;
    protected WXAnalyzerDelegate mWXAnaly;

    public WXBaseWrapper(Context context) {
        super(context);
        this.setEnabled(false);
    }

    public void onReady() {
    }

    protected void onRefresh() {
    }

    public void initRefresh(JSONObject options) {
        if (options != null) {
            boolean support = Boolean.parseBoolean(JSONUtil.getString((JSONObject)options, (String)"support"));
            String style = "default";
            if (options != null) {
                style = options.optString("style", style);
            }
            if (support && style.equals("circle")) {
                this.setEnabled(true);
                this.setOnRefreshListener(new DCWeexBaseRefreshLayout.OnRefreshListener(){

                    @Override
                    public void onRefresh() {
                        WXBaseWrapper.this.onRefresh();
                    }
                });
                this.parseData(options);
            } else {
                this.setOnRefreshListener(null);
                this.setEnabled(false);
            }
        }
    }

    private void parseData(JSONObject options) {
        if (this.mWebview == null) {
            return;
        }
        AdaFrameView frameView = (AdaFrameView)this.mWebview.obtainFrameView();
        ViewOptions viewOptions = frameView.obtainFrameOptions();
        String offsetStr = options.optString("offset");
        int offset = 0;
        if (!TextUtils.isEmpty((CharSequence)offsetStr)) {
            offset = PdrUtil.convertToScreenInt((String)offsetStr, (int)viewOptions.height, (int)offset, (float)this.mWebview.getScale());
        }
        String heightStr = options.optString("height");
        int height = (int)this.mTotalDragDistance;
        if (!TextUtils.isEmpty((CharSequence)heightStr)) {
            height = PdrUtil.convertToScreenInt((String)heightStr, (int)viewOptions.height, (int)height, (float)this.mWebview.getScale());
        }
        String rangeStr = options.optString("range");
        int range = (int)this.mSpinnerFinalOffset;
        if (!TextUtils.isEmpty((CharSequence)rangeStr)) {
            range = PdrUtil.convertToScreenInt((String)rangeStr, (int)viewOptions.height, (int)range, (float)this.mWebview.getScale());
        }
        range += this.mOriginalOffsetTop;
        String colorStr = options.optString("color");
        int color2 = Color.parseColor((String)"#2BD009");
        if (!TextUtils.isEmpty((CharSequence)colorStr) && colorStr.startsWith("#")) {
            try {
                color2 = Color.parseColor((String)colorStr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.setColorSchemeColors(color2);
        this.setProgressViewOffset(false, this.mOriginalOffsetTop, range, height, offset);
    }

    public void beginPullRefresh() {
        this.beginRefresh();
    }

    public void endPullToRefresh() {
        this.setRefreshing(false);
    }

    public void titleNViewRefresh() {
    }

    public void reload() {
    }

    public String getType() {
        return null;
    }

    public void onDestroy() {
        this.destroy();
    }

    public void destroy() {
        this.setEnabled(false);
        this.recoveryInstance();
    }

    public void recoveryInstance() {
        if (this.mWXSDKInstance != null) {
            this.mWXSDKInstance.registerRenderListener(null);
            this.mWXSDKInstance.onActivityDestroy();
            if (this.mWXAnaly != null) {
                this.mWXAnaly.onDestroy();
                this.mWXAnaly = null;
            }
            this.mWXSDKInstance = null;
            this.clearTarget();
        }
    }

    public ViewGroup obtainMainView() {
        return this;
    }

    public void loadTemplate(JSONObject info) {
    }

    public boolean fireGlobalEvent(String key, Map<String, Object> params) {
        if (this.mWXSDKInstance != null) {
            this.mWXSDKInstance.fireGlobalEventCallback(key, params);
            return true;
        }
        return false;
    }

    public String evalJs(String js, int type) {
        return null;
    }

    public void onActivityResume() {
        if (this.mWXSDKInstance != null) {
            this.mWXSDKInstance.onActivityResume();
            if (this.mWXAnaly != null) {
                this.mWXAnaly.onResume();
            }
        }
    }

    public void onActivityPause() {
        if (this.mWXSDKInstance != null) {
            this.mWXSDKInstance.onActivityPause();
            if (this.mWXAnaly != null) {
                this.mWXAnaly.onPause();
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mWXSDKInstance != null) {
            this.mWXSDKInstance.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (this.mWXSDKInstance != null) {
            this.mWXSDKInstance.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean ret = super.onKeyDown(keyCode, event);
        if (ret && this.mWebview != null && this.mWebview.getActivity() instanceof IKeyHandler) {
            IKeyHandler act = (IKeyHandler)this.mWebview.getActivity();
            act.onKeyEventExecute(ISysEventListener.SysEventType.onKeyDown, keyCode, event);
        }
        return ret;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        boolean ret = super.onKeyUp(keyCode, event);
        if (ret && this.mWebview != null && this.mWebview.getActivity() instanceof IKeyHandler) {
            IKeyHandler act = (IKeyHandler)this.mWebview.getActivity();
            act.onKeyEventExecute(ISysEventListener.SysEventType.onKeyUp, keyCode, event);
        }
        return ret;
    }
}

