/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.os.Build;
import cn.rongcloud.rtc.core.MediaCodecUtils;
import cn.rongcloud.rtc.core.VideoCodecType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MediaCodecUtilsProxy {
    private static final String TAG = "MediaCodecUtilsProxy";

    public int[] getTextureColorFormats() {
        return MediaCodecUtils.TEXTURE_COLOR_FORMATS;
    }

    public int[] getEncoderColorFormats() {
        return MediaCodecUtils.ENCODER_COLOR_FORMATS;
    }

    public int[] getDecoderColorFormats() {
        return MediaCodecUtils.DECODER_COLOR_FORMATS;
    }

    public String[] getH264SupportCpuPrefixList(boolean isEncode) {
        if (Build.VERSION.SDK_INT >= 31 && Build.MODEL.contains("Pixel")) {
            return new String[]{"OMX.google."};
        }
        if (isEncode) {
            return MediaCodecUtils.cpuPrefixListForEncode;
        }
        return MediaCodecUtils.cpuPrefixListForDecode;
    }

    public String[] getH264HighProfileCpuPrefixList() {
        if (Build.VERSION.SDK_INT >= 23) {
            return new String[]{"OMX.Exynos."};
        }
        return new String[0];
    }

    public List<String> getHWExceptionList() {
        return Arrays.asList("SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4");
    }

    public Map<String, String> getCodecProperties(VideoCodecType type, boolean highProfile) {
        Map<String, String> codecProperties = MediaCodecUtils.getCodecProperties(type, highProfile);
        return codecProperties;
    }
}

