/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.api.probe;

import android.os.Handler;
import cn.rongcloud.rtc.api.probe.IRCRTCProbeTestListener;
import cn.rongcloud.rtc.api.probe.RCRTCProbeStatusResult;
import cn.rongcloud.rtc.base.RTCErrorCode;
import java.util.List;

public class RTCProbeTestListenerWrapper
extends IRCRTCProbeTestListener {
    private final IRCRTCProbeTestListener testListener;
    private final Handler mCallBackHandler;

    public RTCProbeTestListenerWrapper(IRCRTCProbeTestListener testListener, Handler mCallBackHandler) {
        this.testListener = testListener;
        this.mCallBackHandler = mCallBackHandler;
    }

    private void postCallbackThread(Runnable runnable) {
        if (this.testListener != null) {
            this.mCallBackHandler.post(runnable);
        }
    }

    @Override
    public void onRTCProbeStatus(final List<RCRTCProbeStatusResult> statusResults) {
        this.postCallbackThread(new Runnable(){

            @Override
            public void run() {
                RTCProbeTestListenerWrapper.this.testListener.onRTCProbeStatus(statusResults);
            }
        });
    }

    @Override
    public void onRTCProbeInterrupted(final RTCErrorCode errorCode) {
        this.postCallbackThread(new Runnable(){

            @Override
            public void run() {
                RTCProbeTestListenerWrapper.this.testListener.onRTCProbeInterrupted(errorCode);
            }
        });
    }

    @Override
    public void onRTCProbeCompete() {
        this.postCallbackThread(new Runnable(){

            @Override
            public void run() {
                RTCProbeTestListenerWrapper.this.testListener.onRTCProbeCompete();
            }
        });
    }
}

