/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.listeners;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.View;

public final class RepeatListener
implements View.OnTouchListener {
    final long normalInterval;
    final View.OnClickListener clickListener;
    final Handler handler = new Handler();
    private final long initialInterval;
    View downView;
    private final Runnable handlerRunnable = new Runnable(){

        @Override
        public void run() {
            if (RepeatListener.this.downView != null) {
                RepeatListener.this.handler.removeCallbacksAndMessages((Object)RepeatListener.this.downView);
                RepeatListener.this.handler.postAtTime((Runnable)this, (Object)RepeatListener.this.downView, SystemClock.uptimeMillis() + RepeatListener.this.normalInterval);
                RepeatListener.this.clickListener.onClick(RepeatListener.this.downView);
            }
        }
    };

    public RepeatListener(long initialInterval, long normalInterval, View.OnClickListener clickListener) {
        if (clickListener == null) {
            throw new IllegalArgumentException("null runnable");
        }
        if (initialInterval < 0L || normalInterval < 0L) {
            throw new IllegalArgumentException("negative interval");
        }
        this.initialInterval = initialInterval;
        this.normalInterval = normalInterval;
        this.clickListener = clickListener;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View view, MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 0: {
                this.handler.removeCallbacks(this.handlerRunnable);
                this.handler.postAtTime(this.handlerRunnable, (Object)this.downView, SystemClock.uptimeMillis() + this.initialInterval);
                this.downView = view;
                this.downView.setPressed(true);
                this.clickListener.onClick(view);
                return true;
            }
            case 1: 
            case 3: 
            case 4: {
                this.handler.removeCallbacksAndMessages((Object)this.downView);
                this.downView.setPressed(false);
                this.downView = null;
                return true;
            }
        }
        return false;
    }
}

