/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.composer;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import androidx.annotation.NonNull;
import com.daasuu.mp4compose.SampleType;
import com.daasuu.mp4compose.logger.Logger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

class MuxRender {
    private static final String TAG = "MuxRender";
    private static final int BUFFER_SIZE = 65536;
    private final MediaMuxer muxer;
    private MediaFormat videoFormat;
    private MediaFormat audioFormat;
    private int videoTrackIndex;
    private int audioTrackIndex;
    private ByteBuffer byteBuffer;
    private final List<SampleInfo> sampleInfoList;
    private boolean started;
    private final Logger logger;

    MuxRender(@NonNull MediaMuxer muxer, @NonNull Logger logger) {
        this.muxer = muxer;
        this.logger = logger;
        this.sampleInfoList = new ArrayList<SampleInfo>();
    }

    void setOutputFormat(SampleType sampleType, MediaFormat format) {
        switch (sampleType) {
            case VIDEO: {
                this.videoFormat = format;
                break;
            }
            case AUDIO: {
                this.audioFormat = format;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    void onSetOutputFormat() {
        if (this.videoFormat != null && this.audioFormat != null) {
            this.videoTrackIndex = this.muxer.addTrack(this.videoFormat);
            this.logger.debug(TAG, "Added track #" + this.videoTrackIndex + " with " + this.videoFormat.getString("mime") + " to muxer");
            this.audioTrackIndex = this.muxer.addTrack(this.audioFormat);
            this.logger.debug(TAG, "Added track #" + this.audioTrackIndex + " with " + this.audioFormat.getString("mime") + " to muxer");
        } else if (this.videoFormat != null) {
            this.videoTrackIndex = this.muxer.addTrack(this.videoFormat);
            this.logger.debug(TAG, "Added track #" + this.videoTrackIndex + " with " + this.videoFormat.getString("mime") + " to muxer");
        }
        this.muxer.start();
        this.started = true;
        if (this.byteBuffer == null) {
            this.byteBuffer = ByteBuffer.allocate(0);
        }
        this.byteBuffer.flip();
        this.logger.debug(TAG, "Output format determined, writing " + this.sampleInfoList.size() + " samples / " + this.byteBuffer.limit() + " bytes to muxer.");
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        int offset = 0;
        for (SampleInfo sampleInfo : this.sampleInfoList) {
            sampleInfo.writeToBufferInfo(bufferInfo, offset);
            this.muxer.writeSampleData(this.getTrackIndexForSampleType(sampleInfo.sampleType), this.byteBuffer, bufferInfo);
            offset += sampleInfo.size;
        }
        this.sampleInfoList.clear();
        this.byteBuffer = null;
    }

    void writeSampleData(SampleType sampleType, ByteBuffer byteBuf, MediaCodec.BufferInfo bufferInfo) {
        if (this.started) {
            this.muxer.writeSampleData(this.getTrackIndexForSampleType(sampleType), byteBuf, bufferInfo);
            return;
        }
        byteBuf.limit(bufferInfo.offset + bufferInfo.size);
        byteBuf.position(bufferInfo.offset);
        if (this.byteBuffer == null) {
            this.byteBuffer = ByteBuffer.allocateDirect(65536).order(ByteOrder.nativeOrder());
        }
        this.byteBuffer.put(byteBuf);
        this.sampleInfoList.add(new SampleInfo(sampleType, bufferInfo.size, bufferInfo));
    }

    private int getTrackIndexForSampleType(SampleType sampleType) {
        switch (sampleType) {
            case VIDEO: {
                return this.videoTrackIndex;
            }
            case AUDIO: {
                return this.audioTrackIndex;
            }
        }
        throw new AssertionError();
    }

    private static class SampleInfo {
        private final SampleType sampleType;
        private final int size;
        private final long presentationTimeUs;
        private final int flags;

        private SampleInfo(SampleType sampleType, int size, MediaCodec.BufferInfo bufferInfo) {
            this.sampleType = sampleType;
            this.size = size;
            this.presentationTimeUs = bufferInfo.presentationTimeUs;
            this.flags = bufferInfo.flags;
        }

        private void writeToBufferInfo(MediaCodec.BufferInfo bufferInfo, int offset) {
            bufferInfo.set(offset, this.size, this.presentationTimeUs, this.flags);
        }
    }
}

