/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import cn.rongcloud.rtc.core.CalledByNative;
import cn.rongcloud.rtc.core.FrameDecryptor;
import cn.rongcloud.rtc.core.JniCommon;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.core.RtpParameters;
import cn.rongcloud.rtc.utils.FinLog;

public class RtpReceiver {
    private long nativeRtpReceiver;
    private long nativeObserver;
    private long nativeDecryptor;
    private DisposeObserver disposeObserver;
    private MediaStreamTrack cachedTrack;
    private volatile boolean isFirstPacketReceivedEventHandled = true;
    Observer outerObserver;

    @CalledByNative
    public RtpReceiver(long nativeRtpReceiver) {
        this.nativeRtpReceiver = nativeRtpReceiver;
        long nativeTrack = RtpReceiver.nativeGetTrack(nativeRtpReceiver);
        this.cachedTrack = MediaStreamTrack.createMediaStreamTrack(nativeTrack);
        this.SetObserver(new Observer(){

            @Override
            public void onFirstPacketReceived(MediaStreamTrack.MediaType media_type) {
                FinLog.i("RtpReceiver", "onFirstPacketReceived :: " + (Object)((Object)media_type) + " outObserver::" + this);
                RtpReceiver.this.isFirstPacketReceivedEventHandled = false;
                if (RtpReceiver.this.outerObserver != null) {
                    RtpReceiver.this.isFirstPacketReceivedEventHandled = true;
                    RtpReceiver.this.outerObserver.onFirstPacketReceived(media_type);
                }
            }
        });
        this.nativeDecryptor = 0L;
        FinLog.i("RtpReceiver", "custom_crypto RtpReceiver constructor:" + nativeRtpReceiver + " decryptor:" + this.nativeDecryptor);
    }

    public MediaStreamTrack track() {
        return this.cachedTrack;
    }

    public boolean setParameters(RtpParameters parameters) {
        this.checkRtpReceiverExists();
        return parameters == null ? false : RtpReceiver.nativeSetParameters(this.nativeRtpReceiver, parameters);
    }

    public RtpParameters getParameters() {
        this.checkRtpReceiverExists();
        return RtpReceiver.nativeGetParameters(this.nativeRtpReceiver);
    }

    public String id() {
        this.checkRtpReceiverExists();
        return RtpReceiver.nativeGetId(this.nativeRtpReceiver);
    }

    @CalledByNative
    public void dispose() {
        this.checkRtpReceiverExists();
        this.cachedTrack.dispose();
        if (this.nativeObserver != 0L) {
            RtpReceiver.nativeUnsetObserver(this.nativeRtpReceiver, this.nativeObserver);
            this.nativeObserver = 0L;
        }
        this.releaseCustomFrameDecryptor();
        JniCommon.nativeReleaseRef(this.nativeRtpReceiver);
        this.nativeRtpReceiver = 0L;
    }

    private void releaseCustomFrameDecryptor() {
        if (this.nativeDecryptor != 0L) {
            RtpReceiver.nativeUnsetCustomFrameDecryptor(this.nativeRtpReceiver, this.nativeDecryptor);
            JniCommon.nativeReleaseRef(this.nativeDecryptor);
            this.nativeDecryptor = 0L;
        }
        if (this.disposeObserver != null) {
            this.disposeObserver.onDispose(this);
        }
    }

    public void SetObserver(Observer observer) {
        this.checkRtpReceiverExists();
        if (this.nativeObserver != 0L) {
            RtpReceiver.nativeUnsetObserver(this.nativeRtpReceiver, this.nativeObserver);
        }
        this.nativeObserver = RtpReceiver.nativeSetObserver(this.nativeRtpReceiver, observer);
    }

    public void setOuterObserver(Observer observer) {
        this.outerObserver = observer;
        if (!this.isFirstPacketReceivedEventHandled) {
            this.outerObserver.onFirstPacketReceived(null);
        }
    }

    public void setFrameDecryptor(FrameDecryptor frameDecryptor) {
        this.checkRtpReceiverExists();
        RtpReceiver.nativeSetFrameDecryptor(this.nativeRtpReceiver, frameDecryptor.getNativeFrameDecryptor());
    }

    public void setCustomFrameDecryptor(FrameDecryptor frameDecryptor) {
        this.checkRtpReceiverExists();
        if (frameDecryptor == null) {
            if (this.nativeDecryptor != 0L) {
                this.releaseCustomFrameDecryptor();
            }
        } else {
            this.nativeDecryptor = RtpReceiver.nativeSetCustomFrameDecryptor(this.nativeRtpReceiver, frameDecryptor.getNativeFrameDecryptor());
        }
    }

    public void setDisposeObserver(DisposeObserver disposeObserver) {
        this.disposeObserver = disposeObserver;
    }

    private void checkRtpReceiverExists() {
        if (this.nativeRtpReceiver == 0L) {
            throw new IllegalStateException("RtpReceiver has been disposed.");
        }
    }

    private static native long nativeGetTrack(long var0);

    private static native boolean nativeSetParameters(long var0, RtpParameters var2);

    private static native RtpParameters nativeGetParameters(long var0);

    private static native String nativeGetId(long var0);

    private static native long nativeSetObserver(long var0, Observer var2);

    private static native void nativeUnsetObserver(long var0, long var2);

    private static native void nativeSetFrameDecryptor(long var0, long var2);

    private static native long nativeSetCustomFrameDecryptor(long var0, long var2);

    private static native void nativeUnsetCustomFrameDecryptor(long var0, long var2);

    public static interface DisposeObserver {
        public void onDispose(RtpReceiver var1);
    }

    public static interface Observer {
        @CalledByNative(value="Observer")
        public void onFirstPacketReceived(MediaStreamTrack.MediaType var1);
    }
}

