/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine.tools;

import android.text.TextUtils;
import cn.rongcloud.rtc.api.RCRTCBaseRoom;
import cn.rongcloud.rtc.api.RCRTCEngine;
import cn.rongcloud.rtc.api.RCRTCOtherRoom;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.RCRTCRoom;
import cn.rongcloud.rtc.api.callback.IRCRTCFailedCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCOtherRoomEventsListener;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCRoomEventsListener;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.base.RCRTCLiveRole;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCResourceState;
import cn.rongcloud.rtc.base.RCRTCStream;
import cn.rongcloud.rtc.base.RCRTCSubscribeState;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.RCOtherRoomImpl;
import cn.rongcloud.rtc.center.RCRemoteUserImpl;
import cn.rongcloud.rtc.center.RCRoomImpl;
import cn.rongcloud.rtc.center.stream.RCInputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCRTCAudioInputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCVideoInputStreamImpl;
import cn.rongcloud.rtc.engine.InRoomState;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.engine.tools.MultiRoomManager;
import cn.rongcloud.rtc.engine.tools.multiroom.InviteMessageElement;
import cn.rongcloud.rtc.proxy.message.CancelInviteMessage;
import cn.rongcloud.rtc.proxy.message.EndInviteMessage;
import cn.rongcloud.rtc.proxy.message.InviteAnswerMessage;
import cn.rongcloud.rtc.proxy.message.InviteMessage;
import cn.rongcloud.rtc.proxy.message.InviteTimeoutMessage;
import cn.rongcloud.rtc.proxy.message.KickMessage;
import cn.rongcloud.rtc.proxy.message.ModifyResourceMessage;
import cn.rongcloud.rtc.proxy.message.PublishResourceMessage;
import cn.rongcloud.rtc.proxy.message.RoomUserStateMessage;
import cn.rongcloud.rtc.proxy.message.TotalContentResources;
import cn.rongcloud.rtc.proxy.message.UnPublishResourceMessage;
import cn.rongcloud.rtc.proxy.message.messagebeans.CDNResourceInfo;
import cn.rongcloud.rtc.proxy.message.messagebeans.InviteInfo;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.proxy.message.messagebeans.PKInfo;
import cn.rongcloud.rtc.proxy.message.messagebeans.UserState;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import io.rong.common.RLog;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class HandleRTCMsgTools {
    private static final String TAG = "HandleRTCMsgTools";
    private InRoomState mInRoomState;
    private RCRTCBaseRoom mBaseRoom;
    private MultiRoomManager mMultiRoomManager;
    private IRCRTCRoomEventsListener mMainRoomEventsListener;
    private IRCRTCOtherRoomEventsListener mOtherRoomEventsListener;
    private String mMainRoomId;

    public HandleRTCMsgTools(InRoomState inRoomState) {
        this.mInRoomState = inRoomState;
        this.mMultiRoomManager = this.mInRoomState.getMultiRoomManager();
        this.mMainRoomId = this.mInRoomState.getMultiRoomManager().getBaseRoomElemet().getMainRoomId();
    }

    public void handleRTCMessage(Message message) {
        MessageContent messageContent = message.getContent();
        String senderId = message.getSenderUserId();
        String targetId = message.getTargetId();
        FinLog.d(TAG, "[handleRTCMessage]  senderId : " + senderId + " , targetId :" + targetId + "  , mMainRoomId :" + this.mMainRoomId);
        this.mBaseRoom = this.mMultiRoomManager.getBaseRoomElemet().get(targetId);
        this.mMainRoomEventsListener = null;
        this.mOtherRoomEventsListener = null;
        boolean isMainRoom = true;
        if (this.mBaseRoom != null) {
            if (this.mBaseRoom instanceof RCRTCRoom) {
                this.mMainRoomEventsListener = ((RCRoomImpl)this.mBaseRoom).getEventsListener();
            } else if (this.mBaseRoom instanceof RCRTCOtherRoom) {
                isMainRoom = false;
                this.mOtherRoomEventsListener = ((RCOtherRoomImpl)this.mBaseRoom).getRCRoomListener();
            }
        } else {
            FinLog.e(TAG, "Room not joined. [handleRTCMessage]  senderId : " + senderId + " , RoomId :" + targetId + " , ObjectName : " + message.getObjectName() + ", MessageContent: " + new String(messageContent.encode()));
            return;
        }
        FinLog.d(TAG, "[handleRTCMessage] ObjectName: " + message.getObjectName() + ", MessageContent: " + new String(messageContent.encode()));
        if (messageContent instanceof PublishResourceMessage) {
            this.handlePublishResourceMessage(message, (PublishResourceMessage)messageContent);
        } else if (messageContent instanceof RoomUserStateMessage) {
            this.handleRoomUserStateMessage((RoomUserStateMessage)messageContent);
        } else if (messageContent instanceof ModifyResourceMessage) {
            this.handleModifyResourceMessage(message, (ModifyResourceMessage)messageContent);
        } else if (messageContent instanceof UnPublishResourceMessage) {
            this.handleUnPublishResourceMessage(message, (UnPublishResourceMessage)messageContent);
        } else if (messageContent instanceof KickMessage) {
            this.handleKickMessage(isMainRoom, (KickMessage)messageContent);
        } else if (messageContent instanceof TotalContentResources) {
            this.handleTotalContentResources(senderId, (TotalContentResources)messageContent);
        } else if (messageContent instanceof InviteMessage) {
            this.inviteNotify((InviteMessage)messageContent);
        } else if (messageContent instanceof InviteTimeoutMessage) {
            this.inviteTimeoutNotify((InviteTimeoutMessage)messageContent);
        } else if (messageContent instanceof InviteAnswerMessage) {
            if (TextUtils.equals((CharSequence)targetId, (CharSequence)this.mMainRoomId)) {
                this.inviteAnswerNotify((InviteAnswerMessage)messageContent);
            } else {
                FinLog.d(TAG, "InviteAnswer->ignore. rid :" + targetId);
            }
        } else if (messageContent instanceof CancelInviteMessage) {
            this.cancelInviteNotify((CancelInviteMessage)messageContent);
        } else if (messageContent instanceof EndInviteMessage) {
            this.endInviteNotify((EndInviteMessage)messageContent);
        } else {
            FinLog.i(TAG, "handleRTCMessage()->unKnownMessage " + message);
            if (this.mMainRoomEventsListener != null) {
                this.mMainRoomEventsListener.onReceiveMessage(message);
            } else if (this.mOtherRoomEventsListener != null) {
                this.mOtherRoomEventsListener.onReceiveMessage((RCRTCOtherRoom)this.mBaseRoom, message);
            }
        }
    }

    private void handleTotalContentResources(String senderId, TotalContentResources resources) {
        FinLog.d(TAG, "-- totalContentResourcesMessage --");
        RCRemoteUserImpl remoteUser = (RCRemoteUserImpl)this.mBaseRoom.getRemoteUser(senderId);
        if (remoteUser == null) {
            FinLog.e("ResourceTools", "TotalContentResources.remoteUser == null !");
            return;
        }
        List<CDNResourceInfo> cdn_uris = resources.getCDN_Uris();
        if (cdn_uris != null && cdn_uris.size() > 0) {
            CDNResourceInfo cdnInfo = cdn_uris.get(0);
            if (cdnInfo != null) {
                if (this.mBaseRoom instanceof RCRoomImpl) {
                    ((RCRoomImpl)this.mBaseRoom).updateCDNResourceInfo(this.mBaseRoom.getRoomId(), cdnInfo.getJsonObject().toString());
                } else if (this.mBaseRoom instanceof RCOtherRoomImpl && RCRTCEngine.getInstance().getRoom() != null) {
                    ((RCRoomImpl)RCRTCEngine.getInstance().getRoom()).updateCDNResourceInfo(this.mBaseRoom.getRoomId(), cdnInfo.getJsonObject().toString());
                }
            }
        } else {
            FinLog.d("ResourceTools", "cdn_uris is empty.");
        }
        List<MediaResourceInfo> resourceInfoList = resources.getMediaResourceInfo();
        List<RCRTCInputStream> inputStreamList = remoteUser.getStreams();
        if (RongRTCUtils.isEmpty(resourceInfoList) && !RongRTCUtils.isEmpty(inputStreamList)) {
            remoteUser.clearStream();
            FinLog.i(TAG, "Unpublish all. size :" + inputStreamList.size());
            this.resubscribeAVStream(remoteUser, inputStreamList, null);
            return;
        }
        if (RongRTCUtils.isEmpty(inputStreamList) && !RongRTCUtils.isEmpty(resourceInfoList)) {
            ArrayList<RCRTCInputStream> publishResource = new ArrayList<RCRTCInputStream>();
            for (MediaResourceInfo mediaResourceInfo : resourceInfoList) {
                RCRTCInputStream avInputStream = this.createRTCInputStream(remoteUser.getUserId(), mediaResourceInfo);
                publishResource.add(avInputStream);
                remoteUser.addStream(avInputStream);
            }
            if (this.mMainRoomEventsListener != null) {
                FinLog.d(TAG, "Publish all resources. size :" + publishResource.size() + " , senderId :" + senderId);
                this.mMainRoomEventsListener.onRemoteUserPublishResource(remoteUser, publishResource);
            } else if (this.mOtherRoomEventsListener != null) {
                FinLog.d(TAG, "Publish all resources. size :" + publishResource.size() + " , senderId :" + senderId + " , Room : " + this.mBaseRoom.getRoomId());
                this.mOtherRoomEventsListener.onRemoteUserPublishResource((RCRTCOtherRoom)this.mBaseRoom, remoteUser, publishResource);
            }
            return;
        }
        ArrayList<RCRTCInputStream> needUnsubList = new ArrayList<RCRTCInputStream>();
        for (RCRTCInputStream inputStream : inputStreamList) {
            boolean isUnpub = false;
            for (MediaResourceInfo resourceInfo : resourceInfoList) {
                if (inputStream.getMediaType() == resourceInfo.getType() && inputStream.getStreamId().equals(resourceInfo.getStreamId())) {
                    isUnpub = false;
                    break;
                }
                isUnpub = true;
            }
            if (!isUnpub || needUnsubList.contains(inputStream)) continue;
            FinLog.i(TAG, "needUnpub. MediaId : " + inputStream.getStreamId() + " , RCRTCMediaType : " + (Object)((Object)inputStream.getMediaType()));
            needUnsubList.add(inputStream);
            remoteUser.removeStream(inputStream.getStreamId(), inputStream.getMediaType());
        }
        ArrayList<RCRTCInputStream> needPubList = null;
        ArrayList<RCRTCInputStream> needResubscribeList = null;
        for (MediaResourceInfo resourceInfo : resourceInfoList) {
            RCRTCInputStream inputStream = remoteUser.getStream(resourceInfo.getTag(), resourceInfo.getType());
            if (inputStream != null) {
                if (inputStream.getResourceState().getValue() != resourceInfo.getRCRTCResourceState().getValue()) {
                    ((RCInputStreamImpl)inputStream).setResourceState(resourceInfo.getRCRTCResourceState());
                    FinLog.i(TAG, "modifyResource. MediaId :" + inputStream.getStreamId() + ", RCRTCMediaType :" + (Object)((Object)inputStream.getMediaType()));
                    this.modifyListener(remoteUser, inputStream);
                }
                if (inputStream.getUri().equals(resourceInfo.getUri())) continue;
                FinLog.i(TAG, "drift : " + inputStream.getUri() + " --> " + resourceInfo.getUri());
                if (((RCInputStreamImpl)inputStream).getSubscribeState() == RCRTCSubscribeState.SUBSCRIBED) {
                    if (needResubscribeList == null) {
                        needResubscribeList = new ArrayList<RCRTCInputStream>();
                    }
                    ((RCInputStreamImpl)inputStream).setUri(resourceInfo.getUri());
                    needResubscribeList.add(inputStream);
                    continue;
                }
                ((RCInputStreamImpl)inputStream).setUri(resourceInfo.getUri());
                ((RCInputStreamImpl)inputStream).setResourceState(resourceInfo.getRCRTCResourceState());
                ((RCInputStreamImpl)inputStream).setStreamId(resourceInfo.getStreamId());
                ((RCInputStreamImpl)inputStream).setMediaType(resourceInfo.getType());
                ((RCInputStreamImpl)inputStream).setTag(resourceInfo.getTag());
                FinLog.i(TAG, "refresh cache. MediaId :" + inputStream.getStreamId() + ", RCRTCMediaType :" + (Object)((Object)inputStream.getMediaType()));
                continue;
            }
            if (needPubList == null) {
                needPubList = new ArrayList<RCRTCInputStream>();
            }
            RCRTCInputStream avInputStream = this.createRTCInputStream(remoteUser.getUserId(), resourceInfo);
            remoteUser.addStream(avInputStream);
            needPubList.add(avInputStream);
        }
        this.resubscribeAVStream(remoteUser, needUnsubList, needResubscribeList);
        if (!RongRTCUtils.isEmpty(needPubList)) {
            int pubSize = 0;
            if (needPubList != null) {
                pubSize = needPubList.size();
            }
            FinLog.i(TAG, remoteUser.getUserId() + " , Number of resources published : " + pubSize + " , mEventsListener :" + (this.mMainRoomEventsListener == null));
            if (this.mMainRoomEventsListener != null) {
                this.mMainRoomEventsListener.onRemoteUserPublishResource(remoteUser, needPubList);
            } else if (this.mOtherRoomEventsListener != null) {
                this.mOtherRoomEventsListener.onRemoteUserPublishResource((RCRTCOtherRoom)this.mBaseRoom, remoteUser, needPubList);
            }
        }
    }

    private void resubscribeAVStream(RCRTCRemoteUser remoteUser, List<RCRTCInputStream> needUnsubList, List<RCRTCInputStream> needResubscribeList) {
        if (!RongRTCUtils.isEmpty(needUnsubList)) {
            if (this.mMainRoomEventsListener != null) {
                this.mMainRoomEventsListener.onRemoteUserUnpublishResource(remoteUser, needUnsubList);
            } else if (this.mOtherRoomEventsListener != null) {
                this.mOtherRoomEventsListener.onRemoteUserUnpublishResource((RCRTCOtherRoom)this.mBaseRoom, remoteUser, needUnsubList);
            }
        }
        if (!RongRTCUtils.isEmpty(needUnsubList) || !RongRTCUtils.isEmpty(needResubscribeList)) {
            this.mInRoomState.getPubSubQueue().offer(4, null, null);
        }
    }

    private void modifyListener(RCRTCRemoteUser remoteUser, RCRTCInputStream inputStream) {
        FinLog.d(TAG, "remoteUser : " + remoteUser.getUserId() + " , MediaTyp : " + inputStream.getMediaType().getDescription() + " , ResourceState :" + (Object)((Object)inputStream.getResourceState()));
        if (inputStream.getMediaType().equals((Object)RCRTCMediaType.AUDIO)) {
            if (this.mMainRoomEventsListener != null) {
                this.mMainRoomEventsListener.onRemoteUserMuteAudio(remoteUser, inputStream, !inputStream.getResourceState().equals((Object)RCRTCResourceState.NORMAL));
            } else if (this.mOtherRoomEventsListener != null) {
                this.mOtherRoomEventsListener.onRemoteUserMuteAudio((RCRTCOtherRoom)this.mBaseRoom, remoteUser, inputStream, !inputStream.getResourceState().equals((Object)RCRTCResourceState.NORMAL));
            }
        } else if (inputStream.getMediaType().equals((Object)RCRTCMediaType.VIDEO)) {
            if (this.mMainRoomEventsListener != null) {
                this.mMainRoomEventsListener.onRemoteUserMuteVideo(remoteUser, inputStream, !inputStream.getResourceState().equals((Object)RCRTCResourceState.NORMAL));
            } else if (this.mOtherRoomEventsListener != null) {
                this.mOtherRoomEventsListener.onRemoteUserMuteVideo((RCRTCOtherRoom)this.mBaseRoom, remoteUser, inputStream, !inputStream.getResourceState().equals((Object)RCRTCResourceState.NORMAL));
            }
        }
    }

    private void handleKickMessage(boolean isMainRoom, KickMessage message) {
        String roomId = this.mBaseRoom.getRoomId();
        if (RTCEngineImpl.getInstance().getEngineEventListener() != null) {
            RCRTCParamsType.RCRTCKickedReason kickedReason = RCRTCParamsType.RCRTCKickedReason.SERVER;
            if (message.getUserInfoArrayList().size() > 0) {
                int type = message.getUserInfoArrayList().get(0).getType();
                ReportUtil.libStatus(ReportUtil.TAG.KICKEDFROMSERVER, "type", type);
                if (type == 1) {
                    kickedReason = RCRTCParamsType.RCRTCKickedReason.SERVER;
                } else if (type == 2) {
                    kickedReason = RCRTCParamsType.RCRTCKickedReason.OTHER_CLIENT_LOGIN;
                }
            }
            RTCEngineImpl.getInstance().getEngineEventListener().onKicked(roomId, kickedReason);
        }
        if (isMainRoom) {
            ReportUtil.libStatus(ReportUtil.TAG.KICKEDFROMSERVER, "desc", "kicked from server.MainRoom");
            this.mInRoomState.releaseRoom(null, false);
        } else {
            ReportUtil.libStatus(ReportUtil.TAG.KICKEDFROMSERVER, "desc", "kicked from server.otherRoomId : " + roomId);
            this.mInRoomState.kickFromOtherRooms(roomId);
        }
    }

    private void handleUnPublishResourceMessage(Message message, UnPublishResourceMessage publishResourceMessage) {
        FinLog.i(TAG, "handleUnPublishResourceMessage ");
        RCRemoteUserImpl remoteUser = (RCRemoteUserImpl)this.mBaseRoom.getRemoteUser(message.getSenderUserId());
        if (remoteUser == null) {
            FinLog.e(TAG, "handleUnPublishResourceMessage Failed remoteUser is Null, uid+" + message.getSenderUserId());
            return;
        }
        if (publishResourceMessage.isIgnore()) {
            FinLog.d(TAG, "handleUnPublishResourceMessage->ignore. uid :" + message.getUId());
            return;
        }
        ArrayList<RCRTCInputStream> unPublishResource = new ArrayList<RCRTCInputStream>();
        if (publishResourceMessage.getUnPublishResource() != null) {
            for (MediaResourceInfo mediaResourceInfo : publishResourceMessage.getUnPublishResource()) {
                RCRTCInputStream rongRTCAVInputStream = remoteUser.getStream(mediaResourceInfo.getTag(), mediaResourceInfo.getType());
                if (rongRTCAVInputStream == null) continue;
                unPublishResource.add(rongRTCAVInputStream);
                remoteUser.removeStream(rongRTCAVInputStream.getStreamId(), rongRTCAVInputStream.getMediaType());
            }
        }
        if (!unPublishResource.isEmpty()) {
            if (this.mMainRoomEventsListener != null) {
                this.mMainRoomEventsListener.onRemoteUserUnpublishResource(remoteUser, unPublishResource);
            } else if (this.mOtherRoomEventsListener != null) {
                this.mOtherRoomEventsListener.onRemoteUserUnpublishResource((RCRTCOtherRoom)this.mBaseRoom, remoteUser, unPublishResource);
            }
            this.mInRoomState.getPubSubQueue().offer(5, (List<? extends RCRTCStream>)unPublishResource, false, (IRCRTCFailedCallback)new IRCRTCResultCallback(){

                @Override
                public void onSuccess() {
                    FinLog.v(HandleRTCMsgTools.TAG, "unSubscribeResouce onUiSuccess()");
                }

                @Override
                public void onFailed(RTCErrorCode errorCode) {
                    FinLog.e(HandleRTCMsgTools.TAG, "unSubscribeResouce onUiFailed() errorCode: " + (Object)((Object)errorCode));
                }
            });
        } else {
            FinLog.i(TAG, "unPublishResource size is 0,no need notify.");
        }
    }

    private void handleModifyResourceMessage(Message message, ModifyResourceMessage modifyResourceMessage) {
        RCRTCRemoteUser remoteUser = this.mBaseRoom.getRemoteUser(message.getSenderUserId());
        if (remoteUser == null) {
            FinLog.e(TAG, "handleModifyResourceMessage Failed remoteUser is Null, uid+" + message.getSenderUserId());
            return;
        }
        if (modifyResourceMessage.isIgnore()) {
            FinLog.d("ReConnectTool", "handleModifyResourceMessage->ignore. uid :" + message.getUId());
            return;
        }
        if (modifyResourceMessage.getModifyResource() != null) {
            for (MediaResourceInfo mediaResourceInfo : modifyResourceMessage.getModifyResource()) {
                RCInputStreamImpl rongRTCAVInputStream;
                if (TextUtils.isEmpty((CharSequence)mediaResourceInfo.getUri()) || (rongRTCAVInputStream = (RCInputStreamImpl)remoteUser.getStream(mediaResourceInfo.getTag(), mediaResourceInfo.getType())) == null) continue;
                rongRTCAVInputStream.setResourceState(mediaResourceInfo.getRCRTCResourceState());
                this.modifyListener(remoteUser, rongRTCAVInputStream);
            }
        }
    }

    private void handleRoomUserStateMessage(RoomUserStateMessage roomUserStateMessage) {
        List<UserState> userStateList = roomUserStateMessage.getUserStates();
        FinLog.d(TAG, "RoomUserStateMessage userStateList.size() = " + (userStateList == null ? 0 : userStateList.size()));
        if (RongRTCUtils.isEmpty(userStateList)) {
            return;
        }
        for (UserState userState : userStateList) {
            UserState.State state = userState.getState();
            RCRTCLiveRole liveRole = userState.getLiveRole();
            String sourceRoomId = userState.getSourceRoomId();
            String userId = userState.getUserId();
            FinLog.i(TAG, "state :" + (Object)((Object)userState.getState()) + " ,userId = " + userId + " , SourceRoomId : " + sourceRoomId + " , liveRole : " + (liveRole == null ? "" : liveRole.name()));
            switch (state) {
                case JOIN: {
                    RCRTCRemoteUser remoteUser = this.mBaseRoom.getRemoteUser(userId);
                    FinLog.i(TAG, "TargetRoomId :" + this.mBaseRoom.getRoomId() + " , MainRoomId :" + this.mMainRoomId);
                    if (this.mBaseRoom instanceof RCOtherRoomImpl) {
                        if (!TextUtils.isEmpty((CharSequence)sourceRoomId)) break;
                        remoteUser = this.addRemoteUser(remoteUser, userState, liveRole);
                        if (this.mOtherRoomEventsListener == null) break;
                        if (liveRole != null) {
                            this.mOtherRoomEventsListener.onSwitchRole(remoteUser.getUserId(), liveRole);
                            break;
                        }
                        this.mOtherRoomEventsListener.onUserJoined((RCRTCOtherRoom)this.mBaseRoom, remoteUser);
                        break;
                    }
                    if (this.mBaseRoom instanceof RCRoomImpl && TextUtils.isEmpty((CharSequence)sourceRoomId)) {
                        remoteUser = this.addRemoteUser(remoteUser, userState, liveRole);
                        if (this.mMainRoomEventsListener == null) break;
                        if (liveRole != null) {
                            this.mMainRoomEventsListener.onSwitchRole(remoteUser.getUserId(), liveRole);
                            break;
                        }
                        this.mMainRoomEventsListener.onUserJoined(remoteUser);
                        break;
                    }
                    if (!(this.mBaseRoom instanceof RCRoomImpl) || TextUtils.isEmpty((CharSequence)sourceRoomId)) break;
                    this.OtherRoomUsersJoinMyRoom(sourceRoomId, userId);
                    break;
                }
                case LEFT: 
                case OFFLINE: {
                    this.onUserLeftOrOffline(userId, state, liveRole);
                    break;
                }
            }
        }
    }

    private void OtherRoomUsersJoinMyRoom(String sourceRoomId, String userId) {
        ((RCRoomImpl)this.mBaseRoom).addOtherRoomId(sourceRoomId);
        RCRTCBaseRoom rcrtcBaseRoom = null;
        if (this.mMultiRoomManager != null && this.mMultiRoomManager.getBaseRoomElemet() != null && (rcrtcBaseRoom = this.mMultiRoomManager.getBaseRoomElemet().get(sourceRoomId)) != null) {
            RCRTCRemoteUser remoteUser = rcrtcBaseRoom.getRemoteUser(userId);
            if (remoteUser == null) {
                remoteUser = new RCRemoteUserImpl(userId, "");
            }
            ReportUtil.libStatus(ReportUtil.TAG.ONREMOTEUSERJOINED, "uid|sourceRoomId|desc", userId, sourceRoomId, "People from other rooms joined my main room");
            RTCEngineImpl.getInstance().sendMessage(5077, rcrtcBaseRoom, remoteUser);
        } else {
            ReportUtil.libError(ReportUtil.TAG.ONREMOTEUSERJOINED, "uid|sourceRoomId|desc", userId, sourceRoomId, "People from other rooms joined my main room, but I did not join other rooms");
        }
    }

    private void onUserLeftOrOffline(String userId, UserState.State state, RCRTCLiveRole liveRole) {
        if (this.mBaseRoom instanceof RCRoomImpl) {
            boolean isSwitchRoleNotification;
            FinLog.i(TAG, "TargetRoomId :" + this.mBaseRoom.getRoomId() + " , userId :" + userId + " , MainRoomId :" + this.mMainRoomId);
            RCRTCRemoteUser remoteUser = this.mBaseRoom.getRemoteUser(userId);
            boolean bl = isSwitchRoleNotification = liveRole != null;
            if (remoteUser != null) {
                this.removeRemoteUser(this.mBaseRoom, remoteUser.getUserId());
                if (this.mMainRoomEventsListener != null) {
                    if (state == UserState.State.LEFT) {
                        if (isSwitchRoleNotification) {
                            this.mMainRoomEventsListener.onSwitchRole(remoteUser.getUserId(), liveRole);
                        } else {
                            this.mMainRoomEventsListener.onUserLeft(remoteUser);
                        }
                    } else if (state == UserState.State.OFFLINE) {
                        this.mMainRoomEventsListener.onUserOffline(remoteUser);
                    }
                }
                this.mInRoomState.userLeft();
            } else {
                RCRTCBaseRoom rcrtcBaseRoom = this.mMultiRoomManager.getBaseRoomElemet().getRoomByUserId(userId);
                if (rcrtcBaseRoom != null) {
                    remoteUser = rcrtcBaseRoom.getRemoteUser(userId);
                    if (remoteUser != null) {
                        this.removeRemoteUser(rcrtcBaseRoom, remoteUser.getUserId());
                        boolean isOtherRoom = rcrtcBaseRoom instanceof RCOtherRoomImpl;
                        FinLog.d(TAG, "isOtherRoom : " + isOtherRoom + ", roomId : " + rcrtcBaseRoom.getRoomId() + " , userId : " + userId + " , isOtherRoom : " + isOtherRoom);
                        if (isOtherRoom) {
                            boolean registeredListener;
                            boolean bl2 = registeredListener = ((RCOtherRoomImpl)rcrtcBaseRoom).getRCRoomListener() != null;
                            if (isOtherRoom && registeredListener) {
                                if (state == UserState.State.LEFT) {
                                    if (isSwitchRoleNotification) {
                                        ((RCOtherRoomImpl)rcrtcBaseRoom).getRCRoomListener().onSwitchRole(remoteUser.getUserId(), liveRole);
                                    } else {
                                        ((RCOtherRoomImpl)rcrtcBaseRoom).getRCRoomListener().onUserLeft((RCOtherRoomImpl)rcrtcBaseRoom, remoteUser);
                                    }
                                } else if (state == UserState.State.OFFLINE) {
                                    ((RCOtherRoomImpl)rcrtcBaseRoom).getRCRoomListener().onUserOffline((RCOtherRoomImpl)rcrtcBaseRoom, remoteUser);
                                }
                            }
                        }
                        this.mInRoomState.userLeft();
                    } else {
                        FinLog.w(TAG, "User not found. uid :" + userId + " , RID\uff1a " + rcrtcBaseRoom.getRoomId());
                    }
                } else {
                    FinLog.w(TAG, "rcrtcBaseRoom is empty.");
                }
            }
        } else {
            RCRTCRemoteUser remoteUser = this.mBaseRoom.getRemoteUser(userId);
            if (remoteUser != null) {
                this.removeRemoteUser(this.mBaseRoom, remoteUser.getUserId());
                if (this.mOtherRoomEventsListener != null) {
                    if (state == UserState.State.LEFT) {
                        this.mOtherRoomEventsListener.onUserLeft((RCRTCOtherRoom)this.mBaseRoom, remoteUser);
                    } else if (state == UserState.State.OFFLINE) {
                        this.mOtherRoomEventsListener.onUserOffline((RCRTCOtherRoom)this.mBaseRoom, remoteUser);
                    }
                }
                this.mInRoomState.userLeft();
            }
        }
    }

    private RCRTCRemoteUser addRemoteUser(RCRTCRemoteUser remoteUser, UserState userState, RCRTCLiveRole liveRole) {
        if (remoteUser == null) {
            remoteUser = new RCRemoteUserImpl(userState.getUserId(), "");
            this.addRemoteUser(this.mBaseRoom, remoteUser);
        }
        return remoteUser;
    }

    private void handlePublishResourceMessage(Message message, PublishResourceMessage msgContent) {
        FinLog.d(TAG, "handlePublishResourceMessage ");
        String senderId = message.getSenderUserId();
        RCRemoteUserImpl remoteUser = (RCRemoteUserImpl)this.mBaseRoom.getRemoteUser(senderId);
        if (msgContent.isIgnore()) {
            FinLog.d(TAG, "pub->ignore. uid :" + message.getUId());
            return;
        }
        final List<MediaResourceInfo> publishResourceList = msgContent.getPublishResource();
        if (publishResourceList == null) {
            FinLog.e(TAG, "publishResourceList is null !");
            return;
        }
        FinLog.i(TAG, "remote publish resource info: " + publishResourceList);
        if (remoteUser != null) {
            final RCRemoteUserImpl finalRemoteUser = remoteUser;
            List<RCRTCInputStream> needUnSubscribeStreams = this.filterExceptionalStreams(remoteUser.getStreams(), publishResourceList);
            if (!RongRTCUtils.isEmpty(needUnSubscribeStreams)) {
                FinLog.i(TAG, "PublishResourceMessage have exceptionalStreams,first need unSubscribe");
                this.mInRoomState.getPubSubQueue().offer(5, remoteUser.getStreams(), false, (IRCRTCFailedCallback)new IRCRTCResultCallback(){

                    @Override
                    public void onSuccess() {
                        ArrayList<RCRTCInputStream> publishResource = new ArrayList<RCRTCInputStream>();
                        List<RCRTCInputStream> remoteAVStreams = finalRemoteUser.getStreams();
                        for (Object mediaResourceInfo : publishResourceList) {
                            boolean isNew = true;
                            for (RCRTCInputStream stream : remoteAVStreams) {
                                if (stream.getMediaType() != ((MediaResourceInfo)mediaResourceInfo).getType() || !((MediaResourceInfo)mediaResourceInfo).getTag().equals(stream.getTag())) continue;
                                RCInputStreamImpl inputStream = (RCInputStreamImpl)stream;
                                isNew = false;
                                inputStream.setStreamId(((MediaResourceInfo)mediaResourceInfo).getStreamId());
                                inputStream.setUri(((MediaResourceInfo)mediaResourceInfo).getUri());
                                inputStream.setResourceState(((MediaResourceInfo)mediaResourceInfo).getRCRTCResourceState());
                                publishResource.add(stream);
                            }
                            if (!isNew) continue;
                            RCRTCInputStream avInputStream = HandleRTCMsgTools.this.createRTCInputStream(finalRemoteUser.getUserId(), (MediaResourceInfo)mediaResourceInfo);
                            publishResource.add(avInputStream);
                            finalRemoteUser.addStream(avInputStream);
                            FinLog.i(HandleRTCMsgTools.TAG, "remote-user-" + finalRemoteUser.getUserId() + " publish: " + mediaResourceInfo);
                        }
                        for (RCRTCInputStream stream : remoteAVStreams) {
                            boolean has = false;
                            for (MediaResourceInfo info : publishResourceList) {
                                if (stream.getMediaType() != info.getType() || !TextUtils.equals((CharSequence)stream.getTag(), (CharSequence)info.getTag())) continue;
                                has = true;
                                break;
                            }
                            if (has) continue;
                            finalRemoteUser.removeStream(stream.getStreamId(), stream.getMediaType());
                        }
                        if (HandleRTCMsgTools.this.mBaseRoom != null) {
                            IRCRTCOtherRoomEventsListener roomListener;
                            if (HandleRTCMsgTools.this.mBaseRoom instanceof RCRTCRoom) {
                                IRCRTCRoomEventsListener roomEventsListener = ((RCRoomImpl)HandleRTCMsgTools.this.mBaseRoom).getEventsListener();
                                if (roomEventsListener != null) {
                                    roomEventsListener.onRemoteUserPublishResource(finalRemoteUser, publishResource);
                                }
                            } else if (!(HandleRTCMsgTools.this.mBaseRoom instanceof RCRTCOtherRoom) || (roomListener = ((RCOtherRoomImpl)HandleRTCMsgTools.this.mBaseRoom).getRCRoomListener()) != null) {
                                // empty if block
                            }
                        }
                    }

                    @Override
                    public void onFailed(RTCErrorCode errorCode) {
                        FinLog.e(HandleRTCMsgTools.TAG, "PublishResourceMessage unsubscribeAVStream failed");
                    }
                });
            } else if (this.needNotifyPublishResource(remoteUser.getStreams(), publishResourceList)) {
                ArrayList<RCRTCInputStream> publishResource = new ArrayList<RCRTCInputStream>();
                for (MediaResourceInfo mediaResourceInfo : publishResourceList) {
                    RCRTCInputStream avInputStream = this.createRTCInputStream(remoteUser.getUserId(), mediaResourceInfo);
                    publishResource.add(avInputStream);
                    remoteUser.addStream(avInputStream);
                }
                if (this.mMainRoomEventsListener != null) {
                    this.mMainRoomEventsListener.onRemoteUserPublishResource(finalRemoteUser, publishResource);
                } else if (this.mOtherRoomEventsListener != null) {
                    this.mOtherRoomEventsListener.onRemoteUserPublishResource((RCRTCOtherRoom)this.mBaseRoom, finalRemoteUser, publishResource);
                }
            } else {
                RLog.e((String)TAG, (String)"PublishResourceMessage no need notifyPublishResource");
            }
        } else {
            remoteUser = new RCRemoteUserImpl(senderId, "");
            this.addRemoteUser(this.mBaseRoom, remoteUser);
            ArrayList<RCRTCInputStream> publishResource = new ArrayList<RCRTCInputStream>();
            for (MediaResourceInfo mediaResourceInfo : publishResourceList) {
                RCRTCInputStream avInputStream = this.createRTCInputStream(senderId, mediaResourceInfo);
                remoteUser.addStream(avInputStream);
                publishResource.add(avInputStream);
            }
            if (this.mMainRoomEventsListener != null) {
                this.mMainRoomEventsListener.onRemoteUserPublishResource(remoteUser, publishResource);
            } else if (this.mOtherRoomEventsListener != null) {
                this.mOtherRoomEventsListener.onRemoteUserPublishResource((RCRTCOtherRoom)this.mBaseRoom, remoteUser, publishResource);
            }
        }
    }

    private List<RCRTCInputStream> filterExceptionalStreams(List<RCRTCInputStream> remoteStreams, List<MediaResourceInfo> publishResourceList) {
        ArrayList<RCRTCInputStream> needUnSubscribeStreams = new ArrayList<RCRTCInputStream>();
        if (!RongRTCUtils.isEmpty(remoteStreams) && !RongRTCUtils.isEmpty(publishResourceList)) {
            for (MediaResourceInfo mediaResourceInfo : publishResourceList) {
                for (RCRTCInputStream rongRTCAVInputStream : remoteStreams) {
                    if (!mediaResourceInfo.getType().equals((Object)rongRTCAVInputStream.getMediaType()) || !mediaResourceInfo.getTag().equals(rongRTCAVInputStream.getTag()) || ((RCInputStreamImpl)rongRTCAVInputStream).getSubscribeState() != RCRTCSubscribeState.SUBSCRIBED) continue;
                    needUnSubscribeStreams.add(rongRTCAVInputStream);
                }
            }
        }
        return needUnSubscribeStreams;
    }

    private boolean needNotifyPublishResource(List<RCRTCInputStream> remoteStreams, List<MediaResourceInfo> publishResourceList) {
        if (!RongRTCUtils.isEmpty(publishResourceList)) {
            if (!RongRTCUtils.isEmpty(remoteStreams)) {
                for (MediaResourceInfo mediaResourceInfo : publishResourceList) {
                    boolean alreadyHave = false;
                    for (RCRTCInputStream rongRTCAVInputStream : remoteStreams) {
                        if (!mediaResourceInfo.getType().equals((Object)rongRTCAVInputStream.getMediaType()) || !mediaResourceInfo.getTag().equals(rongRTCAVInputStream.getTag())) continue;
                        alreadyHave = true;
                        break;
                    }
                    if (alreadyHave) continue;
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private RCRTCInputStream createRTCInputStream(String senderId, MediaResourceInfo mediaResourceInfo) {
        return mediaResourceInfo.getType() == RCRTCMediaType.VIDEO ? new RCVideoInputStreamImpl(senderId, mediaResourceInfo) : new RCRTCAudioInputStreamImpl(senderId, mediaResourceInfo);
    }

    private void addRemoteUser(RCRTCBaseRoom baseRoom, RCRTCRemoteUser remoteUser) {
        if (baseRoom != null) {
            if (baseRoom instanceof RCRoomImpl) {
                ((RCRoomImpl)baseRoom).addRemoteUser(remoteUser);
            } else if (baseRoom instanceof RCOtherRoomImpl) {
                ((RCOtherRoomImpl)baseRoom).addRemoteUser(remoteUser);
            }
        }
    }

    private void removeRemoteUser(RCRTCBaseRoom baseRoom, String remoteUserId) {
        if (baseRoom != null) {
            if (baseRoom instanceof RCRoomImpl) {
                ((RCRoomImpl)baseRoom).removeRemoteUser(remoteUserId);
            } else if (baseRoom instanceof RCOtherRoomImpl) {
                ((RCOtherRoomImpl)baseRoom).removeRemoteUser(remoteUserId);
            }
        }
    }

    private void endInviteNotify(EndInviteMessage messageContent) {
        String inviteInfo;
        ReportUtil.libStatus(ReportUtil.TAG.END_INVITE, "EndInviteMessage", messageContent != null ? messageContent.toString() : "null");
        String string = inviteInfo = messageContent != null ? messageContent.getInviteInfo() : "";
        if (!TextUtils.isEmpty((CharSequence)inviteInfo)) {
            String extra = "";
            String roomId = "";
            String userId = "";
            try {
                JSONObject obj = new JSONObject(inviteInfo);
                if (!this.mMainRoomId.equals(obj.optString("inviterRoomId"))) {
                    roomId = obj.optString("inviterRoomId");
                    userId = obj.optString("userId");
                } else if (!this.mMainRoomId.equals(obj.optString("inviteeRoomId"))) {
                    roomId = obj.optString("inviteeRoomId");
                    userId = obj.optString("userId");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            if (this.mBaseRoom instanceof RCRoomImpl) {
                ((RCRoomImpl)this.mBaseRoom).removeOtherRoomId(roomId);
                this.mMultiRoomManager.getRoomAttributesElement().remove(roomId);
            }
            if (!TextUtils.isEmpty((CharSequence)roomId) && !TextUtils.isEmpty((CharSequence)userId) && this.mMainRoomEventsListener != null) {
                this.mMainRoomEventsListener.onFinishOtherRoom(roomId, userId);
            }
        }
    }

    private void inviteTimeoutNotify(InviteTimeoutMessage messageContent) {
        messageContent.getInviteSessionId();
        String inviteInfo = messageContent.getInviteInfo();
        if (!TextUtils.isEmpty((CharSequence)inviteInfo)) {
            String inviterRoomId = "";
            String inviterUserId = "";
            String inviteeUserId = "";
            String inviteeRoomId = "";
            try {
                JSONObject obj = new JSONObject(inviteInfo);
                if (obj.has("inviterRoomId")) {
                    inviterRoomId = obj.getString("inviterRoomId");
                }
                if (obj.has("inviterUserId")) {
                    inviterUserId = obj.getString("inviterUserId");
                    this.mMultiRoomManager.getInviteNotifyMessageElement().remove(inviterUserId);
                }
                if (obj.has("inviteeUserId")) {
                    inviteeUserId = obj.getString("inviteeUserId");
                    InviteMessageElement.InviteTimeoutStatistics inviteTimeoutStatistics = this.mMultiRoomManager.getInviteMessageElement().remove(inviteeUserId);
                    if (inviteTimeoutStatistics != null) {
                        long endInviteTime = System.currentTimeMillis();
                        long timeout = endInviteTime - inviteTimeoutStatistics.getStartInviteTime();
                        ReportUtil.appRes(ReportUtil.TAG.INVITETIMEOUT, RongRTCUtils.append("inviteeRoomId", "inviteeUserId", "endInviteTime", "timeout"), inviteeRoomId, inviteeUserId, endInviteTime, timeout);
                    }
                }
                if (obj.has("inviteeRoomId")) {
                    inviteeRoomId = obj.getString("inviteeRoomId");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void cancelInviteNotify(CancelInviteMessage messageContent) {
        String inviteInfo;
        ReportUtil.libStatus(ReportUtil.TAG.CANCEL_INVITE, "CancelInviteMessage", messageContent != null ? messageContent.toString() : "null");
        String string = inviteInfo = messageContent != null ? messageContent.getInviteInfo() : "";
        if (!TextUtils.isEmpty((CharSequence)inviteInfo)) {
            String extra = "";
            String inviterRoomId = "";
            String inviterUserId = "";
            try {
                JSONObject obj = new JSONObject(inviteInfo);
                if (obj.has("inviterRoomId")) {
                    inviterRoomId = obj.getString("inviterRoomId");
                }
                if (obj.has("inviterUserId")) {
                    inviterUserId = obj.getString("inviterUserId");
                    this.mMultiRoomManager.getInviteNotifyMessageElement().remove(inviterUserId);
                }
                if (obj.has("extra")) {
                    extra = obj.getString("extra");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            if (!TextUtils.isEmpty((CharSequence)inviterRoomId) && !TextUtils.isEmpty((CharSequence)inviterUserId) && this.mMainRoomEventsListener != null) {
                this.mMainRoomEventsListener.onCancelRequestOtherRoom(inviterRoomId, inviterUserId, extra);
            }
        }
    }

    private void inviteAnswerNotify(InviteAnswerMessage messageContent) {
        ReportUtil.libStatus(ReportUtil.TAG.ANSWER_INVITE, "InviteAnswerMessage", messageContent != null ? messageContent.toString() : "null");
        if (messageContent == null) {
            FinLog.e(TAG, "inviteAnswerNotify . InviteAnswerMessage is empty .");
            return;
        }
        int answerCode = messageContent.getAnswerCode();
        String inviteContent = messageContent.getInviteContent();
        PKInfo info = messageContent.getPKInfo();
        String extra = "";
        String inviteeRoomId = "";
        String inviteeUserId = "";
        String inviterRoomId = "";
        String inviterUserId = "";
        if (info != null) {
            if (answerCode == 1) {
                this.mMultiRoomManager.getRoomAttributesElement().put(info);
            }
            inviteeRoomId = info.getInviteeRoomId();
            inviteeUserId = info.getInviteeUserId();
            inviterRoomId = info.getInviterRoomId();
            inviterUserId = info.getInviterUserId();
        } else {
            FinLog.e(TAG, "inviteAnswerNotify.KV is empty.inviteContent: " + inviteContent);
        }
        if (!TextUtils.isEmpty((CharSequence)inviteContent)) {
            try {
                JSONObject obj = new JSONObject(inviteContent);
                if (obj.has("extra")) {
                    extra = obj.getString("extra");
                }
                if (obj.has("inviteeUserId")) {
                    inviteeUserId = obj.getString("inviteeUserId");
                }
                if (obj.has("inviteeRoomId")) {
                    inviteeRoomId = obj.getString("inviteeRoomId");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (!TextUtils.isEmpty((CharSequence)inviteeRoomId) && !TextUtils.isEmpty((CharSequence)inviteeUserId)) {
            this.mMultiRoomManager.getInviteMessageElement().remove(inviteeUserId);
            if (this.mMainRoomEventsListener != null) {
                this.mMainRoomEventsListener.onResponseJoinOtherRoom(inviterRoomId, inviterUserId, inviteeRoomId, inviteeUserId, answerCode == 1, extra);
            }
        }
    }

    private void inviteNotify(InviteMessage messageContent) {
        ReportUtil.libStatus(ReportUtil.TAG.INVITE, "InviteMessage", messageContent != null ? messageContent.toString() : "null");
        if (messageContent == null) {
            FinLog.e(TAG, "inviteNotify . InviteAnswerMessage is empty .");
            return;
        }
        InviteInfo inviteInfo = messageContent.getInviteInfo();
        if (inviteInfo != null && !TextUtils.isEmpty((CharSequence)inviteInfo.getInviterRoomId()) && !TextUtils.isEmpty((CharSequence)inviteInfo.getInviterUserId())) {
            this.mMultiRoomManager.getInviteNotifyMessageElement().put(inviteInfo.getInviterUserId(), messageContent);
            if (this.mMainRoomEventsListener != null) {
                this.mMainRoomEventsListener.onRequestJoinOtherRoom(inviteInfo.getInviterRoomId(), inviteInfo.getInviterUserId(), messageContent.getExtra());
            }
        } else {
            FinLog.e(TAG, "InviteInfo is empty.");
        }
    }
}

